/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HCLArithmeticOperation
extends HCLExpression {
    public Operator op();

    public record Unary(Operator op, HCLExpression operand) implements HCLArithmeticOperation
    {
        @Override
        public String asString() {
            return this.op.toString() + HCLExpression.asString(this.operand);
        }

        @Override
        public List<? extends HCLExpression> elements() {
            return this.operand != null ? List.of(this.operand) : List.of();
        }
    }

    public record Binary(Operator op, HCLExpression left, HCLExpression right) implements HCLArithmeticOperation
    {
        @Override
        public String asString() {
            return HCLExpression.asString(this.left) + this.op.toString() + HCLExpression.asString(this.right);
        }

        @Override
        public List<? extends HCLExpression> elements() {
            return Stream.of(this.left, this.right).filter(Objects::nonNull).toList();
        }
    }

    public static enum Operator {
        NOT("!"),
        MINUS("-"),
        MUL("*"),
        DIV("/"),
        MOD("%"),
        ADD("+"),
        SUB("-"),
        OR("||"),
        AND("&&"),
        LTE("<="),
        GTE(">="),
        LT("<"),
        GT(">"),
        EQUALS("=="),
        NOT_EQUALS("!=");

        final String op;

        private Operator(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

