/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.AbstractKmsManagementClientBuilder;
import com.oracle.bmc.keymanagement.KmsManagementClient;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ExecutorService;

public class KmsManagementClientBuilder
extends AbstractKmsManagementClientBuilder<KmsManagementClientBuilder, KmsManagementClient> {
    protected ExecutorService executorService = null;

    public KmsManagementClientBuilder(Service service) {
        super(service);
    }

    public KmsManagementClientBuilder executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public KmsManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        if (authenticationDetailsProvider == null) {
            throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
        }
        String cryptoEndpoint = this.getEndpoint();
        KmsManagementClientBuilder copy = (KmsManagementClientBuilder)KmsManagementClient.builder().copyFrom(this).endpoint(cryptoEndpoint);
        return new KmsManagementClient(copy, authenticationDetailsProvider, this.executorService);
    }
}

