/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjshell;

import java.io.InputStream;

public class PipeInputStream
extends InputStream {
    public static final int INITIAL_SIZE = 128;
    private int[] buffer = new int[128];
    private int start;
    private int end;
    private boolean closed;

    @Override
    public synchronized int read() {
        while (this.start == this.end) {
            if (this.closed) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            int n = this.buffer[this.start];
            return n;
        }
        finally {
            this.start = (this.start + 1) % this.buffer.length;
        }
    }

    public synchronized void write(int b) {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        int newEnd = (this.end + 1) % this.buffer.length;
        if (newEnd == this.start) {
            int[] newBuffer = new int[this.buffer.length * 2];
            int rightPart = (this.end > this.start ? this.end : this.buffer.length) - this.start;
            int leftPart = this.end > this.start ? 0 : this.start - 1;
            System.arraycopy(this.buffer, this.start, newBuffer, 0, rightPart);
            System.arraycopy(this.buffer, 0, newBuffer, rightPart, leftPart);
            this.buffer = newBuffer;
            this.start = 0;
            this.end = rightPart + leftPart;
            newEnd = this.end + 1;
        }
        this.buffer[this.end] = b;
        this.end = newEnd;
        this.notifyAll();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }
}

