/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Realm;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.InternalBuilderAccess;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.CompositeClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.StandardClientProperties;
import com.oracle.bmc.http.internal.AuthnClientFilter;
import com.oracle.bmc.http.internal.CircuitBreakerHelper;
import com.oracle.bmc.http.internal.ClientCall;
import com.oracle.bmc.http.internal.ClientIdFilter;
import com.oracle.bmc.http.internal.LogHeadersFilter;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.EndpointBuilder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.BmcResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseClient
implements AutoCloseable {
    private static final ClientConfigurator DEFAULT_CONFIGURATOR = new DefaultConfigurator();
    private static final ClientIdFilter CLIENT_ID_FILTER = new ClientIdFilter();
    private static final LogHeadersFilter LOG_HEADERS_FILTER = new LogHeadersFilter();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Service service;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final CircuitBreakerConfiguration circuitBreakerConfiguration;
    final ClientConfiguration clientConfigurationToUse;
    private final RequestSigner defaultRequestSigner;
    private final Map<SigningStrategy, RequestSigner> requestSigners;
    private final ClientConfigurator clientConfigurator;
    private OciCircuitBreaker circuitBreaker;
    private final HttpProvider httpProvider;
    private volatile String endpoint;
    private volatile HttpClient httpClient;
    private volatile Region region;

    protected BaseClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, CircuitBreakerConfiguration circuitBreakerConfiguration) {
        Region regionFromBuilder;
        List<ClientConfigurator> additionalClientConfigurators;
        ClientConfigurator preferredClientConfigurator;
        ClientConfiguration configuration;
        this.service = InternalBuilderAccess.getService(builder);
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        this.circuitBreakerConfiguration = circuitBreakerConfiguration;
        HttpProvider httpProvider = InternalBuilderAccess.getHttpProvider(builder);
        if (httpProvider == null) {
            httpProvider = HttpProvider.getDefault();
        }
        this.httpProvider = httpProvider;
        ArrayList<ClientConfigurator> authenticationDetailsConfigurators = new ArrayList<ClientConfigurator>();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)((Object)this.authenticationDetailsProvider)).getClientConfigurators());
        }
        this.clientConfigurationToUse = (configuration = InternalBuilderAccess.getConfiguration(builder)) != null ? configuration : ClientConfiguration.builder().build();
        this.defaultRequestSigner = InternalBuilderAccess.getRequestSignerFactory(builder).createRequestSigner(this.service, this.authenticationDetailsProvider);
        this.requestSigners = new EnumMap<SigningStrategy, RequestSigner>(SigningStrategy.class);
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                this.requestSigners.put(s, InternalBuilderAccess.getSigningStrategyRequestSignerFactories(builder).get((Object)s).createRequestSigner(this.service, authenticationDetailsProvider));
            }
        }
        if ((preferredClientConfigurator = InternalBuilderAccess.getClientConfigurator(builder)) == null) {
            preferredClientConfigurator = this.getDefaultConfigurator();
        }
        if (!(additionalClientConfigurators = InternalBuilderAccess.getAdditionalClientConfigurators(builder)).isEmpty()) {
            ArrayList<ClientConfigurator> composedList = new ArrayList<ClientConfigurator>(additionalClientConfigurators.size() + 1);
            composedList.add(preferredClientConfigurator);
            composedList.addAll(additionalClientConfigurators);
            this.clientConfigurator = new CompositeClientConfigurator(composedList);
        } else {
            this.clientConfigurator = preferredClientConfigurator;
        }
        String endpoint = InternalBuilderAccess.getEndpoint(builder);
        if (this.authenticationDetailsProvider instanceof RegionProvider) {
            RegionProvider provider = (RegionProvider)((Object)this.authenticationDetailsProvider);
            if (provider.getRegion() != null) {
                this.region = provider.getRegion();
                this.setRegion(provider.getRegion());
                if (endpoint != null) {
                    this.logger.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
                }
            } else {
                this.logger.warn("Region not specified for the provider. Proceeding without setting a region. Please make sure to set a region before making an API call. Failure to do so will result in endpoint being null.");
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
        if (builder instanceof RegionalClientBuilder && (regionFromBuilder = InternalBuilderAccess.getRegion((RegionalClientBuilder)builder)) != null) {
            this.setRegion(regionFromBuilder);
        }
    }

    protected ClientConfigurator getDefaultConfigurator() {
        return DEFAULT_CONFIGURATOR;
    }

    public synchronized void useRealmSpecificEndpointTemplate(boolean useOfRealmSpecificEndpointTemplateEnabled) {
        if (this.region == null) {
            throw new NullPointerException("Cannot determine the realm since region is null or blank. useRealmSpecificEndpointTemplate() can only be used if region is set.");
        }
        String regionId = this.region.getRegionId();
        try {
            Realm realm = Region.fromRegionId(regionId).getRealm();
            if (useOfRealmSpecificEndpointTemplateEnabled && this.service.getServiceEndpointTemplateForRealmMap() == null) {
                useOfRealmSpecificEndpointTemplateEnabled = false;
                this.logger.debug("Realm-specific endpoint template not defined for realm {}, using non-realm-specific endpoint template instead.", (Object)realm.getRealmId().toLowerCase(Locale.ROOT));
            }
            String endpointTemplateToUse = useOfRealmSpecificEndpointTemplateEnabled ? EndpointBuilder.getRealmSpecificEndpointTemplate(regionId, this.service, realm) : EndpointBuilder.getServiceEndpointTemplateToUse(regionId, this.service, realm);
            this.logger.debug("Setting endpoint template to: {}", (Object)endpointTemplateToUse);
            this.setEndpoint(endpointTemplateToUse);
        }
        catch (IllegalArgumentException e) {
            this.logger.info("Cannot determine the realm for unknown regionId '{}', falling back to default endpoint format `{}`", (Object)regionId, (Object)Region.formatDefaultRegionEndpoint(this.service, regionId));
        }
    }

    public final void populateServiceParametersInEndpoint(String endpoint, Map<String, Object> requiredParametersMap) {
        if (!endpoint.contains("{")) {
            return;
        }
        List<String> parameters = this.parseEndpointForParams(endpoint);
        String updatedEndpoint = endpoint;
        if (parameters != null && parameters.size() > 0 && requiredParametersMap.isEmpty()) {
            updatedEndpoint = updatedEndpoint.replaceAll("\\{.*?\\}", "");
            this.updateBaseEndpoint(updatedEndpoint);
            return;
        }
        for (String parameter : parameters) {
            String paramName;
            boolean appendDot = false;
            if (parameter.endsWith("+Dot}")) {
                appendDot = true;
                paramName = parameter.substring(1, parameter.indexOf("+"));
            } else {
                paramName = parameter.substring(1, parameter.length() - 1);
            }
            if (requiredParametersMap.containsKey(paramName)) {
                if (!(requiredParametersMap.get(paramName) instanceof String)) {
                    this.logger.debug("The parameter for {} cannot be populated since the value is not of type String", (Object)paramName);
                    updatedEndpoint = updatedEndpoint.replace(parameter, "");
                    this.updateBaseEndpoint(updatedEndpoint);
                    continue;
                }
                if (appendDot) {
                    updatedEndpoint = updatedEndpoint.replace(parameter, requiredParametersMap.get(paramName) + ".");
                    continue;
                }
                updatedEndpoint = updatedEndpoint.replace(parameter, requiredParametersMap.get(paramName).toString());
                continue;
            }
            updatedEndpoint = updatedEndpoint.replace(parameter, "");
        }
        this.updateBaseEndpoint(updatedEndpoint);
    }

    private List<String> parseEndpointForParams(String endpointTemplate) {
        ArrayList<String> parsedParams = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(endpointTemplate);
        while (matcher.find()) {
            parsedParams.add(matcher.group());
        }
        return parsedParams;
    }

    public final synchronized void updateBaseEndpoint(String endpoint) {
        this.logger.info("Updating endpoint to {}", (Object)endpoint);
        HttpClientBuilder builder = this.httpProvider.newBuilder().baseUri(endpoint).property(StandardClientProperties.CONNECT_TIMEOUT, (Object)Duration.ofMillis(this.clientConfigurationToUse.getConnectionTimeoutMillis())).property(StandardClientProperties.READ_TIMEOUT, (Object)Duration.ofMillis(this.clientConfigurationToUse.getReadTimeoutMillis())).property(StandardClientProperties.ASYNC_POOL_SIZE, (Object)this.clientConfigurationToUse.getMaxAsyncThreads()).registerRequestInterceptor(1000, (RequestInterceptor)new AuthnClientFilter(this.defaultRequestSigner, this.requestSigners)).registerRequestInterceptor(3000, (RequestInterceptor)CLIENT_ID_FILTER).registerRequestInterceptor(5000, (RequestInterceptor)LOG_HEADERS_FILTER);
        this.clientConfigurator.customizeClient(builder);
        HttpClient oldClient = this.httpClient;
        if (oldClient != null) {
            oldClient.close();
        }
        this.httpClient = builder.build();
        this.circuitBreaker = CircuitBreakerHelper.makeCircuitBreaker(this.httpClient, this.circuitBreakerConfiguration);
    }

    public final synchronized void setEndpoint(String endpoint) {
        this.logger.info("Setting endpoint to {}", (Object)endpoint);
        this.endpoint = endpoint;
        HttpClientBuilder builder = this.httpProvider.newBuilder().baseUri(endpoint).property(StandardClientProperties.CONNECT_TIMEOUT, (Object)Duration.ofMillis(this.clientConfigurationToUse.getConnectionTimeoutMillis())).property(StandardClientProperties.READ_TIMEOUT, (Object)Duration.ofMillis(this.clientConfigurationToUse.getReadTimeoutMillis())).property(StandardClientProperties.ASYNC_POOL_SIZE, (Object)this.clientConfigurationToUse.getMaxAsyncThreads()).registerRequestInterceptor(1000, (RequestInterceptor)new AuthnClientFilter(this.defaultRequestSigner, this.requestSigners)).registerRequestInterceptor(3000, (RequestInterceptor)CLIENT_ID_FILTER).registerRequestInterceptor(5000, (RequestInterceptor)LOG_HEADERS_FILTER);
        this.clientConfigurator.customizeClient(builder);
        HttpClient oldClient = this.httpClient;
        if (oldClient != null) {
            oldClient.close();
        }
        this.httpClient = builder.build();
        OciCircuitBreaker userDefinedCircuitBreaker = this.clientConfigurationToUse.getCircuitBreaker();
        this.circuitBreaker = userDefinedCircuitBreaker != null ? userDefinedCircuitBreaker : CircuitBreakerHelper.makeCircuitBreaker(this.httpClient, this.circuitBreakerConfiguration);
    }

    public final String getEndpoint() {
        return this.endpoint;
    }

    public final synchronized void refreshClient() {
        this.setEndpoint(this.endpoint);
    }

    protected void setRegion(Region region) {
        Optional<String> endpoint;
        this.region = region;
        if (Alloy.shouldUseOnlyAlloyRegions()) {
            try {
                Region.valueOf(region.getRegionId());
            }
            catch (IllegalArgumentException e) {
                Alloy.throwUnknownAlloyRegionIfAppropriate(region.getRegionId(), e);
            }
        }
        if (!(endpoint = region.getEndpoint(this.service)).isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + this.service + " is not known in region " + region);
        }
        this.setEndpoint(endpoint.get());
    }

    protected void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            Alloy.throwUnknownAlloyRegionIfAppropriate(regionId, e);
            this.logger.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(this.service, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public final void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    protected <REQ extends BmcRequest<?>, RESP extends BmcResponse, RESP_BUILDER extends BmcResponse.Builder<RESP>> ClientCall<REQ, RESP, RESP_BUILDER> clientCall(REQ request, Supplier<RESP_BUILDER> responseBuilder) {
        return ClientCall.builder(this.httpClient, request, responseBuilder).clientConfigurator(this.clientConfigurator).authenticationDetailsProvider(this.authenticationDetailsProvider).circuitBreaker(this.circuitBreaker);
    }
}

