/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletion;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionContext;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.micronaut.completion.MicronautExpressionLanguageCompletion;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.modules.micronaut.expression.EvaluationContext;
import org.netbeans.modules.micronaut.expression.MicronautExpressionLanguageParser;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class MicronautDataCompletionTask {
    private static final String JPA_REPOSITORY_ANNOTATION_NAME = "io.micronaut.data.annotation.Repository";
    private static final String JDBC_REPOSITORY_ANNOTATION_NAME = "io.micronaut.data.jdbc.annotation.JdbcRepository";
    private static final String REPOSITORY_TYPE_NAME = "io.micronaut.data.repository.GenericRepository";
    private static final String CONTROLLER_ANNOTATION_NAME = "io.micronaut.http.annotation.Controller";
    private static final String QUERY_ANNOTATION_TYPE_NAME = "io.micronaut.data.annotation.Query";
    private static final String GET = "get";
    private static final List<String> QUERY_PATTERNS = Arrays.asList("find", "get", "query", "read", "retrieve", "search");
    private static final List<String> SPECIAL_QUERY_PATTERNS = Arrays.asList("count", "countDistinct", "delete", "eliminate", "erase", "exists", "remove", "update");
    private static final List<String> INSERT_QUERY_PATTERNS = Arrays.asList("insert", "persist", "save", "store");
    private static final List<String> QUERY_PROJECTIONS = Arrays.asList("", "Avg", "Distinct", "Max", "Min", "Sum");
    private static final List<String> CRITERION_EXPRESSIONS = Arrays.asList("", "After", "Before", "Contains", "StartingWith", "StartsWith", "EndingWith", "EndsWith", "Equal", "Equals", "NotEqual", "NotEquals", "GreaterThan", "GreaterThanEquals", "LessThan", "LessThanEquals", "Like", "Ilike", "In", "InList", "InRange", "Between", "IsNull", "IsNotNull", "IsEmpty", "IsNotEmpty", "True", "False");
    private static final List<String> COMPOSE_EXPRESSIONS = Arrays.asList("And", "Or");
    private static final String BY = "By";
    private static final String ORDER_BY = "OrderBy";
    private static final String COUNT = "count";
    private static final String EXISTS = "exists";
    private static final String EMPTY = "";
    private int anchorOffset;

    public <T> List<T> query(Document doc, final int caretOffset, final ItemFactory<T> factory) {
        final ArrayList items = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(this){
                final /* synthetic */ MicronautDataCompletionTask this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)resultIterator.getParserResult(caretOffset));
                    if (cc != null) {
                        int len;
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        this.this$0.anchorOffset = caretOffset;
                        String prefix = MicronautDataCompletionTask.EMPTY;
                        TokenSequence ts = cc.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                        if (ts.move(this.this$0.anchorOffset) == 0 || !ts.moveNext()) {
                            ts.movePrevious();
                        }
                        if ((len = this.this$0.anchorOffset - ts.offset()) > 0 && ts.token().length() >= len) {
                            if (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().equals("literal")) {
                                prefix = ts.token().text().toString().substring(0, len);
                                this.this$0.anchorOffset = ts.offset();
                            } else if (ts.token().id() == JavaTokenId.STRING_LITERAL) {
                                prefix = ts.token().text().toString().substring(1, ts.token().length() - 1);
                                this.this$0.anchorOffset = ts.offset() + 1;
                            } else if (ts.token().id() == JavaTokenId.MULTILINE_STRING_LITERAL) {
                                prefix = ts.token().text().toString().substring(3, len);
                                this.this$0.anchorOffset = ts.offset() + 3;
                            }
                        }
                        Consumer<Object> consumer = item -> {
                            if (item != null) {
                                items.add(item);
                            }
                        };
                        TreeUtilities treeUtilities = cc.getTreeUtilities();
                        SourcePositions sp = cc.getTrees().getSourcePositions();
                        TreePath path = treeUtilities.pathFor(this.this$0.anchorOffset);
                        switch (path.getLeaf().getKind()) {
                            case CLASS: 
                            case INTERFACE: {
                                String headerText;
                                int idx;
                                int startPos = (int)sp.getEndPosition(cc.getCompilationUnit(), ((ClassTree)path.getLeaf()).getModifiers());
                                if (startPos <= 0) {
                                    startPos = (int)sp.getStartPosition(cc.getCompilationUnit(), path.getLeaf());
                                }
                                if ((idx = (headerText = cc.getText().substring(startPos, this.this$0.anchorOffset)).indexOf(123)) < 0) break;
                                this.this$0.resolveFinderMethods((CompilationInfo)cc, path, prefix, true, factory, consumer);
                                this.this$0.resolveControllerMethods((CompilationInfo)cc, path, prefix, factory, consumer);
                                break;
                            }
                            case METHOD: {
                                Tree returnType = ((MethodTree)path.getLeaf()).getReturnType();
                                if (returnType == null) break;
                                TokenSequence last = MicronautDataCompletionTask.findLastNonWhitespaceToken((TokenSequence<JavaTokenId>)ts, (int)sp.getEndPosition(path.getCompilationUnit(), returnType), this.this$0.anchorOffset);
                                if (last == null) {
                                    this.this$0.resolveFinderMethods((CompilationInfo)cc, path.getParentPath(), prefix, false, factory, consumer);
                                    break;
                                }
                                if (last.token().id() != JavaTokenId.LPAREN && last.token().id() != JavaTokenId.COMMA) break;
                                this.this$0.resolveFinderMethodParams((CompilationInfo)cc, path, prefix, factory, consumer);
                                break;
                            }
                            case VARIABLE: {
                                TreePath parentPath;
                                Tree type = ((VariableTree)path.getLeaf()).getType();
                                if (type == null || MicronautDataCompletionTask.findLastNonWhitespaceToken((TokenSequence<JavaTokenId>)ts, (int)sp.getEndPosition(path.getCompilationUnit(), type), this.this$0.anchorOffset) != null || (parentPath = path.getParentPath()).getLeaf().getKind() != Tree.Kind.CLASS && parentPath.getLeaf().getKind() != Tree.Kind.INTERFACE) break;
                                this.this$0.resolveFinderMethods((CompilationInfo)cc, parentPath, prefix, false, factory, consumer);
                                break;
                            }
                            case STRING_LITERAL: {
                                if (path.getParentPath().getLeaf().getKind() != Tree.Kind.ASSIGNMENT || path.getParentPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) break;
                                this.this$0.resolveExpressionLanguage((CompilationInfo)cc, path.getParentPath(), prefix, caretOffset - this.this$0.anchorOffset, factory, consumer);
                                this.this$0.resolveQueryAnnotation((CompilationInfo)cc, path.getParentPath().getParentPath(), prefix, caretOffset - this.this$0.anchorOffset, factory, consumer);
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return items;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    private <T> void resolveExpressionLanguage(CompilationInfo info, TreePath path, String prefix, int off, ItemFactory<T> factory, Consumer<T> consumer) {
        Matcher matcher = MicronautExpressionLanguageParser.MEXP_PATTERN.matcher(prefix);
        while (matcher.find() && matcher.groupCount() == 1) {
            EvaluationContext ctx;
            if (off < matcher.start(1) || off > matcher.end(1) || (ctx = EvaluationContext.get(info, path)) == null) continue;
            MicronautExpressionLanguageCompletion completion = new MicronautExpressionLanguageCompletion(info, ctx, matcher.group(1), this.anchorOffset + matcher.start(1));
            MicronautExpressionLanguageCompletion.Result<T> result = completion.query(off - matcher.start(1), factory);
            int newOffset = result.getAnchorOffset();
            if (newOffset >= 0) {
                this.anchorOffset = newOffset;
            }
            for (T item : result.getItems()) {
                consumer.accept(item);
            }
        }
    }

    private <T> void resolveQueryAnnotation(CompilationInfo info, TreePath path, String prefix, int off, ItemFactory<T> factory, Consumer<T> consumer) {
        TreePath clsPath;
        Element el = info.getTrees().getElement(path);
        if (el instanceof TypeElement && QUERY_ANNOTATION_TYPE_NAME.contentEquals(((TypeElement)el).getQualifiedName()) && (clsPath = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path)) != null && Utils.getAnnotation(info.getTrees().getElement(clsPath).getAnnotationMirrors(), JDBC_REPOSITORY_ANNOTATION_NAME) != null) {
            SQLCompletionContext ctx = SQLCompletionContext.empty().setStatement((CharSequence)prefix).setOffset(off).setDatabaseConnection(ConnectionManager.getDefault().getPreferredConnection(true));
            SQLCompletion completion = SQLCompletion.create((SQLCompletionContext)ctx);
            SQLCompletionResultSet resultSet = SQLCompletionResultSet.create();
            completion.query(resultSet, (component, offset, text) -> {
                int caretOffset = component.getCaretPosition();
                StyledDocument document = (StyledDocument)component.getDocument();
                try {
                    NbDocument.runAtomicAsUser((StyledDocument)document, () -> {
                        try {
                            int documentOffset = this.anchorOffset + offset;
                            document.remove(documentOffset, caretOffset - documentOffset);
                            document.insertString(documentOffset, text.replace("\"", "\\\""), null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    });
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            });
            int newOffset = resultSet.getAnchorOffset();
            if (newOffset >= 0) {
                this.anchorOffset = newOffset;
            }
            for (CompletionItem item : resultSet.getItems()) {
                consumer.accept(factory.createSQLItem(item));
            }
        }
    }

    private <T> void resolveControllerMethods(CompilationInfo info, TreePath path, String prefix, ItemFactory<T> factory, Consumer<T> consumer) {
        TypeElement te = (TypeElement)info.getTrees().getElement(path);
        AnnotationMirror controllerAnn = Utils.getAnnotation(te.getAnnotationMirrors(), CONTROLLER_ANNOTATION_NAME);
        if (controllerAnn != null) {
            List<VariableElement> repositories = Utils.getRepositoriesFor(info, te);
            if (repositories.isEmpty()) {
                Utils.collectMissingEndpoints(info, te, (annName, controllerId) -> consumer.accept(factory.createControllerMethodItem(info, annName, controllerId, this.anchorOffset)));
            } else {
                Utils.collectMissingDataEndpoints(info, te, prefix, (repository, delegateMethod, controllerId, id) -> consumer.accept(factory.createControllerMethodItem(info, repository, delegateMethod, controllerId, id, this.anchorOffset)));
            }
        }
    }

    private <T> void resolveFinderMethods(CompilationInfo info, TreePath path, String prefix, boolean full, ItemFactory<T> factory, Consumer<T> consumer) throws IOException {
        TypeElement entity = MicronautDataCompletionTask.getEntityFor(info, path);
        if (entity != null) {
            TypeUtilities tu = info.getTypeUtilities();
            LinkedHashMap<String, String> prop2Types = new LinkedHashMap<String, String>();
            for (VariableElement variableElement : ElementFilter.fieldsIn(entity.getEnclosedElements())) {
                TypeMirror type = variableElement.asType();
                if (type.getKind() == TypeKind.ERROR) continue;
                String name = variableElement.getSimpleName().toString();
                prop2Types.put(name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), tu.getTypeName(type, new TypeUtilities.TypeNameOptions[0]).toString());
            }
            for (String pattern : QUERY_PATTERNS) {
                if (Utils.startsWith(pattern, prefix) && (full || pattern.length() > prefix.length())) {
                    consumer.accept(full ? factory.createFinderMethodItem(pattern, entity.getSimpleName().toString(), this.anchorOffset) : factory.createFinderMethodNameItem(EMPTY, pattern, this.anchorOffset));
                }
                String name = pattern + BY;
                if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                    this.addPropertyCriterionCompletions(prop2Types, name, prefix, full ? entity.getSimpleName().toString() : null, factory, consumer);
                } else if (Utils.startsWith(name, prefix)) {
                    consumer.accept(full ? factory.createFinderMethodItem(name, entity.getSimpleName().toString(), this.anchorOffset) : factory.createFinderMethodNameItem(EMPTY, name, this.anchorOffset));
                }
                for (String projection : QUERY_PROJECTIONS) {
                    for (String propName : prop2Types.keySet()) {
                        name = pattern + projection + propName + BY;
                        if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                            this.addPropertyCriterionCompletions(prop2Types, name, prefix, full ? (String)prop2Types.get(propName) : null, factory, consumer);
                            continue;
                        }
                        if (!Utils.startsWith(name, prefix)) continue;
                        consumer.accept(full ? factory.createFinderMethodItem(name, (String)prop2Types.get(propName), this.anchorOffset) : factory.createFinderMethodNameItem(EMPTY, name, this.anchorOffset));
                    }
                }
            }
            for (String pattern : SPECIAL_QUERY_PATTERNS) {
                if (Utils.startsWith(pattern, prefix) && (full || pattern.length() > prefix.length())) {
                    consumer.accept(full ? factory.createFinderMethodItem(pattern, pattern.startsWith(COUNT) ? "int" : (pattern.startsWith(EXISTS) ? "boolean" : "void"), this.anchorOffset) : factory.createFinderMethodNameItem(EMPTY, pattern, this.anchorOffset));
                }
                for (String propName : prop2Types.keySet()) {
                    String name = pattern + BY + propName;
                    if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                        this.addCriterionCompletions(prop2Types, name, prefix, full ? (pattern.startsWith(COUNT) ? "int" : (pattern.startsWith(EXISTS) ? "boolean" : "void")) : null, factory, consumer);
                        continue;
                    }
                    if (!Utils.startsWith(name, prefix)) continue;
                    consumer.accept(full ? factory.createFinderMethodItem(name, name.startsWith(COUNT) ? "int" : (name.startsWith(EXISTS) ? "boolean" : "void"), this.anchorOffset) : factory.createFinderMethodNameItem(EMPTY, name, this.anchorOffset));
                }
            }
            for (String pattern : INSERT_QUERY_PATTERNS) {
                if (!Utils.startsWith(pattern, prefix) || !full && pattern.length() <= prefix.length()) continue;
                consumer.accept(full ? factory.createFinderMethodItem(pattern, entity.getSimpleName().toString(), this.anchorOffset) : factory.createFinderMethodNameItem(EMPTY, pattern, this.anchorOffset));
            }
        }
    }

    private <T> void addPropertyCriterionCompletions(Map<String, String> prop2Types, String namePrefix, String prefix, String returnType, ItemFactory<T> factory, Consumer<T> consumer) {
        for (String propName : prop2Types.keySet()) {
            this.addCriterionCompletions(prop2Types, namePrefix + propName, prefix, returnType, factory, consumer);
        }
    }

    private <T> void addCriterionCompletions(Map<String, String> prop2Types, String namePrefix, String prefix, String returnType, ItemFactory<T> factory, Consumer<T> consumer) {
        for (String criterion : CRITERION_EXPRESSIONS) {
            if (prefix.length() >= namePrefix.length() + criterion.length() && prefix.startsWith(namePrefix + criterion)) {
                this.addComposeAndOrderCompletions(prop2Types, namePrefix + criterion, prefix, returnType, factory, consumer);
                continue;
            }
            if (!Utils.startsWith(namePrefix + criterion, prefix)) continue;
            consumer.accept(returnType != null ? factory.createFinderMethodItem(namePrefix + criterion, returnType, this.anchorOffset) : factory.createFinderMethodNameItem(namePrefix, criterion, this.anchorOffset));
        }
    }

    private <T> void addComposeAndOrderCompletions(Map<String, String> prop2Types, String namePrefix, String prefix, String returnType, ItemFactory<T> factory, Consumer<T> consumer) {
        for (String name : COMPOSE_EXPRESSIONS) {
            if (prefix.length() >= namePrefix.length() + name.length() && prefix.startsWith(namePrefix + name)) {
                this.addPropertyCriterionCompletions(prop2Types, namePrefix + name, prefix, returnType, factory, consumer);
                continue;
            }
            if (!Utils.startsWith(namePrefix + name, prefix)) continue;
            consumer.accept(returnType != null ? factory.createFinderMethodItem(namePrefix + name, returnType, this.anchorOffset) : factory.createFinderMethodNameItem(namePrefix, name, this.anchorOffset));
        }
        for (String propName : prop2Types.keySet()) {
            String name = ORDER_BY + propName;
            if (prefix.length() >= namePrefix.length() + name.length() || !Utils.startsWith(namePrefix + name, prefix)) continue;
            consumer.accept(returnType != null ? factory.createFinderMethodItem(namePrefix + name, returnType, this.anchorOffset) : factory.createFinderMethodNameItem(namePrefix, name, this.anchorOffset));
        }
    }

    private <T> void resolveFinderMethodParams(CompilationInfo info, TreePath path, String prefix, ItemFactory<T> factory, Consumer<T> consumer) {
        TypeElement entity = MicronautDataCompletionTask.getEntityFor(info, path.getParentPath());
        if (entity != null) {
            MethodTree method = (MethodTree)path.getLeaf();
            SourcePositions sp = info.getTrees().getSourcePositions();
            HashSet<String> paramNames = new HashSet<String>();
            for (VariableTree variableTree : method.getParameters()) {
                if (sp.getEndPosition(path.getCompilationUnit(), variableTree) >= (long)this.anchorOffset) continue;
                paramNames.add(variableTree.getName().toString());
            }
            LinkedHashMap<String, VariableElement> prop2fields = new LinkedHashMap<String, VariableElement>();
            for (VariableElement variableElement : ElementFilter.fieldsIn(entity.getEnclosedElements())) {
                TypeMirror type;
                String name = variableElement.getSimpleName().toString();
                if (paramNames.contains(name) || (type = variableElement.asType()).getKind() == TypeKind.ERROR) continue;
                prop2fields.put(name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), variableElement);
                consumer.accept(factory.createFinderMethodParam(info, variableElement, this.anchorOffset));
            }
            if (paramNames.isEmpty() && !prop2fields.isEmpty()) {
                this.addParamsParsedFromFinderMethodName(info, prop2fields, method.getName().toString(), factory, consumer);
            }
        }
    }

    private <T> void addParamsParsedFromFinderMethodName(CompilationInfo info, Map<String, VariableElement> prop2fields, String name, ItemFactory<T> factory, Consumer<T> consumer) {
        for (String pattern : QUERY_PATTERNS) {
            int idx;
            if (!name.startsWith(pattern) || (idx = (name = name.substring(pattern.length())).indexOf(BY)) < 0) continue;
            name = name.substring(idx + 2);
            ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
            int lastLen = Integer.MAX_VALUE;
            while (name.length() < lastLen) {
                lastLen = name.length();
                for (Map.Entry<String, VariableElement> entry : prop2fields.entrySet()) {
                    String propName = entry.getKey();
                    if (!name.startsWith(propName)) continue;
                    fields.add(entry.getValue());
                    name = name.substring(propName.length());
                }
                for (String criterion : CRITERION_EXPRESSIONS) {
                    for (String expr : COMPOSE_EXPRESSIONS) {
                        if (!name.startsWith(criterion + expr)) continue;
                        name = name.substring(criterion.length() + expr.length());
                    }
                }
            }
            if (fields.isEmpty()) continue;
            consumer.accept(factory.createFinderMethodParams(info, fields, this.anchorOffset));
        }
    }

    private static TypeElement getEntityFor(CompilationInfo info, TreePath path) {
        TypeElement te = (TypeElement)info.getTrees().getElement(path);
        if (te.getModifiers().contains((Object)Modifier.ABSTRACT) && Utils.getAnnotation(te.getAnnotationMirrors(), JPA_REPOSITORY_ANNOTATION_NAME) != null) {
            Types types = info.getTypes();
            TypeMirror repositoryType = types.erasure(info.getElements().getTypeElement(REPOSITORY_TYPE_NAME).asType());
            for (TypeMirror typeMirror : te.getInterfaces()) {
                TypeMirror entityType;
                List<? extends TypeMirror> typeArguments;
                if (typeMirror.getKind() != TypeKind.DECLARED || !types.isSubtype(types.erasure(typeMirror), repositoryType) || (typeArguments = ((DeclaredType)typeMirror).getTypeArguments()).isEmpty() || (entityType = typeArguments.get(0)) == null || entityType.getKind() != TypeKind.DECLARED) continue;
                return (TypeElement)((DeclaredType)entityType).asElement();
            }
        }
        return null;
    }

    private static TokenSequence<JavaTokenId> findLastNonWhitespaceToken(TokenSequence<JavaTokenId> ts, int startPos, int endPos) {
        ts.move(endPos);
        TokenSequence<JavaTokenId> last = MicronautDataCompletionTask.previousNonWhitespaceToken(ts);
        if (last == null || last.offset() < startPos) {
            return null;
        }
        return last;
    }

    private static TokenSequence<JavaTokenId> previousNonWhitespaceToken(TokenSequence<JavaTokenId> ts) {
        block3: while (ts.movePrevious()) {
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block3;
                }
            }
            return ts;
        }
        return null;
    }

    public static interface ItemFactory<T>
    extends MicronautExpressionLanguageCompletion.ItemFactory<T> {
        public T createControllerMethodItem(CompilationInfo var1, String var2, String var3, int var4);

        public T createControllerMethodItem(CompilationInfo var1, VariableElement var2, ExecutableElement var3, String var4, String var5, int var6);

        public T createFinderMethodItem(String var1, String var2, int var3);

        public T createFinderMethodNameItem(String var1, String var2, int var3);

        public T createFinderMethodParam(CompilationInfo var1, VariableElement var2, int var3);

        public T createFinderMethodParams(CompilationInfo var1, List<VariableElement> var2, int var3);

        public T createSQLItem(CompletionItem var1);
    }
}

