/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.customizer;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferencesValidator;
import org.netbeans.modules.javascript.nodejs.ui.customizer.Bundle;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class NodeJsRunPanel
extends JPanel
implements CustomizerPanelImplementation {
    public static final String IDENTIFIER = "node.js";
    private final Project project;
    private final NodeJsPreferences preferences;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile String startFile;
    private volatile String args;
    private volatile boolean restart;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JCheckBox restartCheckBox;
    private JLabel runOnNodeJsLabel;
    private JButton startFileBrowseButton;
    private JLabel startFileLabel;
    private JTextField startFileTextField;

    public NodeJsRunPanel(Project project) {
        assert (project != null);
        this.project = project;
        this.preferences = NodeJsSupport.forProject(project).getPreferences();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.startFile = this.preferences.getStartFile();
        this.startFileTextField.setText(this.startFile);
        this.args = this.preferences.getStartArgs();
        this.argsTextField.setText(this.args);
        this.restart = this.preferences.isRunRestart();
        this.restartCheckBox.setSelected(this.restart);
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.startFileTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.argsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.restartCheckBox.addItemListener(new DefaultItemListener());
        if (!NodeJsUtils.isJsLibrary(this.project)) {
            this.runOnNodeJsLabel.setVisible(false);
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.NodeJsRunPanel_name();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this;
    }

    public String getErrorMessage() {
        return this.validateData().getFirstErrorMessage();
    }

    public String getWarningMessage() {
        String warning = this.validateData().getFirstWarningMessage();
        if (warning != null) {
            return warning;
        }
        if (NodeJsUtils.getSourceRoots(this.project).isEmpty()) {
            return Bundle.NodeJsRunPanel_sources_none();
        }
        return null;
    }

    public void save() {
        assert (!EventQueue.isDispatchThread());
        this.preferences.setStartFile(this.startFile);
        this.preferences.setStartArgs(this.args);
        this.preferences.setRunRestart(this.restart);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private ValidationResult validateData() {
        return new NodeJsPreferencesValidator().validateRun(this.startFile, this.args).getResult();
    }

    private void initComponents() {
        this.runOnNodeJsLabel = new JLabel();
        this.startFileLabel = new JLabel();
        this.startFileTextField = new JTextField();
        this.startFileBrowseButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.restartCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.runOnNodeJsLabel, (String)NbBundle.getMessage(NodeJsRunPanel.class, (String)"NodeJsRunPanel.runOnNodeJsLabel.text"));
        this.startFileLabel.setLabelFor(this.startFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.startFileLabel, (String)NbBundle.getMessage(NodeJsRunPanel.class, (String)"NodeJsRunPanel.startFileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.startFileBrowseButton, (String)NbBundle.getMessage(NodeJsRunPanel.class, (String)"NodeJsRunPanel.startFileBrowseButton.text"));
        this.startFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsRunPanel.this.startFileBrowseButtonActionPerformed(evt);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(NodeJsRunPanel.class, (String)"NodeJsRunPanel.argsLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.restartCheckBox, (String)NbBundle.getMessage(NodeJsRunPanel.class, (String)"NodeJsRunPanel.restartCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.argsLabel).addComponent(this.startFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.startFileTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startFileBrowseButton)).addComponent(this.argsTextField))).addComponent(this.runOnNodeJsLabel).addComponent(this.restartCheckBox));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.runOnNodeJsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startFileTextField, -2, -1, -2).addComponent(this.startFileBrowseButton).addComponent(this.startFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.argsLabel).addComponent(this.argsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restartCheckBox)));
    }

    private void startFileBrowseButtonActionPerformed(ActionEvent evt) {
        File file;
        assert (EventQueue.isDispatchThread());
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(NodeJsRunPanel.class).setFilesOnly(true).setTitle(Bundle.NodeJsRunPanel_browse_title());
        File sourceRoot = NodeJsUtils.getSourceRoot(this.project);
        if (sourceRoot != null) {
            fileChooserBuilder.setDefaultWorkingDirectory(sourceRoot).forceUseOfDefaultWorkingDirectory(true);
        }
        if ((file = fileChooserBuilder.showOpenDialog()) != null) {
            this.startFileTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            NodeJsRunPanel.this.startFile = NodeJsRunPanel.this.startFileTextField.getText();
            NodeJsRunPanel.this.args = NodeJsRunPanel.this.argsTextField.getText();
            NodeJsRunPanel.this.fireChange();
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            NodeJsRunPanel.this.restart = NodeJsRunPanel.this.restartCheckBox.isSelected();
            NodeJsRunPanel.this.fireChange();
        }
    }
}

