/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.web.core.WebExecSupport;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.openide.actions.OpenAction;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class JspNode
extends DataNode {
    private static final String EXECUTION_SET_NAME = "Execution";
    private static final String SHEETNAME_TEXT_PROPERTIES = "textProperties";
    private static final String ICON_JSP = "org/netbeans/modules/web/core/resources/jsp16.gif";
    private static final String ICON_TAG = "org/netbeans/modules/web/core/resources/tag16.gif";
    private static final String ICON_JSP_XML = "org/netbeans/modules/web/core/resources/jsp-xml16.gif";
    private static final String ICON_JSP_FRAGMENT = "org/netbeans/modules/web/core/resources/jsp-fragment16.gif";
    public static final String PROP_FILE_ENCODING = "encoding";
    public static final String PROP_REQUEST_PARAMS = "requestparams";

    public JspNode(JspDataObject jdo) {
        super((DataObject)jdo, Children.LEAF);
        this.initialize();
    }

    private void initialize() {
        this.setIconBaseWithExtension(this.getIconBase());
        if (this.isTagFile()) {
            this.setShortDescription(NbBundle.getMessage(JspNode.class, (String)"LBL_tagNodeShortDesc"));
        } else {
            this.setShortDescription(NbBundle.getMessage(JspNode.class, (String)"LBL_jspNodeShortDesc"));
        }
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    private String getExtension() {
        return this.getDataObject().getPrimaryFile().getExt();
    }

    private boolean isTagFile() {
        String ext = this.getExtension();
        return ext.equals("tagf") || ext.equals("tagx") || ext.equals("tag");
    }

    public DataObject getDataObject() {
        return super.getDataObject();
    }

    protected Sheet createSheet() {
        Sheet.Set ps;
        Sheet sheet = super.createSheet();
        if (!this.isTagFile()) {
            ps = new Sheet.Set();
            ps.setName(EXECUTION_SET_NAME);
            ps.setDisplayName(NbBundle.getBundle(JspNode.class).getString("PROP_executionSetName"));
            ps.setShortDescription(NbBundle.getBundle(JspNode.class).getString("HINT_executionSetName"));
            ps.put((Node.Property)new PropertySupport.ReadWrite<String>(PROP_REQUEST_PARAMS, String.class, NbBundle.getBundle(JspNode.class).getString("PROP_requestParams"), NbBundle.getBundle(JspNode.class).getString("HINT_requestParams")){

                public String getValue() {
                    return JspNode.getRequestParams(((MultiDataObject)JspNode.this.getDataObject()).getPrimaryEntry());
                }

                public void setValue(String val) throws InvocationTargetException {
                    try {
                        JspNode.setRequestParams(((MultiDataObject)JspNode.this.getDataObject()).getPrimaryEntry(), val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            sheet.put(ps);
        }
        ps = new Sheet.Set();
        ps.setName(SHEETNAME_TEXT_PROPERTIES);
        ps.setDisplayName(NbBundle.getBundle(JspNode.class).getString("PROP_textfileSetName"));
        ps.setShortDescription(NbBundle.getBundle(JspNode.class).getString("HINT_textfileSetName"));
        sheet.put(ps);
        ps.put((Node.Property)new PropertySupport.ReadOnly<String>(PROP_FILE_ENCODING, String.class, NbBundle.getBundle(JspNode.class).getString("PROP_fileEncoding"), NbBundle.getBundle(JspNode.class).getString("HINT_fileEncoding")){

            public String getValue() {
                return ((JspDataObject)JspNode.this.getDataObject()).getFileEncoding();
            }
        });
        return sheet;
    }

    static final void wrapThrowable(Throwable outer, Throwable inner, String message) {
        outer.initCause(inner);
        Exceptions.attachMessage((Throwable)outer, (String)message);
    }

    static void setRequestParams(MultiDataObject.Entry entry, String params) throws IOException {
        StringBuffer newParams = new StringBuffer();
        String s = null;
        if (params != null) {
            for (int i = 0; i < params.length(); ++i) {
                char ch = params.charAt(i);
                if (ch == '\r' || ch == '\n') continue;
                newParams.append(ch);
            }
            s = newParams.toString();
            if (s.length() == 0) {
                s = null;
            }
        }
        WebExecSupport.setQueryString(entry.getFile(), s);
    }

    static String getRequestParams(MultiDataObject.Entry entry) {
        return WebExecSupport.getQueryString(entry.getFile());
    }

    protected String getIconBase() {
        String ext = this.getDataObject().getPrimaryFile().getExt();
        if (ext.equals("tagf") || ext.equals("tagx") || ext.equals("tag")) {
            return ICON_TAG;
        }
        if (ext.equals("jsf") || ext.equals("jspf")) {
            return ICON_JSP_FRAGMENT;
        }
        if (ext.equals("jspx")) {
            return ICON_JSP_XML;
        }
        return ICON_JSP;
    }
}

