/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class AbstractEntryWithSources
extends AbstractEntry {
    private LocalizedBundleInfo bundleInfo;
    private Set<String> allPackageNames;
    private final String src;
    private FileObject sourceFO;

    protected AbstractEntryWithSources(String src) {
        this.src = src;
    }

    @Override
    protected LocalizedBundleInfo getBundleInfo() {
        if (this.bundleInfo == null) {
            this.bundleInfo = ModuleList.loadBundleInfo(this.getSourceLocation());
        }
        return this.bundleInfo;
    }

    @Override
    protected Set<String> computePublicClassNamesInMainModule() throws IOException {
        HashSet<String> result = new HashSet<String>();
        File srcF = new File(this.getSourceLocation(), this.src);
        for (ManifestManager.PackageExport p : this.getPublicPackages()) {
            String pkg = p.getPackage();
            this.scanForClasses(result, pkg, new File(srcF, pkg.replace('.', File.separatorChar)), p.isRecursive());
        }
        return result;
    }

    @Override
    public synchronized Set<String> getAllPackageNames() {
        if (this.allPackageNames == null) {
            this.allPackageNames = ApisupportAntUtils.scanProjectForPackageNames(this.getSourceLocation());
        }
        return this.allPackageNames;
    }

    private FileObject getSourceLocationFileObject() {
        if (this.sourceFO == null || !this.sourceFO.isValid()) {
            this.sourceFO = FileUtil.toFileObject((File)this.getSourceLocation());
        }
        return this.sourceFO;
    }

    private void scanForClasses(Set<String> result, String pkg, File dir, boolean recurse) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        File[] kids = dir.listFiles();
        if (kids == null) {
            throw new IOException(dir.getAbsolutePath());
        }
        for (File kid : kids) {
            String name = kid.getName();
            if (name.endsWith(".java")) {
                String basename = name.substring(0, name.length() - 5);
                result.add(pkg + "." + basename);
            }
            if (!recurse || !kid.isDirectory()) continue;
            this.scanForClasses(result, pkg + "." + name, kid, true);
        }
    }

    @Override
    public String[] getRunDependencies() {
        NbModuleProject project;
        TreeSet<String> deps = new TreeSet<String>();
        FileObject source = this.getSourceLocationFileObject();
        if (source == null) {
            return new String[0];
        }
        try {
            Project p = ProjectManager.getDefault().findProject(source);
            project = p == null ? null : (NbModuleProject)p.getLookup().lookup(NbModuleProject.class);
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
            return new String[0];
        }
        if (project == null) {
            return new String[0];
        }
        Element data = project.getPrimaryConfigurationData();
        Element moduleDependencies = XMLUtil.findElement((Element)data, (String)"module-dependencies", (String)"http://www.netbeans.org/ns/nb-module-project/3");
        assert (moduleDependencies != null) : "Malformed metadata in " + String.valueOf(project);
        for (Element dep : XMLUtil.findSubElements((Element)moduleDependencies)) {
            if (XMLUtil.findElement((Element)dep, (String)"run-dependency", (String)"http://www.netbeans.org/ns/nb-module-project/3") == null) continue;
            Element cnbEl = XMLUtil.findElement((Element)dep, (String)"code-name-base", (String)"http://www.netbeans.org/ns/nb-module-project/3");
            String cnb = XMLUtil.findText((Node)cnbEl);
            deps.add(cnb);
        }
        return deps.toArray(new String[0]);
    }

    @Override
    public String getSpecificationVersion() {
        FileObject source = this.getSourceLocationFileObject();
        if (source != null) {
            try {
                NbModuleProject project = (NbModuleProject)ProjectManager.getDefault().findProject(source);
                if (project != null) {
                    return project.getSpecVersion();
                }
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        return null;
    }
}

