/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.Bundle;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.customizer.MainClassChooser;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.runjar.MavenExecuteUtils;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RunJarPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String PROFILE_CMD = "profile";
    private ModelHandle2 handle;
    private NbMavenProjectImpl project;
    private NetbeansActionMapping run;
    private NetbeansActionMapping debug;
    private NetbeansActionMapping profile;
    private String oldMainClass;
    private String oldParams;
    private String oldVMParams;
    private String oldWorkDir;
    private DocumentListener docListener;
    private ActionListener comboListener;
    private ProjectCustomizer.Category category;
    private MavenExecuteUtils.ExecutionEnvHelper execEnvHelper;
    private JButton btnMainClass;
    private JButton btnWorkDir;
    private JComboBox comConfiguration;
    private JButton customizeOptionsButton;
    private JScrollPane jScrollPane1;
    private JLabel lblArguments;
    private JLabel lblConfiguration;
    private JLabel lblHint;
    private JLabel lblMainClass;
    private JLabel lblVMOptions;
    private JLabel lblWorkDir;
    private JTextField txtArguments;
    private JTextField txtMainClass;
    private JTextArea txtVMOptions;
    private JTextField txtWorkDir;
    private JCheckBox wrapCheckBox;

    public RunJarPanel(ModelHandle2 handle, NbMavenProjectImpl project, ProjectCustomizer.Category category) {
        SourceGroup sourceGroup;
        int i;
        this.initComponents();
        boolean isVMOptionsWrap = MavenSettings.getDefault().isVMOptionsWrap();
        this.wrapCheckBox.setSelected(isVMOptionsWrap);
        this.txtVMOptions.setLineWrap(isVMOptionsWrap);
        this.category = category;
        this.handle = handle;
        this.project = project;
        this.comConfiguration.setEditable(false);
        this.comConfiguration.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component com = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (com instanceof JLabel && value == RunJarPanel.this.handle.getActiveConfiguration()) {
                    com.setFont(com.getFont().deriveFont(1));
                }
                return com;
            }
        });
        this.setupConfigurations();
        this.initValues();
        this.lblMainClass.setFont(this.lblMainClass.getFont().deriveFont(1));
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        Sources srcs = ProjectUtils.getSources((Project)project);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        for (i = 0; i < grps.length; ++i) {
            sourceGroup = grps[i];
            if (!"1SourceRoot".equals(sourceGroup.getName())) continue;
            roots.add(sourceGroup.getRootFolder());
        }
        grps = srcs.getSourceGroups("GeneratedSources");
        for (i = 0; i < grps.length; ++i) {
            sourceGroup = grps[i];
            roots.add(sourceGroup.getRootFolder());
        }
        this.btnMainClass.addActionListener(new MainClassListener(roots.toArray(new FileObject[0]), this.txtMainClass));
        this.docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                RunJarPanel.this.applyChanges();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                RunJarPanel.this.applyChanges();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                RunJarPanel.this.applyChanges();
            }
        };
        this.comboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunJarPanel.this.removeListeners();
                RunJarPanel.this.initValues();
                RunJarPanel.this.addListeners();
            }
        };
    }

    private void addListeners() {
        this.comConfiguration.addActionListener(this.comboListener);
        this.txtMainClass.getDocument().addDocumentListener(this.docListener);
        this.txtArguments.getDocument().addDocumentListener(this.docListener);
        this.txtVMOptions.getDocument().addDocumentListener(this.docListener);
        this.txtWorkDir.getDocument().addDocumentListener(this.docListener);
    }

    private void removeListeners() {
        this.comConfiguration.removeActionListener(this.comboListener);
        this.txtMainClass.getDocument().removeDocumentListener(this.docListener);
        this.txtArguments.getDocument().removeDocumentListener(this.docListener);
        this.txtVMOptions.getDocument().removeDocumentListener(this.docListener);
        this.txtWorkDir.getDocument().removeDocumentListener(this.docListener);
    }

    private NetbeansActionMapping getMapping(String action, ProjectConfiguration c) {
        NetbeansActionMapping r = null;
        r = c != null ? ModelHandle2.getMapping(action, this.project, c) : ModelHandle2.getDefaultMapping(action, this.project);
        return r;
    }

    private void initValues() {
        this.run = null;
        this.debug = null;
        this.profile = null;
        ModelHandle2.Configuration sel = (ModelHandle2.Configuration)this.comConfiguration.getSelectedItem();
        ActionToGoalMapping mapp = this.handle.getActionMappings((ModelHandle2.Configuration)this.comConfiguration.getSelectedItem());
        List<NetbeansActionMapping> lst = mapp.getActions();
        for (NetbeansActionMapping m : lst) {
            if ("run".equals(m.getActionName())) {
                this.run = m;
            }
            if ("debug".equals(m.getActionName())) {
                this.debug = m;
            }
            if (!PROFILE_CMD.equals(m.getActionName())) continue;
            this.profile = m;
        }
        M2ConfigProvider prov = (M2ConfigProvider)this.project.getLookup().lookup(M2ConfigProvider.class);
        M2Configuration config = null;
        if (prov != null && "%%DEFAULT%%".equals((config = (M2Configuration)prov.getConfigurations().stream().filter(c -> c.getId().equals(sel.getId())).findAny().orElse(null)).getId())) {
            config = null;
        }
        if (this.run == null) {
            this.run = this.getMapping("run", config);
        }
        if (this.debug == null) {
            this.debug = this.getMapping("debug", config);
        }
        if (this.profile == null) {
            this.profile = this.getMapping(PROFILE_CMD, config);
        }
        this.execEnvHelper = MavenExecuteUtils.createExecutionEnvHelper(this.project, this.run, this.debug, this.profile, mapp);
        this.execEnvHelper.loadFromProject();
        if (this.execEnvHelper.isValid()) {
            this.oldWorkDir = this.execEnvHelper.getWorkDir();
            this.oldVMParams = this.execEnvHelper.getVmParams();
            this.oldParams = this.execEnvHelper.getAppParams();
            this.oldMainClass = this.execEnvHelper.getMainClass();
            this.txtMainClass.setEnabled(true);
            this.txtArguments.setEnabled(true);
            this.txtVMOptions.setEnabled(true);
            this.btnMainClass.setEnabled(true);
            this.txtWorkDir.setEnabled(true);
            this.btnWorkDir.setEnabled(true);
            this.category.setErrorMessage(null);
            this.customizeOptionsButton.setEnabled(true);
            this.wrapCheckBox.setEnabled(true);
        } else {
            this.txtMainClass.setEnabled(false);
            this.txtArguments.setEnabled(false);
            this.txtVMOptions.setEnabled(false);
            this.txtWorkDir.setEnabled(false);
            this.btnWorkDir.setEnabled(false);
            this.btnMainClass.setEnabled(false);
            this.customizeOptionsButton.setEnabled(false);
            this.wrapCheckBox.setEnabled(false);
            this.category.setErrorMessage(Bundle.MsgModifiedAction());
        }
        if (this.oldMainClass == null) {
            this.oldMainClass = "";
        }
        this.txtMainClass.setText(this.oldMainClass);
        if (this.oldParams == null) {
            this.oldParams = "";
        }
        this.txtArguments.setText(this.oldParams);
        if (this.oldVMParams == null) {
            this.oldVMParams = "";
        }
        this.txtVMOptions.setText(this.oldVMParams);
        if (this.oldWorkDir == null) {
            this.oldWorkDir = "";
        }
        this.txtWorkDir.setText(this.oldWorkDir);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setupConfigurations();
        this.initValues();
        this.addListeners();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    private void initComponents() {
        this.lblMainClass = new JLabel();
        this.txtMainClass = new JTextField();
        this.btnMainClass = new JButton();
        this.lblArguments = new JLabel();
        this.txtArguments = new JTextField();
        this.lblWorkDir = new JLabel();
        this.txtWorkDir = new JTextField();
        this.btnWorkDir = new JButton();
        this.lblVMOptions = new JLabel();
        this.lblHint = new JLabel();
        this.lblConfiguration = new JLabel();
        this.comConfiguration = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.txtVMOptions = new JTextArea();
        this.customizeOptionsButton = new JButton();
        this.wrapCheckBox = new JCheckBox();
        this.lblMainClass.setLabelFor(this.txtMainClass);
        Mnemonics.setLocalizedText((JLabel)this.lblMainClass, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_MainClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMainClass, (String)NbBundle.getMessage(RunJarPanel.class, (String)"BTN_Browse_Main"));
        this.lblArguments.setLabelFor(this.txtArguments);
        Mnemonics.setLocalizedText((JLabel)this.lblArguments, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_Arguments"));
        this.lblWorkDir.setLabelFor(this.txtWorkDir);
        Mnemonics.setLocalizedText((JLabel)this.lblWorkDir, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_WorkDir"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnWorkDir, (String)NbBundle.getMessage(RunJarPanel.class, (String)"BTN_Browse_WorkingDir"));
        this.btnWorkDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunJarPanel.this.btnWorkDirActionPerformed(evt);
            }
        });
        this.lblVMOptions.setLabelFor(this.txtVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.lblVMOptions, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_VMOptions"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_VMHint"));
        this.lblConfiguration.setLabelFor(this.comConfiguration);
        Mnemonics.setLocalizedText((JLabel)this.lblConfiguration, (String)NbBundle.getMessage(RunJarPanel.class, (String)"RunJarPanel.lblConfiguration.text"));
        this.comConfiguration.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.txtVMOptions.setColumns(20);
        this.txtVMOptions.setLineWrap(true);
        this.txtVMOptions.setRows(5);
        this.jScrollPane1.setViewportView(this.txtVMOptions);
        this.txtVMOptions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunJarPanel.class, (String)"RunJarPanel.txtVMOptions.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.customizeOptionsButton, (String)NbBundle.getMessage(RunJarPanel.class, (String)"RunJarPanel.customizeOptionsButton.text"));
        this.customizeOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunJarPanel.this.customizeOptionsButtonActionPerformed(evt);
            }
        });
        this.wrapCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.wrapCheckBox, (String)NbBundle.getMessage(RunJarPanel.class, (String)"RunJarPanel.wrapCheckBox.text"));
        this.wrapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunJarPanel.this.wrapCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblWorkDir).addComponent(this.lblVMOptions).addComponent(this.lblArguments).addComponent(this.lblConfiguration).addComponent(this.lblMainClass)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblHint).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 261, Short.MAX_VALUE).addComponent(this.txtWorkDir).addComponent(this.txtArguments).addComponent(this.txtMainClass).addComponent(this.comConfiguration, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.wrapCheckBox)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnWorkDir, -1, -1, Short.MAX_VALUE).addComponent(this.btnMainClass, -1, -1, Short.MAX_VALUE).addComponent(this.customizeOptionsButton, -1, -1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConfiguration).addComponent(this.comConfiguration, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMainClass).addComponent(this.btnMainClass).addComponent(this.txtMainClass, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblArguments).addComponent(this.txtArguments, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblWorkDir).addComponent(this.txtWorkDir, -2, -1, -2).addComponent(this.btnWorkDir)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblVMOptions).addComponent(this.jScrollPane1, -1, 55, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint).addGap(40, 40, 40)).addGroup(layout.createSequentialGroup().addComponent(this.customizeOptionsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wrapCheckBox).addContainerGap(-1, Short.MAX_VALUE)))));
        this.txtMainClass.getAccessibleContext().setAccessibleDescription("Main class");
        this.btnMainClass.getAccessibleContext().setAccessibleDescription("Browse main class");
        this.txtArguments.getAccessibleContext().setAccessibleDescription("Arguments");
        this.txtWorkDir.getAccessibleContext().setAccessibleDescription("Working directory");
        this.btnWorkDir.getAccessibleContext().setAccessibleDescription("Browse working directory");
        this.comConfiguration.getAccessibleContext().setAccessibleDescription("Configuration");
    }

    private void btnWorkDirActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        String workDir = this.txtWorkDir.getText();
        if (workDir.equals("")) {
            workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
        chooser.setSelectedFile(new File(workDir));
        chooser.setDialogTitle(NbBundle.getMessage(RunJarPanel.class, (String)"TIT_SelectWorkingDirectory"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.txtWorkDir.setText(file.getAbsolutePath());
        }
    }

    private void customizeOptionsButtonActionPerformed(ActionEvent evt) {
        String origin = this.txtVMOptions.getText();
        try {
            String result = ProjectUISupport.showVMOptionCustomizer((Window)SwingUtilities.getWindowAncestor(this), (String)origin);
            result = MavenExecuteUtils.splitJVMParams(result, true);
            this.txtVMOptions.setText(result);
        }
        catch (Exception e) {
            Logger.getLogger(RunJarPanel.class.getName()).log(Level.WARNING, "Cannot parse vm options.", e);
        }
    }

    private void wrapCheckBoxActionPerformed(ActionEvent evt) {
        boolean selected = this.wrapCheckBox.isSelected();
        MavenSettings.getDefault().setVMOptionsWrap(selected);
        this.txtVMOptions.setLineWrap(selected);
    }

    void applyChanges() {
        String newMainClass = this.txtMainClass.getText().trim();
        String newParams = this.txtArguments.getText().trim();
        String newVMParams = this.txtVMOptions.getText().trim();
        String newWorkDir = this.txtWorkDir.getText().trim();
        this.execEnvHelper.setMainClass(newMainClass);
        this.execEnvHelper.setAppParams(newParams);
        this.execEnvHelper.setWorkDir(newWorkDir);
        this.execEnvHelper.setVmParams(newVMParams);
        this.execEnvHelper.applyToMappings();
        if (this.execEnvHelper.isModified()) {
            this.handle.markAsModified(this.execEnvHelper.getGoalMappings());
        }
    }

    private void setupConfigurations() {
        this.lblConfiguration.setVisible(true);
        this.comConfiguration.setVisible(true);
        DefaultComboBoxModel<ModelHandle2.Configuration> comModel = new DefaultComboBoxModel<ModelHandle2.Configuration>();
        for (ModelHandle2.Configuration conf : this.handle.getConfigurations()) {
            comModel.addElement(conf);
        }
        this.comConfiguration.setModel(comModel);
        this.comConfiguration.setSelectedItem(this.handle.getActiveConfiguration());
    }

    public HelpCtx getHelpCtx() {
        return CustomizerProviderImpl.HELP_CTX;
    }

    private class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private FileObject[] sourceRoots;
        private JTextField mainClassTextField;

        MainClassListener(FileObject[] sourceRoots, JTextField mainClassTextField) {
            this.sourceRoots = sourceRoots;
            this.mainClassTextField = mainClassTextField;
            this.okButton = new JButton(NbBundle.getMessage(RunJarPanel.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunJarPanel.class, (String)"AD_ChooseMainClass_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final MainClassChooser panel = new MainClassChooser(this.sourceRoots);
            Object[] options = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            panel.addChangeListener(new ChangeListener(){
                final /* synthetic */ MainClassListener this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        this.this$1.okButton.doClick();
                    } else {
                        this.this$1.okButton.setEnabled(panel.getSelectedMainClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(RunJarPanel.class, (String)"LBL_ChooseMainClass_Title"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                this.mainClassTextField.setText(panel.getSelectedMainClass());
            }
            dlg.dispose();
        }
    }
}

