/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class BreakpointEnableAction
extends BooleanStateAction
implements ContextAwareAction {
    public boolean isEnabled() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(BreakpointEnableAction.class, (String)"CTL_enabled");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Collection ann = actionContext.lookupAll(BreakpointAnnotation.class);
        if (!ann.isEmpty()) {
            BreakpointAwareAction a = new BreakpointAwareAction(ann);
            return a;
        }
        return this;
    }

    private class BreakpointAwareAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup {
        private Collection<? extends BreakpointAnnotation> ann;
        private HiddenBooleanStateAction hba;

        public BreakpointAwareAction(Collection<? extends BreakpointAnnotation> ann) {
            this.ann = ann;
            this.hba = (HiddenBooleanStateAction)SystemAction.get(HiddenBooleanStateAction.class);
        }

        @Override
        public Object getValue(String key) {
            return this.hba.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.hba.putValue(key, value);
        }

        @Override
        public void setEnabled(boolean b) {
        }

        private void setBreakpoints() {
            ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>(this.ann.size());
            for (BreakpointAnnotation breakpointAnnotation : this.ann) {
                breakpoints.add(breakpointAnnotation.getBreakpoint());
            }
            this.hba.setFor(breakpoints);
        }

        @Override
        public boolean isEnabled() {
            this.setBreakpoints();
            return true;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.hba.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.hba.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getMenuPresenter() {
            this.setBreakpoints();
            return this.hba.getMenuPresenter();
        }

        public JMenuItem getPopupPresenter() {
            this.setBreakpoints();
            return this.hba.getPopupPresenter();
        }
    }

    private static class HiddenBooleanStateAction
    extends BooleanStateAction {
        private Collection<Reference<Breakpoint>> bRefs;

        public HiddenBooleanStateAction() {
            this.setEnabled(true);
        }

        public void setFor(Collection<Breakpoint> breakpoints) {
            this.bRefs = new ArrayList<Reference<Breakpoint>>(breakpoints.size());
            for (Breakpoint b : breakpoints) {
                this.bRefs.add(new WeakReference<Breakpoint>(b));
            }
            this.setBooleanState(this.areBreakpointsEnabled());
        }

        private boolean areBreakpointsEnabled() {
            boolean isEnabled = true;
            for (Reference<Breakpoint> br : this.bRefs) {
                Breakpoint b = br.get();
                if (b == null || b.isEnabled()) continue;
                isEnabled = false;
            }
            return isEnabled;
        }

        public String getName() {
            return NbBundle.getMessage(BreakpointEnableAction.class, (String)"CTL_enabled");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void actionPerformed(ActionEvent ev) {
            super.actionPerformed(ev);
            boolean enabled = !this.areBreakpointsEnabled();
            for (Reference<Breakpoint> br : this.bRefs) {
                Breakpoint b = br.get();
                if (b == null) continue;
                if (enabled) {
                    b.enable();
                    continue;
                }
                b.disable();
            }
        }
    }
}

