/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.Map;
import java.util.TreeMap;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.spi.ExecutionControl;

class DefaultLoaderDelegate
implements LoaderDelegate {
    private final RemoteClassLoader loader;
    private final Map<String, Class<?>> klasses = new TreeMap();

    public DefaultLoaderDelegate() {
        this.loader = new RemoteClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException, ExecutionControl.EngineTerminationException {
        boolean[] loaded = new boolean[cbcs.length];
        try {
            for (ExecutionControl.ClassBytecodes cbc : cbcs) {
                this.loader.delare(cbc.name(), cbc.bytecodes());
            }
            for (int i = 0; i < cbcs.length; ++i) {
                ExecutionControl.ClassBytecodes cbc = cbcs[i];
                Class<?> klass = this.loader.loadClass(cbc.name());
                this.klasses.put(cbc.name(), klass);
                loaded[i] = true;
                klass.getDeclaredMethods();
            }
        }
        catch (Throwable ex) {
            throw new ExecutionControl.ClassInstallException("load: " + ex.getMessage(), loaded);
        }
    }

    @Override
    public void addToClasspath(String cp) throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        try {
            for (String path : cp.split(File.pathSeparator)) {
                this.loader.addURL(new File(path).toURI().toURL());
            }
        }
        catch (Exception ex) {
            throw new ExecutionControl.InternalException(ex.toString());
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> klass = this.klasses.get(name);
        if (klass == null) {
            throw new ClassNotFoundException(name + " not found");
        }
        return klass;
    }

    class RemoteClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> classObjects;

        RemoteClassLoader() {
            super(new URL[0]);
            this.classObjects = new TreeMap<String, byte[]>();
        }

        void delare(String name, byte[] bytes) {
            this.classObjects.put(name, bytes);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] b = this.classObjects.get(name);
            if (b == null) {
                return super.findClass(name);
            }
            return super.defineClass(name, b, 0, b.length, (CodeSource)null);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

