/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.source;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.debugger.jpda.truffle.source.SourceConnection;
import org.netbeans.modules.debugger.jpda.truffle.source.SourceFS;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;

public final class SourceURLMapper
extends URLMapper {
    private static final Map<Long, Reference<FileSystem>> filesystems = new HashMap<Long, Reference<FileSystem>>();
    private static final Pattern HOST = Pattern.compile("fs(\\d+)");

    public URL getURL(FileObject fo, int type) {
        if (type != 0) {
            return null;
        }
        try {
            FileSystem fs = fo.getFileSystem();
            if (fs instanceof SourceFS) {
                Object path = fo.getPath();
                if (fo.isFolder() && !fo.isRoot()) {
                    path = (String)path + "/";
                }
                return SourceURLMapper.url((SourceFS)fs, (String)path);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized URL url(SourceFS fs, String path) {
        Map<Long, Reference<FileSystem>> map = filesystems;
        synchronized (map) {
            Reference<FileSystem> r = filesystems.get(fs.getID());
            if (r == null || r.get() == null) {
                r = new WeakReference<SourceFS>(fs);
                filesystems.put(fs.getID(), r);
            }
        }
        try {
            return new URL("truffle-scripts", "fs" + fs.getID(), -1, "/" + SourceURLMapper.percentEncode(path), new SourceURLHandler());
        }
        catch (MalformedURLException x) {
            throw new AssertionError((Object)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject find(URL url) {
        Reference<FileSystem> r;
        if (!"truffle-scripts".equals(url.getProtocol())) {
            return null;
        }
        Matcher m = HOST.matcher(url.getHost());
        if (!m.matches()) {
            return null;
        }
        Map<Long, Reference<FileSystem>> map = filesystems;
        synchronized (map) {
            r = filesystems.get(Long.parseLong(m.group(1)));
        }
        if (r == null) {
            return null;
        }
        FileSystem fs = r.get();
        if (fs == null) {
            return null;
        }
        String path = url.getPath().substring(1);
        path = SourceURLMapper.percentDecode(path);
        return fs.findResource(path);
    }

    public FileObject[] getFileObjects(URL url) {
        FileObject[] fileObjectArray;
        FileObject f = SourceURLMapper.find(url);
        if (f != null) {
            FileObject[] fileObjectArray2 = new FileObject[1];
            fileObjectArray = fileObjectArray2;
            fileObjectArray2[0] = f;
        } else {
            fileObjectArray = null;
        }
        return fileObjectArray;
    }

    public static String percentEncode(String text) {
        StringBuilder encoded = null;
        int li = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            char v = c;
            if ('/' <= v && v <= '9' || 'A' <= v && v <= 'Z' || 'a' <= v && v <= 'z' || v == '.') continue;
            String e = SourceURLMapper.encode(c);
            if (encoded == null) {
                encoded = new StringBuilder();
            }
            encoded.append(text.substring(li, i));
            encoded.append(e);
            li = i + 1;
        }
        if (encoded != null) {
            if (li < text.length()) {
                encoded.append(text.substring(li));
            }
            return encoded.toString();
        }
        return text;
    }

    private static String encode(char c) {
        byte[] bytes;
        String s = new String(new char[]{c});
        try {
            bytes = s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            bytes = s.getBytes();
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append('%');
            String hs = Integer.toHexString(b & 0xFF);
            if (hs.length() == 1) {
                sb.append('0');
            }
            sb.append(hs);
        }
        return sb.toString();
    }

    public static String percentDecode(String text) {
        int i = text.indexOf(37);
        if (i < 0) {
            return text;
        }
        StringBuilder decoded = new StringBuilder();
        int li = 0;
        while (i >= 0) {
            String s;
            decoded.append(text.substring(li, i));
            ArrayList<Byte> bytes = new ArrayList<Byte>();
            while (text.length() > i + 2 && text.charAt(i) == '%') {
                int v = Integer.parseInt(text.substring(i + 1, i + 3), 16);
                bytes.add((byte)(v & 0xFF));
                i += 3;
            }
            byte[] byteArray = new byte[bytes.size()];
            for (int bi = 0; bi < byteArray.length; ++bi) {
                byteArray[bi] = (Byte)bytes.get(bi);
            }
            try {
                s = new String(byteArray, "utf-8");
            }
            catch (UnsupportedEncodingException ex) {
                s = new String(byteArray);
            }
            decoded.append(s);
            if (i < text.length() && text.charAt(i) == '%') {
                decoded.append('%');
            }
            li = ++i;
            i = text.indexOf(37, li);
        }
        if (li < text.length()) {
            decoded.append(text.substring(li));
        }
        return decoded.toString();
    }

    public static final class SourceURLHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new SourceConnection(u);
        }
    }
}

