/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.ui.suspend;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JToggleButton;
import org.netbeans.modules.masterfs.ui.suspend.Bundle;
import org.openide.awt.Actions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public final class PauseAction
extends AbstractAction
implements Presenter.Toolbar {
    private static final RequestProcessor RP = new RequestProcessor("Pause Action");
    private static final String SUSPEND_COUNT_PROPERTY = "org.netbeans.io.suspend".intern();
    private static final Preferences PREFS = NbPreferences.forModule(PauseAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PauseAction() {
        this.putValue("iconBase", "org/netbeans/modules/masterfs/ui/suspend/pause.png");
        this.putValue("ShortDescription", Bundle.CTL_PauseAction());
        this.putValue("LongDescription", Bundle.CTL_PauseAction());
        int initialValue = PREFS.getInt(SUSPEND_COUNT_PROPERTY, 0);
        String string = SUSPEND_COUNT_PROPERTY;
        synchronized (string) {
            System.setProperty(SUSPEND_COUNT_PROPERTY, "" + initialValue);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (PauseAction.isSuspended()) {
            PauseAction.resume();
        } else {
            PauseAction.suspend(1);
        }
    }

    public Component getToolbarPresenter() {
        final JToggleButton suspendIOButton = new JToggleButton();
        Actions.connect((AbstractButton)suspendIOButton, (Action)this);
        PauseAction.updateButton(suspendIOButton);
        final class Controller
        implements Runnable,
        ActionListener {
            private RequestProcessor.Task updateTask = PauseAction.access$000().create((Runnable)this);
            final /* synthetic */ PauseAction this$0;

            Controller() {
                this.this$0 = this$0;
                this.scheduleUpdate(0);
            }

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(this);
                    return;
                }
                if (!suspendIOButton.isShowing()) {
                    return;
                }
                PauseAction.updateButton(suspendIOButton);
                this.scheduleUpdate(0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PauseAction.updateButton(suspendIOButton);
                this.run();
                this.scheduleUpdate(100);
            }

            private void scheduleUpdate(int time) {
                if (time == 0) {
                    time = 1500;
                }
                this.updateTask.schedule(time);
            }
        }
        Controller c = new Controller();
        suspendIOButton.addActionListener(c);
        return suspendIOButton;
    }

    static final void updateButton(AbstractButton btnResume) {
        if (PauseAction.isSuspended()) {
            int pending = Integer.getInteger("org.netbeans.io.pending", 0);
            btnResume.setText(Bundle.MSG_Resume(pending));
            btnResume.setSelected(true);
        } else {
            btnResume.setText(null);
            btnResume.setSelected(false);
        }
    }

    static boolean isSuspended() {
        return Integer.getInteger(SUSPEND_COUNT_PROPERTY, 0) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void suspend(int delta) {
        int prev;
        String string = SUSPEND_COUNT_PROPERTY;
        synchronized (string) {
            prev = Integer.getInteger(SUSPEND_COUNT_PROPERTY, 0);
            System.setProperty(SUSPEND_COUNT_PROPERTY, "" + (prev += delta));
            SUSPEND_COUNT_PROPERTY.notifyAll();
        }
        PREFS.putInt(SUSPEND_COUNT_PROPERTY, prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resume() {
        String string = SUSPEND_COUNT_PROPERTY;
        synchronized (string) {
            System.setProperty(SUSPEND_COUNT_PROPERTY, "0");
            SUSPEND_COUNT_PROPERTY.notifyAll();
        }
        PREFS.putInt(SUSPEND_COUNT_PROPERTY, 0);
    }

    static /* synthetic */ RequestProcessor access$000() {
        return RP;
    }
}

