/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNamespaceRequest
extends BmcRequest<Void> {
    private String opcClientRequestId;
    private String compartmentId;

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Builder toBuilder() {
        return new Builder().opcClientRequestId(this.opcClientRequestId).compartmentId(this.compartmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNamespaceRequest)) {
            return false;
        }
        GetNamespaceRequest other = (GetNamespaceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.compartmentId, other.compartmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNamespaceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcClientRequestId = null;
        private String compartmentId = null;

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNamespaceRequest o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNamespaceRequest build() {
            GetNamespaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNamespaceRequest buildWithoutInvocationCallback() {
            GetNamespaceRequest request = new GetNamespaceRequest();
            request.opcClientRequestId = this.opcClientRequestId;
            request.compartmentId = this.compartmentId;
            return request;
        }
    }
}

