/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.TagLibraryImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagLibrary;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FaceletTaglibConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String LIBRARY_CLASS = "library-class";
    private static final String TAGLIB_NAMESPACE = "namespace";
    private static final String TAG = "tag";
    private static final String FUNCTION = "function";
    private static final String TAG_NAME = "tag-name";
    private static final String COMPONENT = "component";
    private static final String VALIDATOR = "validator";
    private static final String CONVERTER = "converter";
    private static final String BEHAVIOR = "behavior";
    private static final String SOURCE = "source";
    private static final String RESOURCE_ID = "resource-id";
    private static final String HANDLER_CLASS = "handler-class";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String CONVERTER_ID = "converter-id";
    private static final String BEHAVIOR_ID = "behavior-id";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String FUNCTION_NAME = "function-name";
    private static final String FUNCTION_CLASS = "function-class";
    private static final String FUNCTION_SIGNATURE = "function-signature";
    private static final String COMPOSITE_LIBRARY_NAME = "composite-library-name";

    @Override
    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        ApplicationAssociate associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        assert (associate != null);
        Compiler compiler = associate.getCompiler();
        int length = documentInfos.length;
        for (int i = 0; i < length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing facelet-taglibrary document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            Element documentElement = document.getDocumentElement();
            NodeList libraryClass = documentElement.getElementsByTagNameNS(namespace, LIBRARY_CLASS);
            if (libraryClass != null && libraryClass.getLength() > 0) {
                this.processTaglibraryClass(sc, libraryClass, compiler);
                continue;
            }
            this.processTagLibrary(sc, documentElement, namespace, compiler);
        }
        this.invokeNext(sc, documentInfos);
    }

    private void processTaglibraryClass(ServletContext sc, NodeList libraryClass, Compiler compiler) {
        Node n = libraryClass.item(0);
        String className = this.getNodeText(n);
        TagLibrary taglib = (TagLibrary)this.createInstance(sc, className, n);
        compiler.addTagLibrary(taglib);
    }

    private void processTagLibrary(ServletContext sc, Element documentElement, String namespace, Compiler compiler) {
        NodeList children = documentElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            TagLibraryImpl taglibrary;
            String taglibNamespace = null;
            String compositeLibraryName = null;
            int ilen = children.getLength();
            block8: for (int i = 0; i < ilen; ++i) {
                Node n = children.item(i);
                if (n.getLocalName() == null) continue;
                switch (n.getLocalName()) {
                    case "namespace": {
                        taglibNamespace = this.getNodeText(n);
                        continue block8;
                    }
                    case "composite-library-name": {
                        compositeLibraryName = this.getNodeText(n);
                    }
                }
            }
            if (compositeLibraryName != null) {
                taglibrary = new CompositeComponentTagLibrary(taglibNamespace, compositeLibraryName);
                compiler.addTagLibrary(taglibrary);
            } else {
                taglibrary = new TagLibraryImpl(taglibNamespace);
            }
            NodeList tags = documentElement.getElementsByTagNameNS(namespace, TAG);
            this.processTags(sc, documentElement, tags, taglibrary);
            NodeList functions = documentElement.getElementsByTagNameNS(namespace, FUNCTION);
            this.processFunctions(sc, functions, taglibrary);
            compiler.addTagLibrary(taglibrary);
        }
    }

    private void processTags(ServletContext sc, Element documentElement, NodeList tags, TagLibraryImpl taglibrary) {
        if (tags != null && tags.getLength() > 0) {
            int ilen = tags.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node tagNode = tags.item(i);
                NodeList children = tagNode.getChildNodes();
                String tagName = null;
                NodeList component = null;
                NodeList converter = null;
                NodeList validator = null;
                NodeList behavior = null;
                Node source = null;
                Node handlerClass = null;
                int jlen = children.getLength();
                block19: for (int j = 0; j < jlen; ++j) {
                    Node n = children.item(j);
                    if (n.getLocalName() == null) continue;
                    switch (n.getLocalName()) {
                        case "tag-name": {
                            tagName = this.getNodeText(n);
                            continue block19;
                        }
                        case "component": {
                            component = n.getChildNodes();
                            continue block19;
                        }
                        case "converter": {
                            converter = n.getChildNodes();
                            continue block19;
                        }
                        case "validator": {
                            validator = n.getChildNodes();
                            continue block19;
                        }
                        case "behavior": {
                            behavior = n.getChildNodes();
                            continue block19;
                        }
                        case "source": {
                            source = n;
                            continue block19;
                        }
                        case "handler-class": {
                            handlerClass = n;
                        }
                    }
                }
                if (component != null) {
                    this.processComponent(sc, documentElement, component, taglibrary, tagName);
                    continue;
                }
                if (converter != null) {
                    this.processConverter(sc, converter, taglibrary, tagName);
                    continue;
                }
                if (validator != null) {
                    this.processValidator(sc, validator, taglibrary, tagName);
                    continue;
                }
                if (behavior != null) {
                    this.processBehavior(sc, behavior, taglibrary, tagName);
                    continue;
                }
                if (source != null) {
                    this.processSource(documentElement, source, taglibrary, tagName);
                    continue;
                }
                if (handlerClass == null) continue;
                this.processHandlerClass(sc, handlerClass, taglibrary, tagName);
            }
        }
    }

    private void processBehavior(ServletContext sc, NodeList behavior, TagLibraryImpl taglibrary, String tagName) {
        if (behavior != null && behavior.getLength() > 0) {
            String behaviorId = null;
            String handlerClass = null;
            int ilen = behavior.getLength();
            block10: for (int i = 0; i < ilen; ++i) {
                Node n = behavior.item(i);
                if (n.getLocalName() == null) continue;
                switch (n.getLocalName()) {
                    case "behavior-id": {
                        behaviorId = this.getNodeText(n);
                        continue block10;
                    }
                    case "handler-class": {
                        handlerClass = this.getNodeText(n);
                    }
                }
            }
            if (handlerClass != null) {
                try {
                    Class<?> clazz = this.loadClass(sc, handlerClass, this, null);
                    taglibrary.putBehavior(tagName, behaviorId, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException(e);
                }
            } else {
                taglibrary.putBehavior(tagName, behaviorId);
            }
        }
    }

    private void processHandlerClass(ServletContext sc, Node handlerClass, TagLibraryImpl taglibrary, String name) {
        block7: {
            String className = this.getNodeText(handlerClass);
            if (className == null) {
                throw new ConfigurationException("The tag named " + name + " from namespace " + taglibrary.getNamespace() + " has a null handler-class defined");
            }
            try {
                try {
                    Class<?> clazz = this.loadClass(sc, className, this, null);
                    taglibrary.putTagHandler(name, clazz);
                }
                catch (NoClassDefFoundError defNotFound) {
                    String message = defNotFound.toString();
                    if (message.contains("com/sun/facelets/") || message.contains("com.sun.facelets.")) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{handlerClass});
                        }
                        break block7;
                    }
                    throw defNotFound;
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException(cnfe);
            }
        }
    }

    private void processSource(Element documentElement, Node source, TagLibraryImpl taglibrary, String name) {
        String docURI = documentElement.getOwnerDocument().getDocumentURI();
        String s = this.getNodeText(source);
        try {
            URL url = new URL(new URL(docURI), s);
            taglibrary.putUserTag(name, url);
        }
        catch (MalformedURLException e) {
            throw new FacesException(e);
        }
    }

    private void processResourceId(Element documentElement, Node compositeSource, TagLibraryImpl taglibrary, String name) {
        String resourceId = this.getNodeText(compositeSource);
        taglibrary.putCompositeComponentTag(name, resourceId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processValidator(ServletContext sc, NodeList validator, TagLibraryImpl taglibrary, String name) {
        if (validator == null || validator.getLength() <= 0) return;
        String validatorId = null;
        String handlerClass = null;
        int ilen = validator.getLength();
        block11: for (int i = 0; i < ilen; ++i) {
            Node n = validator.item(i);
            if (n.getLocalName() == null) continue;
            switch (n.getLocalName()) {
                case "validator-id": {
                    validatorId = this.getNodeText(n);
                    continue block11;
                }
                case "handler-class": {
                    handlerClass = this.getNodeText(n);
                }
            }
        }
        if (handlerClass != null) {
            try {
                Class<?> clazz = this.loadClass(sc, handlerClass, this, null);
                taglibrary.putValidator(name, validatorId, clazz);
                return;
            }
            catch (NoClassDefFoundError defNotFound) {
                String message = defNotFound.toString();
                if (!message.contains("com/sun/facelets/") && !message.contains("com.sun.facelets.")) throw defNotFound;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{handlerClass});
                return;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
        } else {
            taglibrary.putValidator(name, validatorId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConverter(ServletContext sc, NodeList converter, TagLibraryImpl taglibrary, String name) {
        if (converter == null || converter.getLength() <= 0) return;
        String converterId = null;
        String handlerClass = null;
        int ilen = converter.getLength();
        block11: for (int i = 0; i < ilen; ++i) {
            Node n = converter.item(i);
            if (n.getLocalName() == null) continue;
            switch (n.getLocalName()) {
                case "converter-id": {
                    converterId = this.getNodeText(n);
                    continue block11;
                }
                case "handler-class": {
                    handlerClass = this.getNodeText(n);
                }
            }
        }
        if (handlerClass != null) {
            try {
                Class<?> clazz = this.loadClass(sc, handlerClass, this, null);
                taglibrary.putConverter(name, converterId, clazz);
                return;
            }
            catch (NoClassDefFoundError defNotFound) {
                String message = defNotFound.toString();
                if (!message.contains("com/sun/facelets/") && !message.contains("com.sun.facelets.")) throw defNotFound;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{handlerClass});
                return;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
        } else {
            taglibrary.putConverter(name, converterId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processComponent(ServletContext sc, Element documentElement, NodeList component, TagLibraryImpl taglibrary, String name) {
        if (component == null || component.getLength() <= 0) return;
        String componentType = null;
        String rendererType = null;
        String handlerClass = null;
        Node resourceId = null;
        int ilen = component.getLength();
        block15: for (int i = 0; i < ilen; ++i) {
            Node n = component.item(i);
            if (n.getLocalName() == null) continue;
            switch (n.getLocalName()) {
                case "component-type": {
                    componentType = this.getNodeText(n);
                    continue block15;
                }
                case "renderer-type": {
                    rendererType = this.getNodeText(n);
                    continue block15;
                }
                case "handler-class": {
                    handlerClass = this.getNodeText(n);
                    continue block15;
                }
                case "resource-id": {
                    resourceId = n;
                }
            }
        }
        if (handlerClass != null) {
            try {
                Class<?> clazz = this.loadClass(sc, handlerClass, this, null);
                taglibrary.putComponent(name, componentType, rendererType, clazz);
                return;
            }
            catch (NoClassDefFoundError defNotFound) {
                String message = defNotFound.toString();
                if (!message.contains("com/sun/facelets/") && !message.contains("com.sun.facelets.")) throw defNotFound;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{handlerClass});
                return;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
        } else if (resourceId != null) {
            this.processResourceId(documentElement, resourceId, taglibrary, name);
            return;
        } else {
            taglibrary.putComponent(name, componentType, rendererType);
        }
    }

    private void processFunctions(ServletContext sc, NodeList functions, TagLibraryImpl taglibrary) {
        if (functions != null && functions.getLength() > 0) {
            int ilen = functions.getLength();
            for (int i = 0; i < ilen; ++i) {
                NodeList children = functions.item(i).getChildNodes();
                String functionName = null;
                String functionClass = null;
                String functionSignature = null;
                int jlen = children.getLength();
                block13: for (int j = 0; j < jlen; ++j) {
                    Node n = children.item(j);
                    if (n.getLocalName() == null) continue;
                    switch (n.getLocalName()) {
                        case "function-name": {
                            functionName = this.getNodeText(n);
                            continue block13;
                        }
                        case "function-class": {
                            functionClass = this.getNodeText(n);
                            continue block13;
                        }
                        case "function-signature": {
                            functionSignature = this.getNodeText(n);
                        }
                    }
                }
                try {
                    Class<?> clazz = this.loadClass(sc, functionClass, this, null);
                    Method m = FaceletTaglibConfigProcessor.createMethod(clazz, functionSignature);
                    taglibrary.putFunction(functionName, m);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    private static Method createMethod(Class type, String signatureParam) throws Exception {
        Class[] pc;
        String signature = signatureParam.replaceAll("\\s+", " ");
        int pos = signature.indexOf(32);
        if (pos == -1) {
            throw new Exception("Must Provide Return Type: " + signature);
        }
        int pos2 = signature.indexOf(40, pos + 1);
        if (pos2 == -1) {
            throw new Exception("Must provide a method name, followed by '(': " + signature);
        }
        String mn = signature.substring(pos + 1, pos2).trim();
        pos = signature.indexOf(41, pos2 + 1);
        if (pos == -1) {
            throw new Exception("Must close parentheses, ')' missing: " + signature);
        }
        String[] ps = signature.substring(pos2 + 1, pos).trim().split(",");
        if (ps.length == 1 && "".equals(ps[0])) {
            pc = new Class[]{};
        } else {
            pc = new Class[ps.length];
            for (int i = 0; i < pc.length; ++i) {
                pc[i] = ReflectionUtil.forName(ps[i].trim());
            }
        }
        try {
            return type.getMethod(mn, pc);
        }
        catch (NoSuchMethodException e) {
            throw new Exception("No Function Found on type: " + type.getName() + " with signature: " + signature);
        }
    }
}

