/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.View;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.LibraryProvider;
import org.netbeans.modules.javascript.cdnjs.ui.Bundle;
import org.netbeans.modules.javascript.cdnjs.ui.FileSelectionPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SearchPanel
extends JPanel {
    private static final int MIN_SEARCH_TEXT_LENGTH = 2;
    private static final RequestProcessor RP = new RequestProcessor(SearchPanel.class.getName(), 3);
    private String lastSearchTerm;
    private JButton addButton;
    private JButton cancelButton;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JLabel descriptionTextLabel;
    private FileSelectionPanel fileSelectionPanel;
    private JLabel filesLabel;
    private JLabel homePageLabel;
    private JLabel homePageLinkLabel;
    private JLabel librariesLabel;
    private JList<Library> librariesList;
    private JScrollPane librariesScrollPane;
    private JPanel libraryInfoPanel;
    private JLabel messageLabel;
    private JButton searchButton;
    private JTextField searchField;
    private JLabel searchLabel;
    private JPanel searchPanel;
    private JComboBox<Library.Version> versionComboBox;
    private JLabel versionLabel;

    SearchPanel() {
        this.initComponents();
        this.initDocumentListener();
        this.librariesList.setCellRenderer(new LibraryRenderer());
        this.libraryInfoPanel.setPreferredSize(this.librariesScrollPane.getPreferredSize());
        this.versionComboBox.setRenderer(new LibraryVersionRenderer());
        this.updateLibraries(new Library[0]);
        this.librarySelected(null);
    }

    private void initDocumentListener() {
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processEvent(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processEvent(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processEvent(e);
            }

            private void processEvent(DocumentEvent e) {
                String text = SearchPanel.this.searchField.getText();
                SearchPanel.this.searchButton.setEnabled(text != null && text.trim().length() >= 2);
            }
        });
    }

    private void librarySelected(Library library) {
        boolean emptySelection = library == null;
        Object description = null;
        if (!emptySelection) {
            description = library.getDescription();
            if (description == null) {
                description = "";
            }
            description = "<html>" + (String)description;
        }
        this.updateHomePageLink(library, false);
        this.descriptionTextLabel.setText((String)description);
        this.versionComboBox.setModel(this.versionComboBoxModelFor(library));
        this.versionComboBox.setEnabled(!emptySelection);
        this.addButton.setEnabled(!emptySelection);
        this.updateFileSelectionPanel();
    }

    private ComboBoxModel<Library.Version> versionComboBoxModelFor(Library library) {
        return new DefaultComboBoxModel<Library.Version>(library == null ? new Library.Version[]{} : library.getVersions());
    }

    private void startSearch() {
        String searchTerm = this.searchField.getText().trim();
        if (searchTerm.length() < 2) {
            return;
        }
        this.librarySelected(null);
        this.lastSearchTerm = searchTerm;
        this.messageLabel.setText(Bundle.SearchPanel_message_searching(this.lastSearchTerm));
        this.showComponent(this.messageLabel);
        RP.execute(() -> {
            Library[] libraries = LibraryProvider.getInstance().findLibraries(searchTerm);
            SwingUtilities.invokeLater(() -> this.updateLibraries(libraries));
        });
    }

    final void updateLibraries(Library[] libraries) {
        if (libraries == null) {
            this.messageLabel.setText(Bundle.SearchPanel_message_searchFailed());
            this.showComponent(this.messageLabel);
        } else if (libraries.length == 0) {
            this.messageLabel.setText(NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.messageLabel.text"));
            this.showComponent(this.messageLabel);
        } else {
            Arrays.sort(libraries, new LibraryComparator());
            this.librariesList.setModel(this.libraryListModelFor(libraries));
            this.preSelectSearchedLibrary(libraries);
            this.showComponent(this.searchPanel);
        }
    }

    private void preSelectSearchedLibrary(Library[] libraries) {
        int index = 0;
        String term = this.lastSearchTerm == null ? "" : this.lastSearchTerm;
        for (int i = 0; i < libraries.length; ++i) {
            if (!libraries[i].getName().equalsIgnoreCase(term)) continue;
            index = i;
            break;
        }
        this.librariesList.setSelectedIndex(index);
        this.librariesList.ensureIndexIsVisible(index);
    }

    private void showComponent(JComponent component) {
        if (component.getParent() == null) {
            JComponent shownComponent = component == this.messageLabel ? this.searchPanel : this.messageLabel;
            ((GroupLayout)this.getLayout()).replace(shownComponent, component);
        }
    }

    private ListModel<Library> libraryListModelFor(Library[] libraries) {
        DefaultListModel<Library> listModel = new DefaultListModel<Library>();
        if (libraries != null) {
            for (Library library : libraries) {
                listModel.addElement(library);
            }
        }
        return listModel;
    }

    Library.Version getSelectedVersion() {
        return this.fileSelectionPanel.getSelection();
    }

    JButton getAddButton() {
        return this.addButton;
    }

    JButton getCancelButton() {
        return this.cancelButton;
    }

    void showHomePage() {
        String homePage = this.getSelectedVersion().getLibrary().getHomePage();
        try {
            URI uri = new URI(homePage);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(SearchPanel.class.getName()).log(Level.INFO, null, ex);
        }
    }

    void updateHomePageLink(Library library, boolean linkVisible) {
        Object homePage = null;
        if (library != null && (homePage = library.getHomePage()) != null) {
            homePage = "<html>" + (linkVisible ? "<u>" : "") + (String)homePage;
        }
        if (homePage == null) {
            this.homePageLinkLabel.setCursor(new Cursor(0));
            this.homePageLinkLabel.setEnabled(false);
            this.homePageLinkLabel.setText(library == null ? null : Bundle.SearchPanel_nohomepage());
        } else {
            this.homePageLinkLabel.setCursor(new Cursor(12));
            this.homePageLinkLabel.setText((String)homePage);
            this.homePageLinkLabel.setEnabled(true);
        }
    }

    void updateFileSelectionPanel() {
        Library.Version version = (Library.Version)this.versionComboBox.getSelectedItem();
        this.fileSelectionPanel.setLibrary(version, null);
    }

    private void initComponents() {
        this.addButton = new JButton();
        this.cancelButton = new JButton();
        this.searchPanel = new JPanel();
        this.librariesScrollPane = new JScrollPane();
        this.librariesList = new JList();
        this.filesLabel = new JLabel();
        this.fileSelectionPanel = new FileSelectionPanel();
        this.librariesLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.libraryInfoPanel = new JPanel();
        this.versionLabel = new JLabel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Object view = this.getClientProperty("html");
                Container container = this.getParent();
                if (view instanceof View && container != null) {
                    Dimension containerDim = container.getSize();
                    ((View)view).setSize(containerDim.width, containerDim.height);
                }
                return super.getPreferredSize();
            }
        };
        this.versionComboBox = new JComboBox();
        this.homePageLabel = new JLabel();
        this.homePageLinkLabel = new JLabel(){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                return new Dimension(0, dim.height);
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.searchLabel = new JLabel();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.messageLabel = new JLabel();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.addButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.cancelButton.text"));
        this.librariesList.setSelectionMode(0);
        this.librariesList.addListSelectionListener(formListener);
        this.librariesScrollPane.setViewportView(this.librariesList);
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.filesLabel.text"));
        this.librariesLabel.setLabelFor(this.librariesList);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.librariesLabel.text"));
        this.descriptionLabel.setLabelFor(this.descriptionTextLabel);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.descriptionLabel.text"));
        this.versionLabel.setLabelFor(this.versionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.versionLabel.text"));
        this.descriptionScrollPane.setBorder(null);
        this.descriptionScrollPane.setHorizontalScrollBarPolicy(31);
        this.descriptionTextLabel.setVerticalAlignment(1);
        this.descriptionScrollPane.setViewportView(this.descriptionTextLabel);
        this.versionComboBox.addActionListener(formListener);
        GroupLayout libraryInfoPanelLayout = new GroupLayout(this.libraryInfoPanel);
        this.libraryInfoPanel.setLayout(libraryInfoPanelLayout);
        libraryInfoPanelLayout.setHorizontalGroup(libraryInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(libraryInfoPanelLayout.createSequentialGroup().addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionComboBox, 0, -1, Short.MAX_VALUE)).addComponent(this.descriptionScrollPane));
        libraryInfoPanelLayout.setVerticalGroup(libraryInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(libraryInfoPanelLayout.createSequentialGroup().addComponent(this.descriptionScrollPane, -1, 5, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(libraryInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.versionComboBox, -2, -1, -2))));
        Mnemonics.setLocalizedText((JLabel)this.homePageLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.homePageLabel.text"));
        this.homePageLinkLabel.addMouseListener(formListener);
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileSelectionPanel, -1, -1, Short.MAX_VALUE).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.filesLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.librariesScrollPane, -2, 200, -2).addComponent(this.librariesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.descriptionLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.libraryInfoPanel, -1, -1, Short.MAX_VALUE))).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.homePageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.homePageLinkLabel).addGap(0, 0, Short.MAX_VALUE)));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.librariesLabel).addComponent(this.descriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.libraryInfoPanel, -2, -1, -2).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.librariesScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.homePageLabel).addComponent(this.homePageLinkLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileSelectionPanel, -1, 150, Short.MAX_VALUE)));
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchLabel.text"));
        this.searchField.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchButton.text"));
        this.searchButton.setEnabled(false);
        this.searchButton.addActionListener(formListener);
        this.messageLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.messageLabel.text"));
        this.messageLabel.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchLabel).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageLabel, -1, 350, Short.MAX_VALUE).addContainerGap()));
    }

    private void librariesListValueChanged(ListSelectionEvent evt) {
        Library library = this.librariesList.getSelectedValue();
        if (library != null && (library.getVersions() == null || library.getVersions().length == 0)) {
            RP.execute(() -> {
                LibraryProvider.getInstance().updateLibraryVersions(library);
                SwingUtilities.invokeLater(() -> this.librarySelected(library));
            });
        } else {
            this.librarySelected(library);
        }
    }

    private void searchFieldActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void homePageLinkLabelMouseClicked(MouseEvent evt) {
        if (this.homePageLinkLabel.isEnabled()) {
            this.showHomePage();
        }
    }

    private void homePageLinkLabelMouseEntered(MouseEvent evt) {
        Library library = this.librariesList.getSelectedValue();
        this.updateHomePageLink(library, true);
    }

    private void homePageLinkLabelMouseExited(MouseEvent evt) {
        Library library = this.librariesList.getSelectedValue();
        this.updateHomePageLink(library, false);
    }

    private void versionComboBoxActionPerformed(ActionEvent evt) {
        this.updateFileSelectionPanel();
    }

    static class LibraryRenderer
    extends DefaultListCellRenderer {
        LibraryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Library) {
                Library library = (Library)value;
                value = library.getName();
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    static class LibraryVersionRenderer
    extends DefaultListCellRenderer {
        LibraryVersionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Library.Version) {
                Library.Version version = (Library.Version)value;
                value = version.getName();
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="No need to be serializable")
    static class LibraryComparator
    implements Comparator<Library> {
        LibraryComparator() {
        }

        @Override
        public int compare(Library library1, Library library2) {
            return library1.getName().toLowerCase().compareTo(library2.getName().toLowerCase());
        }
    }

    private class FormListener
    implements ActionListener,
    MouseListener,
    ListSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SearchPanel.this.searchField) {
                SearchPanel.this.searchFieldActionPerformed(evt);
            } else if (evt.getSource() == SearchPanel.this.searchButton) {
                SearchPanel.this.searchButtonActionPerformed(evt);
            } else if (evt.getSource() == SearchPanel.this.versionComboBox) {
                SearchPanel.this.versionComboBoxActionPerformed(evt);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == SearchPanel.this.homePageLinkLabel) {
                SearchPanel.this.homePageLinkLabelMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (evt.getSource() == SearchPanel.this.homePageLinkLabel) {
                SearchPanel.this.homePageLinkLabelMouseEntered(evt);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (evt.getSource() == SearchPanel.this.homePageLinkLabel) {
                SearchPanel.this.homePageLinkLabelMouseExited(evt);
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == SearchPanel.this.librariesList) {
                SearchPanel.this.librariesListValueChanged(evt);
            }
        }
    }
}

