/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Future;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VariablesActionsProvider
implements NodeActionsProvider {
    private final Action GO_TO_SOURCE_ACTION = Models.createAction((String)NbBundle.getMessage(VariablesActionsProvider.class, (String)"CTL_GoToSource"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(final Object[] nodes) {
            ((RequestProcessor)VariablesActionsProvider.this.lookupProvider.lookupFirst(null, RequestProcessor.class)).post(new Runnable(){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.VariablesActionsProvider.this.goToSource((Field)nodes[0]);
                }
            });
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final Action GO_TO_TYPE_SOURCE_ACTION = Models.createAction((String)NbBundle.getMessage(VariablesActionsProvider.class, (String)"CTL_GoToTypeSource"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(final Object[] nodes) {
            ((RequestProcessor)VariablesActionsProvider.this.lookupProvider.lookupFirst(null, RequestProcessor.class)).post(new Runnable(){
                final /* synthetic */ 2 this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.VariablesActionsProvider.this.showSource(((ObjectVariable)nodes[0]).getClassType());
                }
            });
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private ContextProvider lookupProvider;

    public VariablesActionsProvider(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[]{WatchesActionsProvider.NEW_WATCH_ACTION};
        }
        if (node instanceof Field) {
            if (node instanceof ObjectVariable) {
                return new Action[]{this.GO_TO_SOURCE_ACTION, this.GO_TO_TYPE_SOURCE_ACTION};
            }
            return new Action[]{this.GO_TO_SOURCE_ACTION};
        }
        if (node instanceof ObjectVariable) {
            return new Action[]{this.GO_TO_TYPE_SOURCE_ACTION};
        }
        if (node instanceof Variable) {
            return new Action[0];
        }
        if (node.toString().startsWith("SubArray")) {
            return new Action[0];
        }
        if (node.equals("NoInfo")) {
            return new Action[0];
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(final Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof Field) {
            ((RequestProcessor)this.lookupProvider.lookupFirst(null, RequestProcessor.class)).post(new Runnable(){
                final /* synthetic */ VariablesActionsProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.goToSource((Field)node);
                }
            });
            return;
        }
        if (node.toString().startsWith("SubArray")) {
            return;
        }
        if (node.equals("NoInfo")) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private void goToSource(Field variable) {
        SourcePath ectx = (SourcePath)this.lookupProvider.lookupFirst(null, SourcePath.class);
        ectx.showSource(variable);
    }

    private boolean isSourceAvailable(Field v) {
        SourcePath ectx = (SourcePath)this.lookupProvider.lookupFirst(null, SourcePath.class);
        return ectx.sourceAvailable(v);
    }

    private void showSource(final JPDAClassType type) {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            final String typePath = EditorContextBridge.getRelativePath(type.getName());
            final String url = ((JPDADebuggerImpl)debugger).getEngineContext().getURL(type, null);
            final int lineNumber = VariablesActionsProvider.findClassLine(url, type.getName());
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ VariablesActionsProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    boolean success = EditorContextBridge.getContext().showSource(url, lineNumber, null);
                    if (!success) {
                        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(VariablesActionsProvider.class, (String)"MSG_NoSourceFile", (Object)typePath, (Object)type), 2);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)d);
                    }
                }
            });
        }
    }

    private static int findClassLine(String url, String clazz) {
        Class<?> editorContextImpl;
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException ex) {
            return 1;
        }
        String editorContextImplName = "org.netbeans.modules.debugger.jpda.projects.EditorContextSupport";
        try {
            editorContextImpl = Thread.currentThread().getContextClassLoader().loadClass(editorContextImplName);
        }
        catch (ClassNotFoundException cnfex) {
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (cl == null) {
                return 1;
            }
            try {
                editorContextImpl = cl.loadClass(editorContextImplName);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return 1;
            }
        }
        try {
            Method getClassLineNumber = editorContextImpl.getDeclaredMethod("getClassLineNumber", FileObject.class, String.class, String[].class);
            getClassLineNumber.setAccessible(true);
            Future lineNumberFuture = (Future)getClassLineNumber.invoke(null, fo, clazz, new String[0]);
            if (lineNumberFuture == null) {
                return 1;
            }
            Integer line = (Integer)lineNumberFuture.get();
            if (line == null) {
                return 1;
            }
            return line;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 1;
        }
    }
}

