/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.PersistentController;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.debugger");
    private final List<Connector> connectors;
    private JComboBox cbConnectors;
    private Connector selectedConnector;
    private JTextField[] tfParams;
    private ConnectController controller;
    private final DocumentListener validityDocumentListener = new ValidityDocumentListener();
    private final Cursor standardCursor;
    private final AtomicBoolean connectorsLoaded = new AtomicBoolean(false);
    private static final RequestProcessor RP = new RequestProcessor(ConnectPanel.class.getName());

    public ConnectPanel() {
        this.connectors = new ArrayList<Connector>();
        this.standardCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        RP.post(new Runnable(){

            @Override
            public void run() {
                ConnectPanel.this.initConnectors();
            }
        });
        this.controller = new ConnectController();
        this.controller.setValid(false);
    }

    public Controller getController() {
        return this.controller;
    }

    private void initConnectors() {
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        this.connectors.addAll(vmm.attachingConnectors());
        this.connectors.addAll(vmm.listeningConnectors());
        Iterator<Connector> ci = this.connectors.iterator();
        while (ci.hasNext()) {
            String name = ci.next().name();
            int index = name.lastIndexOf(46);
            if (index >= 0) {
                name = name.substring(index + 1);
            }
            if (!name.equalsIgnoreCase("SACoreAttachingConnector") && !name.equalsIgnoreCase("SAPIDAttachingConnector") && !name.equalsIgnoreCase("SADebugServerAttachingConnector")) continue;
            ci.remove();
        }
        int defaultIndex = 0;
        String lacn = Properties.getDefault().getProperties("debugger").getString("last_attaching_connector", "");
        int k = this.connectors.size();
        for (int i = 0; i < k; ++i) {
            Connector connector = this.connectors.get(i);
            if (lacn == null || !connector.name().equals(lacn)) continue;
            defaultIndex = i;
        }
        final int finalDefaultIndex = defaultIndex;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){
                final /* synthetic */ ConnectPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.addConnectors(finalDefaultIndex);
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnectorsLoad() {
        AtomicBoolean atomicBoolean = this.connectorsLoaded;
        synchronized (atomicBoolean) {
            while (!this.connectorsLoaded.get()) {
                try {
                    this.connectorsLoaded.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnectors(int defaultIndex) {
        if (this.connectors.isEmpty()) {
            this.add(new JLabel(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_No_Connector")));
            return;
        }
        if (this.connectors.size() > 1) {
            this.cbConnectors = new JComboBox();
            this.cbConnectors.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Connector"));
            int k = this.connectors.size();
            for (int i = 0; i < k; ++i) {
                Connector connector = this.connectors.get(i);
                int jj = connector.name().lastIndexOf(46);
                String s = jj < 0 ? connector.name() : connector.name().substring(jj + 1);
                this.cbConnectors.addItem(s + " (" + connector.description() + ")");
            }
            this.cbConnectors.setActionCommand("SwitchMe!");
            this.cbConnectors.addActionListener(this);
        }
        this.cbConnectors.setSelectedIndex(defaultIndex);
        this.selectedConnector = this.connectors.get(defaultIndex);
        this.setCursor(this.standardCursor);
        AtomicBoolean atomicBoolean = this.connectorsLoaded;
        synchronized (atomicBoolean) {
            this.connectorsLoaded.set(true);
            this.connectorsLoaded.notifyAll();
        }
    }

    private void refresh(int index, Properties properties) {
        GridBagConstraints c;
        Connector connector;
        assert (SwingUtilities.isEventDispatchThread());
        this.removeAll();
        this.selectedConnector = connector = this.connectors.get(index);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        if (this.cbConnectors != null) {
            c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 3, 3);
            c.anchor = 17;
            JLabel lblConnectors = new JLabel();
            Mnemonics.setLocalizedText((JLabel)lblConnectors, (String)NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Connector"));
            lblConnectors.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Connector"));
            lblConnectors.setLabelFor(this.cbConnectors);
            layout.setConstraints(lblConnectors, c);
            this.add(lblConnectors);
            c.insets = new Insets(0, 3, 3, 0);
            c.weightx = 1.0;
            c.fill = 2;
            c.gridwidth = 0;
            layout.setConstraints(this.cbConnectors, c);
            this.add(this.cbConnectors);
        }
        c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 0, 6);
        c.anchor = 17;
        JLabel lblTransport = new JLabel();
        Mnemonics.setLocalizedText((JLabel)lblTransport, (String)NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Transport"));
        lblTransport.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Transport"));
        layout.setConstraints(lblTransport, c);
        this.add(lblTransport);
        final JTextField tfTransport = new JTextField();
        tfTransport.setEditable(false);
        lblTransport.setLabelFor(tfTransport);
        c.gridwidth = 0;
        c.insets = new Insets(3, 3, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        layout.setConstraints(tfTransport, c);
        Transport t = connector.transport();
        tfTransport.setText(t != null ? t.name() : "");
        tfTransport.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Transport"));
        tfTransport.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ ConnectPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                tfTransport.selectAll();
            }
        });
        this.add(tfTransport);
        Map<String, Connector.Argument> args = ConnectPanel.getSavedArgs(connector, properties);
        this.tfParams = new JTextField[args.size()];
        Iterator<String> it = new TreeSet<String>(args.keySet()).iterator();
        int i = 0;
        while (it.hasNext()) {
            String name = it.next();
            Connector.Argument a = args.get(name);
            String label = ConnectPanel.translate(a.name());
            if (label == null) {
                label = "&" + a.label();
            }
            c = new GridBagConstraints();
            c.insets = new Insets(6, 0, 0, 3);
            c.anchor = 17;
            JLabel iLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)iLabel, (String)label);
            iLabel.setToolTipText(a.description());
            this.add((Component)iLabel, c);
            JTextField tfParam = new JTextField(a.value());
            iLabel.setLabelFor(tfParam);
            tfParam.setName(name);
            tfParam.getAccessibleContext().setAccessibleDescription(new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Argument")).format(new Object[]{label}));
            tfParam.setToolTipText(a.description());
            c = new GridBagConstraints();
            c.gridwidth = 0;
            c.insets = new Insets(6, 3, 0, 0);
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)tfParam, c);
            tfParam.getDocument().addDocumentListener(this.validityDocumentListener);
            this.tfParams[i++] = tfParam;
        }
        c = new GridBagConstraints();
        c.weighty = 1.0;
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(1, 1));
        this.add((Component)p, c);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectPanel.this.checkValid();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedIndex = ((JComboBox)e.getSource()).getSelectedIndex();
        this.refresh(selectedIndex, Properties.getDefault().getProperties("debugger"));
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            w.pack();
        }
    }

    private static void log(Connector c, Map<String, Connector.Argument> args) {
        LogRecord record = new LogRecord(Level.INFO, "USG_DEBUG_ATTACH_JPDA");
        record.setResourceBundle(NbBundle.getBundle(ConnectPanel.class));
        record.setResourceBundleName(ConnectPanel.class.getPackage().getName() + ".Bundle");
        record.setLoggerName(USG_LOGGER.getName());
        ArrayList<CharSequence> params = new ArrayList<CharSequence>();
        params.add(c.name());
        StringBuilder arguments = new StringBuilder();
        for (Map.Entry<String, Connector.Argument> argEntry : args.entrySet()) {
            arguments.append(argEntry.getValue());
            arguments.append(", ");
        }
        if (arguments.length() > 2) {
            arguments.delete(arguments.length() - 2, arguments.length());
        }
        params.add(arguments);
        record.setParameters(params.toArray(new Object[0]));
        USG_LOGGER.log(record);
    }

    private static boolean isUnknownHost(String hostname) {
        if (hostname == null) {
            return true;
        }
        int length = hostname.length();
        if (length == 0) {
            return true;
        }
        if (length < 6) {
            return false;
        }
        char firstChar = hostname.charAt(0);
        if ('a' <= firstChar && firstChar <= 'z' || 'A' <= firstChar && firstChar <= 'Z' || firstChar == '-') {
            return false;
        }
        char c = hostname.charAt(5);
        if (c == firstChar) {
            return hostname.substring(1, 5).equalsIgnoreCase("none");
        }
        if (length < 9) {
            return false;
        }
        c = hostname.charAt(8);
        if (c == firstChar) {
            return hostname.substring(1, 8).equalsIgnoreCase("unknown");
        }
        return false;
    }

    private static Map<String, Connector.Argument> getSavedArgs(Connector connector, Properties properties) {
        Map<String, Connector.Argument> args = connector.defaultArguments();
        Map savedArgs = properties.getMap("connection_settings", new HashMap());
        if ((savedArgs = (Map)savedArgs.get(connector.name())) == null) {
            return args;
        }
        for (String argName : args.keySet()) {
            String savedValue = (String)savedArgs.get(argName);
            if (savedValue == null) continue;
            args.get(argName).setValue(savedValue);
        }
        return args;
    }

    private static Map<String, Connector.Argument> getEditedArgs(JTextField[] tfParams, Connector connector) {
        assert (SwingUtilities.isEventDispatchThread());
        Map<String, Connector.Argument> args = connector.defaultArguments();
        for (JTextField tf : tfParams) {
            String paramName = tf.getName();
            String paramValue = tf.getText();
            Connector.Argument a = args.get(paramName);
            while (!a.isValid(paramValue) && !"".equals(paramValue) || "".equals(paramValue) && a.mustSpecify()) {
                String label = ConnectPanel.getLabel(a);
                NotifyDescriptor.InputLine in = "".equals(paramValue) && a.mustSpecify() ? new NotifyDescriptor.InputLine(label, NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Required_value_title")) : new NotifyDescriptor.InputLine(label, NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Invalid_value_title"));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)in) == NotifyDescriptor.CANCEL_OPTION) {
                    return null;
                }
                paramValue = in.getInputText();
            }
            a.setValue(paramValue);
        }
        return args;
    }

    private static void saveArgs(Map<String, Connector.Argument> args, Connector connector) {
        Map<String, Connector.Argument> defaultValues = connector.defaultArguments();
        HashMap<String, String> argsToSave = new HashMap<String, String>();
        for (Map.Entry<String, Connector.Argument> entry : args.entrySet()) {
            String argName = entry.getKey();
            Connector.Argument value = entry.getValue();
            Connector.Argument defaultValue = defaultValues.get(argName);
            if (value == null || value == defaultValue || value.equals(defaultValue)) continue;
            argsToSave.put(argName, value.value());
        }
        Map m = Properties.getDefault().getProperties("debugger").getMap("connection_settings", new HashMap());
        String name = connector.name();
        m.put(name, argsToSave);
        Properties.getDefault().getProperties("debugger").setString("last_attaching_connector", name);
        Properties.getDefault().getProperties("debugger").setMap("connection_settings", m);
    }

    private static String getLabel(Connector.Argument a) {
        String label = ConnectPanel.translate(a.name());
        if (label == null) {
            label = a.label();
        } else {
            int amp = Mnemonics.findMnemonicAmpersand((String)label);
            if (amp >= 0) {
                label = label.substring(0, amp) + label.substring(amp + 1);
            }
        }
        return label;
    }

    private static String translate(String str) {
        try {
            return NbBundle.getMessage(ConnectPanel.class, (String)("CTL_CA_" + str));
        }
        catch (MissingResourceException mrex) {
            ErrorManager.getDefault().log(16, "Missing resource CTL_CA_" + str + " from " + ConnectPanel.class.getName());
            return null;
        }
    }

    private void checkValid() {
        int i;
        assert (this.connectorsLoaded.get());
        assert (SwingUtilities.isEventDispatchThread()) : "Called outside of AWT.";
        int k = this.tfParams.length;
        Map<String, Connector.Argument> args = this.selectedConnector.defaultArguments();
        for (i = 0; i < k; ++i) {
            JTextField tf = this.tfParams[i];
            String paramName = tf.getName();
            String paramValue = tf.getText();
            Connector.Argument a = args.get(paramName);
            if (a.mustSpecify() && "".equals(paramValue)) {
                String msg = NbBundle.getMessage(ConnectPanel.class, (String)"MSG_Required_value", (Object)ConnectPanel.getLabel(a));
                this.controller.setInformationMessage(msg);
                this.controller.setValid(false);
                break;
            }
            if ("".equals(paramValue) || a.isValid(paramValue)) continue;
            String msg = NbBundle.getMessage(ConnectPanel.class, (String)"MSG_Invalid_value", (Object)ConnectPanel.getLabel(a));
            this.controller.setErrorMessage(msg);
            this.controller.setValid(false);
            break;
        }
        if (i >= k) {
            this.controller.setErrorMessage(null);
            this.controller.setValid(true);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("debug.jpda.attach");
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ConnectPanel.this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ConnectPanel.this.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ConnectPanel.this.checkValid();
        }
    }

    public class ConnectController
    implements PersistentController {
        PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private boolean valid = true;

        public boolean cancel() {
            return true;
        }

        public boolean ok() {
            RequestProcessor.Task[] startTaskPtr;
            assert (ConnectPanel.this.connectorsLoaded.get());
            assert (SwingUtilities.isEventDispatchThread()) : "Called outside of AWT.";
            final Connector connector = ConnectPanel.this.selectedConnector;
            final Map args = ConnectPanel.getEditedArgs(ConnectPanel.this.tfParams, connector);
            if (args == null) {
                return true;
            }
            ConnectPanel.saveArgs(args, connector);
            ConnectPanel.log(connector, args);
            startTaskPtr = new RequestProcessor.Task[]{new RequestProcessor("JPDA Debugger Starting").create(new Runnable(){
                final /* synthetic */ ConnectController this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    final Thread theCurrentThread = Thread.currentThread();
                    ProgressHandle progress = ProgressHandle.createHandle((String)NbBundle.getMessage(ConnectPanel.class, (String)"CTL_connectProgress"), (Cancellable)new Cancellable(){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public boolean cancel() {
                            theCurrentThread.interrupt();
                            return startTaskPtr[0].isFinished();
                        }
                    });
                    try {
                        progress.start();
                        DebuggerEngine[] es = null;
                        if (connector instanceof AttachingConnector) {
                            es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])new Object[]{AttachingDICookie.create((AttachingConnector)((AttachingConnector)connector), (Map)args)}));
                        } else if (connector instanceof ListeningConnector) {
                            es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])new Object[]{ListeningDICookie.create((ListeningConnector)((ListeningConnector)connector), (Map)args)}));
                        }
                        if (es != null) {
                            for (int i = 0; i < es.length; ++i) {
                                JPDADebugger d = (JPDADebugger)es[i].lookupFirst(null, JPDADebugger.class);
                                if (d == null) continue;
                                try {
                                    if (d.getState() == 2) continue;
                                    d.waitRunning();
                                    continue;
                                }
                                catch (DebuggerStartException debuggerStartException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    finally {
                        progress.finish();
                    }
                }
            })};
            startTaskPtr[0].schedule(0);
            return true;
        }

        public boolean load(final Properties props) {
            assert (!SwingUtilities.isEventDispatchThread());
            ConnectPanel.this.waitForConnectorsLoad();
            String connectorName = props.getString("attaching_connector", "");
            int k = ConnectPanel.this.connectors.size();
            int indexToSelect = -1;
            for (int index = 0; index < k; ++index) {
                Connector connector = (Connector)ConnectPanel.this.connectors.get(index);
                if (!connector.name().equals(connectorName)) continue;
                indexToSelect = index;
                break;
            }
            if (indexToSelect < 0) {
                return false;
            }
            final int si = indexToSelect;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){
                    final /* synthetic */ ConnectController this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.ConnectPanel.this.cbConnectors.setSelectedIndex(si);
                        this.this$1.ConnectPanel.this.refresh(si, props);
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }

        public void save(Properties props) {
            assert (ConnectPanel.this.connectorsLoaded.get());
            final Connector[] connectorPtr = new Connector[]{null};
            final Map[] argsPtr = new Map[]{null};
            if (SwingUtilities.isEventDispatchThread()) {
                connectorPtr[0] = ConnectPanel.this.selectedConnector;
                argsPtr[0] = ConnectPanel.getEditedArgs(ConnectPanel.this.tfParams, ConnectPanel.this.selectedConnector);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){
                        final /* synthetic */ ConnectController this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            connectorPtr[0] = this.this$1.ConnectPanel.this.selectedConnector;
                            argsPtr[0] = ConnectPanel.getEditedArgs(this.this$1.ConnectPanel.this.tfParams, this.this$1.ConnectPanel.this.selectedConnector);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
            }
            Connector connector = connectorPtr[0];
            Map args = argsPtr[0];
            if (args == null) {
                return;
            }
            Map<String, Connector.Argument> defaultValues = connector.defaultArguments();
            HashMap<String, String> argsToSave = new HashMap<String, String>();
            for (String argName : args.keySet()) {
                Connector.Argument value = (Connector.Argument)args.get(argName);
                Connector.Argument defaultValue = defaultValues.get(argName);
                if (value == null || value == defaultValue || value.equals(defaultValue)) continue;
                argsToSave.put(argName, value.value());
            }
            HashMap<String, HashMap<String, String>> m = new HashMap<String, HashMap<String, String>>();
            String name = connector.name();
            m.put(name, argsToSave);
            props.setMap("connection_settings", m);
            props.setString("attaching_connector", connector.name());
        }

        public String getDisplayName() {
            AttachingDICookie c;
            assert (ConnectPanel.this.connectorsLoaded.get());
            Connector connector = ConnectPanel.this.selectedConnector;
            Map args = ConnectPanel.getEditedArgs(ConnectPanel.this.tfParams, connector);
            if (args == null) {
                return "";
            }
            if (connector instanceof AttachingConnector) {
                c = AttachingDICookie.create((AttachingConnector)((AttachingConnector)connector), (Map)args);
                if (c.getHostName() != null) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Attach_to_socket")).format(new Object[]{c.getHostName(), String.valueOf(c.getPortNumber())});
                }
                if (c.getSharedMemoryName() != null) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Attach_to_shmem")).format(new Object[]{c.getSharedMemoryName()});
                }
                if (c.getArgs().get("pid") != null) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Attach_to_pid")).format(new Object[]{((Connector.Argument)c.getArgs().get("pid")).toString()});
                }
            }
            if (connector instanceof ListeningConnector) {
                c = ListeningDICookie.create((ListeningConnector)((ListeningConnector)connector), (Map)args);
                if (c.getSharedMemoryName() != null) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Listen_on_shmem")).format(new Object[]{c.getSharedMemoryName()});
                }
                if (c.getPortNumber() > 0) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Listen_on_socket")).format(new Object[]{String.valueOf(c.getPortNumber())});
                }
            }
            return "";
        }

        public boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
            this.firePropertyChange("valid", !valid, valid);
        }

        void setErrorMessage(String msg) {
            this.firePropertyChange("errorNotification", null, msg);
        }

        void setInformationMessage(String msg) {
            this.firePropertyChange("infoNotification", null, msg);
        }

        private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }
    }
}

