/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.ddl.DDLCommand;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class AbstractCommand
implements Serializable,
DDLCommand {
    private static final Logger LOG = Logger.getLogger(AbstractCommand.class.getName());
    private DatabaseSpecification spec;
    boolean executionWithException;
    private String format;
    private String owner;
    private String name;
    private Map addprops;
    static final long serialVersionUID = -560515030304320086L;
    private String quoteStr;
    private boolean newObject = false;

    @Override
    public DatabaseSpecification getSpecification() {
        return this.spec;
    }

    public void setSpecification(DatabaseSpecification specification) {
        this.spec = specification;
    }

    public void setFormat(String fmt) {
        this.format = fmt;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public void setObjectName(String nam) {
        this.name = nam;
    }

    public String getObjectOwner() {
        if (this.owner != null && this.owner.trim().equals("")) {
            this.setObjectOwner(null);
        }
        return this.owner;
    }

    public void setObjectOwner(String objectowner) {
        this.owner = objectowner;
    }

    public boolean isNewObject() {
        return this.newObject;
    }

    public void setNewObject(boolean newObject) {
        this.newObject = newObject;
    }

    public Object getProperty(String pname) {
        return this.addprops.get(pname);
    }

    public void setProperty(String pname, Object pval) {
        if (this.addprops == null) {
            this.addprops = new HashMap();
        }
        this.addprops.put(pname, pval);
    }

    public Map getCommandProperties() throws DDLException {
        String oname;
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.addprops != null) {
            args.putAll(this.addprops);
        }
        if ((oname = this.getObjectName()) == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_Unknown"));
        }
        args.put("object.name", this.newObject ? this.getObjectName() : this.quote(this.getObjectName()));
        args.put("object.owner", this.quote(this.getObjectOwner()));
        return args;
    }

    @Override
    public void execute() throws DDLException {
        String fcmd;
        Connection fcon = null;
        boolean opened = false;
        this.executionWithException = false;
        try {
            fcmd = this.getCommand();
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            this.executionWithException = true;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_UnableToFormat") + "\n" + this.format + "\n" + e.getMessage()), 0));
            return;
        }
        LOG.fine(fcmd);
        try {
            fcon = this.spec.getJDBCConnection();
            if (fcon == null) {
                fcon = this.spec.openJDBCConnection();
                opened = true;
            }
            Statement stat = fcon.createStatement();
            stat.execute(fcmd);
            stat.close();
        }
        catch (Exception e) {
            this.executionWithException = true;
            if (opened && fcon != null) {
                this.spec.closeJDBCConnection();
            }
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_UnableToExecute") + "\n" + fcmd + "\n" + e.getMessage());
        }
        if (opened) {
            this.spec.closeJDBCConnection();
        }
    }

    @Override
    public String getCommand() throws DDLException {
        if (this.format == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_NoFormatSpec"));
        }
        try {
            Map props = this.getCommandProperties();
            return CommandFormatter.format(this.format, props);
        }
        catch (Exception e) {
            throw new DDLException(e.getMessage());
        }
    }

    @Override
    public boolean wasException() {
        return this.executionWithException;
    }

    private String getQuoteString() {
        try {
            this.quoteStr = this.getSpecification().getJDBCConnection().getMetaData().getIdentifierQuoteString();
            if (this.getSpecification().getJDBCConnection().getMetaData().getDatabaseProductName().indexOf("Firebird") != -1) {
                this.quoteStr = "";
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.quoteStr == null) {
            this.quoteStr = "";
        } else {
            this.quoteStr.trim();
        }
        return this.quoteStr;
    }

    public String quote(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        if (this.quoteStr == null) {
            this.quoteStr = this.getQuoteString();
        }
        return this.quoteStr + name + this.quoteStr;
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.format = (String)in.readObject();
        this.owner = (String)in.readObject();
        this.name = (String)in.readObject();
        this.addprops = (Map)in.readObject();
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.format);
        out.writeObject(this.owner);
        out.writeObject(this.name);
        out.writeObject(this.addprops);
    }
}

