/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.bridge;

import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class AbstractServerLookup<T>
extends AbstractLookup
implements ServerRegistry.PluginListener {
    private static final Logger LOGGER = Logger.getLogger(AbstractServerLookup.class.getName());
    private static final Object LOCK = new Object();
    private final InstanceContent content;
    private final Map<Server, T> serversMap = new HashMap<Server, T>();
    private boolean initialized;

    protected AbstractServerLookup(InstanceContent content) {
        super((AbstractLookup.Content)content);
        this.content = content;
    }

    @Override
    public final void serverAdded(Server server) {
        this.stateChanged();
    }

    @Override
    public final void serverRemoved(Server server) {
        this.stateChanged();
    }

    protected abstract T createBridgingInstance(Server var1);

    protected abstract void afterAddition(T var1);

    protected abstract void beforeFinish(T var1);

    protected abstract void finishBridgingInstance(Server var1, T var2);

    protected final void beforeLookup(Lookup.Template<?> template) {
        if (!Thread.currentThread().getName().equals("Folder recognizer")) {
            this.init();
        }
        super.beforeLookup(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = LOCK;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            ServerRegistry registry = ServerRegistry.getInstance();
            registry.addPluginListener((ServerRegistry.PluginListener)WeakListeners.create(ServerRegistry.PluginListener.class, (EventListener)this, (Object)registry));
            LOGGER.log(Level.FINE, "Registered bridging listener");
            this.initialized = true;
        }
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChanged() {
        LOGGER.log(Level.FINE, "Updating the lookup content");
        HashSet<Server> servers = new HashSet<Server>(ServerRegistry.getInstance().getServers());
        Object object = LOCK;
        synchronized (object) {
            Iterator<Map.Entry<Server, Object>> it = this.serversMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Server, T> entry = it.next();
                Server server = entry.getKey();
                if (!servers.contains(server)) {
                    this.beforeFinish(entry.getValue());
                    this.content.remove(this.serversMap.get(server));
                    it.remove();
                    this.finishBridgingInstance(server, entry.getValue());
                    continue;
                }
                servers.remove(server);
            }
            for (Server server : servers) {
                T instance = this.createBridgingInstance(server);
                if (instance == null) continue;
                this.content.add(instance);
                this.serversMap.put(server, instance);
                this.afterAddition(instance);
            }
        }
        LOGGER.log(Level.FINE, "Lookup content updated");
    }
}

