/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ListVariable
extends VariableBase {
    private final List<ArrayElement> elements = new ArrayList<ArrayElement>();
    private final SyntaxType syntaxType;

    private ListVariable(int start, int end, ArrayElement[] elements, SyntaxType syntaxType) {
        super(start, end);
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        this.elements.addAll(Arrays.asList(elements));
        this.syntaxType = syntaxType;
    }

    public ListVariable(int start, int end, List<ArrayElement> elements, SyntaxType syntaxType) {
        this(start, end, elements == null ? null : elements.toArray(new ArrayElement[0]), syntaxType);
    }

    public List<ArrayElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public SyntaxType getSyntaxType() {
        return this.syntaxType;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.getElements().forEach(element -> sb.append(element).append(","));
        return this.syntaxType.toString(sb.toString());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SyntaxType {
        OLD{

            @Override
            String toString(String innerElements) {
                return "list(" + innerElements + ")";
            }
        }
        ,
        NEW{

            @Override
            String toString(String innerElements) {
                return "[" + innerElements + "]";
            }
        };


        abstract String toString(String var1);
    }
}

