/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ClassConstantDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.openide.util.Parameters;

public final class TypeConstantElementImpl
extends PhpElementImpl
implements TypeConstantElement {
    public static final String IDX_FIELD = "clz.const";
    private final TypeElement enclosingType;
    private final String value;
    private final boolean isMagic;
    private final PhpModifiers modifiers;
    @NullAllowed
    private final String declaredType;

    private TypeConstantElementImpl(TypeElement enclosingType, String declaredType, String constantName, String value, int offset, int flags, String fileUrl, ElementQuery elementQuery, boolean isDeprecated) {
        this(enclosingType, declaredType, constantName, value, offset, flags, fileUrl, elementQuery, isDeprecated, false);
    }

    private TypeConstantElementImpl(TypeElement enclosingType, String declaredType, String constantName, String value, int offset, int flags, String fileUrl, ElementQuery elementQuery, boolean isDeprecated, boolean isMagic) {
        super(constantName, enclosingType.getName(), fileUrl, offset, elementQuery, isDeprecated);
        this.enclosingType = enclosingType;
        this.declaredType = declaredType;
        this.value = value;
        this.isMagic = isMagic;
        this.modifiers = PhpModifiers.fromBitMask(flags);
    }

    public static Set<TypeConstantElement> getMagicConstants(TypeElement type) {
        HashSet<TypeConstantElement> retval = new HashSet<TypeConstantElement>();
        retval.add(TypeConstantElementImpl.createMagicConstant(type, "class"));
        return retval;
    }

    private static TypeConstantElement createMagicConstant(TypeElement type, String constantName) {
        TypeConstantElementImpl retval = new TypeConstantElementImpl(type, null, constantName, type.getFullyQualifiedName().toString(), 0, 1, type.getFilenameUrl(), null, type.isDeprecated(), true);
        return retval;
    }

    public static Set<TypeConstantElement> fromSignature(TypeElement type, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return TypeConstantElementImpl.fromSignature(type, (NameKind)NameKind.empty(), indexScopeQuery, indexResult);
    }

    public static Set<TypeConstantElement> fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<TypeConstantElement> retval = values.length > 0 ? new HashSet<TypeConstantElement>() : Collections.emptySet();
        for (String val : values) {
            TypeConstantElement constant = TypeConstantElementImpl.fromSignature(type, query, indexScopeQuery, Signature.get(val));
            if (constant == null) continue;
            retval.add(constant);
        }
        return retval;
    }

    private static TypeConstantElement fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, Signature signature) {
        ConstantSignatureParser signParser = new ConstantSignatureParser(signature);
        TypeConstantElementImpl retval = null;
        if (TypeConstantElementImpl.matchesQuery(query, signParser)) {
            retval = new TypeConstantElementImpl(type, signParser.getDeclaredType(), signParser.getConstantName(), signParser.getValue(), signParser.getOffset(), signParser.getFlags(), signParser.getFileUrl(), indexScopeQuery, signParser.isDeprecated());
        }
        return retval;
    }

    public static Set<TypeConstantElement> fromNode(TypeElement type, ConstantDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        List<? extends ClassConstantDeclarationInfo> consts = ClassConstantDeclarationInfo.create(node);
        HashSet<TypeConstantElement> retval = new HashSet<TypeConstantElement>();
        for (ClassConstantDeclarationInfo classConstantDeclarationInfo : consts) {
            retval.add(new TypeConstantElementImpl(type, classConstantDeclarationInfo.getDeclaredType(), classConstantDeclarationInfo.getName(), classConstantDeclarationInfo.getValue(), classConstantDeclarationInfo.getRange().getStart(), classConstantDeclarationInfo.getAccessModifiers().toFlags(), fileQuery.getURL().toExternalForm(), fileQuery, VariousUtils.isDeprecated(fileQuery.getResult().getModel().getFileScope(), fileQuery.getResult().getProgram(), node)));
        }
        return retval;
    }

    private static boolean matchesQuery(NameKind query, ConstantSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(TypeConstantElement.KIND, signParser.getConstantName());
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase(Locale.ROOT)).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getValue()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isDeprecated() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getFilenameUrl()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getDeclaredType() == null ? "" : this.getDeclaredType()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        this.checkSignature(sb);
        return sb.toString();
    }

    @Override
    public PhpModifiers getPhpModifiers() {
        return this.modifiers;
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return TypeConstantElement.KIND;
    }

    @Override
    public TypeElement getType() {
        return this.enclosingType;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            ConstantSignatureParser parser = new ConstantSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getConstantName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            if (this.getDeclaredType() != null) assert (this.getDeclaredType().equals(parser.getDeclaredType())) : "getDeclaredType(): " + this.getDeclaredType() + ", parser.getDeclaredType(): " + parser.getDeclaredType();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    @CheckForNull
    public String getDeclaredType() {
        return this.declaredType;
    }

    @Override
    public boolean isStatic() {
        return this.getPhpModifiers().isStatic();
    }

    @Override
    public boolean isPublic() {
        return this.getPhpModifiers().isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.getPhpModifiers().isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.getPhpModifiers().isPrivate();
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    @Override
    public boolean isMagic() {
        return this.isMagic;
    }

    private static class ConstantSignatureParser {
        private final Signature signature;

        ConstantSignatureParser(Signature signature) {
            this.signature = signature;
        }

        String getConstantName() {
            return this.signature.string(1);
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        String getValue() {
            return this.signature.string(3);
        }

        boolean isDeprecated() {
            return this.signature.integer(4) == 1;
        }

        String getFileUrl() {
            return this.signature.string(5);
        }

        int getFlags() {
            return this.signature.integer(6);
        }

        @CheckForNull
        String getDeclaredType() {
            String declaredType = this.signature.string(7);
            if (declaredType.isEmpty()) {
                declaredType = null;
            }
            return declaredType;
        }
    }
}

