/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.organization;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.cache.infinispan.CachedCount;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.UserCacheSession;
import org.keycloak.models.cache.infinispan.idp.InfinispanIdentityProviderStorageProvider;
import org.keycloak.models.cache.infinispan.organization.CachedMembership;
import org.keycloak.models.cache.infinispan.organization.CachedOrganization;
import org.keycloak.models.cache.infinispan.organization.CachedOrganizationIds;
import org.keycloak.models.cache.infinispan.organization.InfinispanInvitationManager;
import org.keycloak.models.cache.infinispan.organization.OrganizationAdapter;
import org.keycloak.organization.InvitationManager;
import org.keycloak.organization.OrganizationProvider;

public class InfinispanOrganizationProvider
implements OrganizationProvider {
    private static final String ORG_COUNT_KEY_SUFFIX = ".org.count";
    private static final String ORG_MEMBERS_COUNT_KEY_SUFFIX = ".members.count";
    private final KeycloakSession session;
    private final UserCacheSession userCache;
    private final InfinispanInvitationManager invitationManager;
    private OrganizationProvider orgDelegate;
    private final RealmCacheSession realmCache;
    private final Map<String, OrganizationAdapter> managedOrganizations = new HashMap<String, OrganizationAdapter>();

    public InfinispanOrganizationProvider(KeycloakSession session) {
        this.session = session;
        this.realmCache = (RealmCacheSession)session.getProvider(CacheRealmProvider.class);
        this.userCache = (UserCacheSession)session.getProvider(UserCache.class);
        this.invitationManager = new InfinispanInvitationManager(this.getDelegate().getInvitationManager());
    }

    private static String cacheKeyOrgCount(RealmModel realm) {
        return realm.getId() + ORG_COUNT_KEY_SUFFIX;
    }

    public static String cacheKeyOrgMemberCount(RealmModel realm, OrganizationModel organization) {
        return realm.getId() + ".org." + organization.getId() + ORG_MEMBERS_COUNT_KEY_SUFFIX;
    }

    public OrganizationModel create(String id, String name, String alias) {
        this.registerCountInvalidation();
        return this.getDelegate().create(id, name, alias);
    }

    OrganizationProvider getDelegate() {
        if (this.orgDelegate == null) {
            this.orgDelegate = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class, "jpa");
        }
        return this.orgDelegate;
    }

    public boolean remove(OrganizationModel organization) {
        this.registerOrganizationInvalidation(organization);
        this.registerCountInvalidation();
        return this.getDelegate().remove(organization);
    }

    public OrganizationModel getById(String id) {
        if (this.realmCache == null) {
            return this.getDelegate().getById(id);
        }
        CachedOrganization cached = this.realmCache.getCache().get(id, CachedOrganization.class);
        String realmId = this.getRealm().getId();
        if (cached != null && !cached.getRealm().equals(realmId)) {
            cached = null;
        }
        if (cached == null) {
            Long loaded = this.realmCache.getCache().getCurrentRevision(id);
            OrganizationModel model = this.getDelegate().getById(id);
            if (model == null) {
                return null;
            }
            if (this.isRealmCacheKeyInvalid(id)) {
                return model;
            }
            cached = new CachedOrganization(loaded, this.getRealm(), model);
            this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        } else {
            if (this.isRealmCacheKeyInvalid(id)) {
                return this.getDelegate().getById(id);
            }
            if (this.managedOrganizations.containsKey(id)) {
                return this.managedOrganizations.get(id);
            }
        }
        OrganizationAdapter adapter = new OrganizationAdapter(this.session, cached, this::getDelegate, this);
        this.managedOrganizations.put(id, adapter);
        return adapter;
    }

    public OrganizationModel getByDomainName(String domainName) {
        if (this.realmCache == null) {
            return this.getDelegate().getByDomainName(domainName);
        }
        String cacheKey = this.cacheKeyByDomain(domainName);
        if (this.isRealmCacheKeyInvalid(cacheKey)) {
            return this.getDelegate().getByDomainName(domainName);
        }
        CachedOrganizationIds cached = this.realmCache.getCache().get(cacheKey, CachedOrganizationIds.class);
        if (cached == null) {
            Long loaded = this.realmCache.getCache().getCurrentRevision(cacheKey);
            OrganizationModel model = this.getDelegate().getByDomainName(domainName);
            if (model == null) {
                return null;
            }
            cached = new CachedOrganizationIds(loaded, cacheKey, this.getRealm(), Stream.ofNullable(model));
            this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        }
        return cached.getOrgIds().stream().map(this::getById).findAny().orElse(null);
    }

    public Stream<OrganizationModel> getAllStream(String search, Boolean exact, Integer first, Integer max) {
        return this.getCacheDelegates(this.getDelegate().getAllStream(search, exact, first, max));
    }

    public Stream<OrganizationModel> getAllStream(Map<String, String> attributes, Integer first, Integer max) {
        return this.getCacheDelegates(this.getDelegate().getAllStream(attributes, first, max));
    }

    public long count(String search, Boolean exact) {
        return this.getDelegate().count(search, exact);
    }

    public long count(Map<String, String> attributes) {
        return this.getDelegate().count(attributes);
    }

    public void removeAll() {
        this.getAllStream().forEach(this::remove);
    }

    public boolean addManagedMember(OrganizationModel organization, UserModel user) {
        this.registerMemberInvalidation(organization, user);
        return this.getDelegate().addManagedMember(organization, user);
    }

    public boolean addMember(OrganizationModel organization, UserModel user) {
        this.registerMemberInvalidation(organization, user);
        return this.getDelegate().addMember(organization, user);
    }

    public boolean removeMember(OrganizationModel organization, UserModel member) {
        this.registerMemberInvalidation(organization, member);
        return this.getDelegate().removeMember(organization, member);
    }

    public Stream<UserModel> getMembersStream(OrganizationModel organization, String search, Boolean exact, Integer first, Integer max) {
        Map<String, String> filters = Optional.ofNullable(search).map(value -> Map.of("keycloak.session.realm.users.query.search", value)).orElse(Map.of());
        return this.getMembersStream(organization, filters, exact, first, max);
    }

    public Stream<UserModel> getMembersStream(OrganizationModel organization, Map<String, String> filters, Boolean exact, Integer first, Integer max) {
        return this.getDelegate().getMembersStream(organization, filters, exact, first, max);
    }

    public long getMembersCount(OrganizationModel organization) {
        if (this.realmCache == null) {
            return this.getDelegate().getMembersCount(organization);
        }
        String cacheKey = InfinispanOrganizationProvider.cacheKeyOrgMemberCount(this.getRealm(), organization);
        CachedCount cached = this.realmCache.getCache().get(cacheKey, CachedCount.class);
        if (cached != null && !this.isRealmCacheKeyInvalid(cacheKey)) {
            return cached.getCount();
        }
        Long loaded = this.realmCache.getCache().getCurrentRevision(cacheKey);
        long membersCount = this.getDelegate().getMembersCount(organization);
        cached = new CachedCount(loaded, this.getRealm(), cacheKey, membersCount);
        this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        return membersCount;
    }

    public UserModel getMemberById(OrganizationModel organization, String id) {
        if (this.userCache == null) {
            return this.getDelegate().getMemberById(organization, id);
        }
        RealmModel realm = this.getRealm();
        UserModel user = this.session.users().getUserById(realm, id);
        if (user == null) {
            return null;
        }
        String cacheKey = this.cacheKeyMembership(realm, organization, user);
        if (this.isUserCacheKeyInvalid(cacheKey)) {
            return this.getDelegate().getMemberById(organization, user.getId());
        }
        CachedMembership cached = this.userCache.getCache().get(cacheKey, CachedMembership.class);
        if (cached == null) {
            boolean isManaged = this.getDelegate().isManagedMember(organization, user);
            Long loaded = this.userCache.getCache().getCurrentRevision(cacheKey);
            UserModel member = this.getDelegate().getMemberById(organization, user.getId());
            cached = new CachedMembership(loaded, cacheKey, realm, isManaged, member != null);
            this.userCache.getCache().addRevisioned(cached, this.userCache.getStartupRevision());
        }
        return cached.isMember() ? user : null;
    }

    public Stream<OrganizationModel> getByMember(UserModel member) {
        if (this.userCache == null) {
            return this.getDelegate().getByMember(member);
        }
        String cacheKey = this.cacheKeyByMember(member);
        if (this.isUserCacheKeyInvalid(cacheKey)) {
            return this.getDelegate().getByMember(member);
        }
        CachedOrganizationIds cached = this.userCache.getCache().get(cacheKey, CachedOrganizationIds.class);
        if (cached == null) {
            Long loaded = this.userCache.getCache().getCurrentRevision(cacheKey);
            Stream model = this.getDelegate().getByMember(member);
            cached = new CachedOrganizationIds(loaded, cacheKey, this.getRealm(), model);
            this.userCache.getCache().addRevisioned(cached, this.userCache.getStartupRevision());
        }
        return cached.getOrgIds().stream().map(this::getById);
    }

    public boolean isManagedMember(OrganizationModel organization, UserModel user) {
        if (this.userCache == null) {
            return this.getDelegate().isManagedMember(organization, user);
        }
        if (user == null) {
            return false;
        }
        String cacheKey = this.cacheKeyMembership(this.getRealm(), organization, user);
        CachedMembership cached = this.userCache.getCache().get(cacheKey, CachedMembership.class);
        if (cached == null || this.isUserCacheKeyInvalid(cacheKey)) {
            return this.getDelegate().isManagedMember(organization, user);
        }
        return cached.isManaged();
    }

    public boolean addIdentityProvider(OrganizationModel organization, IdentityProviderModel identityProvider) {
        boolean added = this.getDelegate().addIdentityProvider(organization, identityProvider);
        if (added) {
            this.registerOrganizationInvalidation(organization);
        }
        return added;
    }

    public Stream<IdentityProviderModel> getIdentityProviders(OrganizationModel organization) {
        return this.getDelegate().getIdentityProviders(organization);
    }

    public boolean removeIdentityProvider(OrganizationModel organization, IdentityProviderModel identityProvider) {
        boolean removed = this.getDelegate().removeIdentityProvider(organization, identityProvider);
        if (removed) {
            this.registerOrganizationInvalidation(organization);
        }
        return removed;
    }

    public boolean isEnabled() {
        return this.getRealm().isOrganizationsEnabled();
    }

    public long count() {
        if (this.realmCache == null) {
            return this.getDelegate().count();
        }
        String cacheKey = InfinispanOrganizationProvider.cacheKeyOrgCount(this.getRealm());
        CachedCount cached = this.realmCache.getCache().get(cacheKey, CachedCount.class);
        if (cached != null && !this.isRealmCacheKeyInvalid(cacheKey)) {
            return cached.getCount();
        }
        Long loaded = this.realmCache.getCache().getCurrentRevision(cacheKey);
        long count = this.getDelegate().count();
        cached = new CachedCount(loaded, this.getRealm(), cacheKey, count);
        this.realmCache.getCache().addRevisioned(cached, this.realmCache.getStartupRevision());
        return count;
    }

    public InvitationManager getInvitationManager() {
        return this.invitationManager;
    }

    public void close() {
        if (this.orgDelegate != null) {
            this.getDelegate().close();
        }
    }

    void registerOrganizationInvalidation(OrganizationModel organization) {
        OrganizationAdapter adapter;
        String id = organization.getId();
        if (this.realmCache != null) {
            this.realmCache.registerInvalidation(InfinispanIdentityProviderStorageProvider.cacheKeyOrgId(this.getRealm(), id));
            this.realmCache.registerInvalidation(id);
            organization.getDomains().map(OrganizationDomainModel::getName).map(this::cacheKeyByDomain).forEach(this.realmCache::registerInvalidation);
        }
        if ((adapter = this.managedOrganizations.get(id)) != null) {
            adapter.invalidate();
        }
    }

    private void registerCountInvalidation() {
        if (this.realmCache != null) {
            this.realmCache.registerInvalidation(InfinispanOrganizationProvider.cacheKeyOrgCount(this.getRealm()));
        }
    }

    private RealmModel getRealm() {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Session not bound to a realm");
        }
        return realm;
    }

    private Stream<OrganizationModel> getCacheDelegates(Stream<OrganizationModel> backendOrganizations) {
        return backendOrganizations.map(OrganizationModel::getId).map(this::getById);
    }

    private String cacheKeyByDomain(String domainName) {
        return this.getRealm().getId() + ".org.domain.name." + domainName;
    }

    private String cacheKeyByMember(UserModel user) {
        return this.getRealm().getId() + ".org.member." + user.getId() + ".orgs";
    }

    private String cacheKeyMembership(RealmModel realm, OrganizationModel organization, UserModel user) {
        return realm.getId() + ".org." + organization.getId() + ".member." + user.getId() + ".membership";
    }

    void registerMemberInvalidation(OrganizationModel organization, UserModel member) {
        if (this.userCache != null) {
            this.userCache.registerInvalidation(this.cacheKeyByMember(member));
            this.userCache.registerInvalidation(this.cacheKeyMembership(this.getRealm(), organization, member));
        }
        if (this.realmCache != null) {
            this.realmCache.registerInvalidation(InfinispanOrganizationProvider.cacheKeyOrgMemberCount(this.getRealm(), organization));
        }
    }

    private boolean isRealmCacheKeyInvalid(String cacheKey) {
        return this.realmCache.isInvalid(cacheKey);
    }

    private boolean isUserCacheKeyInvalid(String cacheKey) {
        return this.userCache.isInvalid(cacheKey);
    }
}

