/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.CodeSigner;
import java.time.Instant;
import java.util.List;
import java.util.function.Function;

public abstract class Resource {
    private final String path;

    protected Resource(String path) {
        this.path = ResourceUtils.canonicalizeRelativePath((String)Assert.checkNotNullParam((String)"path", (Object)path));
    }

    public final String pathName() {
        return this.path;
    }

    public abstract URL url();

    public abstract InputStream openStream() throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R readStream(Function<InputStream, R> function) throws IOException {
        try (InputStream is = this.openStream();){
            R r = function.apply(is);
            return r;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public DirectoryStream<Resource> openDirectoryStream() throws IOException {
        throw new IOException("Not a directory");
    }

    public boolean isDirectory() {
        return false;
    }

    public ByteBuffer asBuffer() throws IOException {
        try (InputStream is = this.openStream();){
            ByteBuffer byteBuffer = ByteBuffer.wrap(is.readAllBytes()).asReadOnlyBuffer();
            return byteBuffer;
        }
    }

    public long copyTo(Path destination) throws IOException {
        try (InputStream is = this.openStream();){
            long l = Files.copy(is, destination, StandardCopyOption.REPLACE_EXISTING);
            return l;
        }
    }

    public long copyTo(OutputStream destination) throws IOException {
        try (InputStream is = this.openStream();){
            long l = is.transferTo(destination);
            return l;
        }
    }

    public long copyTo(WritableByteChannel channel) throws IOException {
        SelectableChannel sc;
        if (channel instanceof SelectableChannel && !(sc = (SelectableChannel)((Object)channel)).isBlocking()) {
            throw new IllegalArgumentException("Channel must not be non-blocking");
        }
        ByteBuffer buf = this.asBuffer();
        long c = 0L;
        while (buf.hasRemaining()) {
            c += (long)channel.write(buf);
        }
        return c;
    }

    public String asString(Charset charset) throws IOException {
        return charset.newDecoder().decode(this.asBuffer()).toString();
    }

    public Instant modifiedTime() {
        return null;
    }

    public List<CodeSigner> codeSigners() {
        return List.of();
    }

    public abstract long size();
}

