/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.oid4vci.CredentialScopeModel;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;

public class CredentialBuildConfig {
    public static final String MULTIVALUED_STRING_SEPARATOR = ",";
    private static final String TOKEN_JWS_TYPE_KEY = "token_jws_type";
    private static final String HASH_ALGORITHM_KEY = "hash_algorithm";
    private static final String VISIBLE_CLAIMS_KEY = "visible_claims";
    private static final String NUMBER_OF_DECOYS_KEY = "decoys";
    private static final String SIGNING_KEY_ID_KEY = "signing_key_id";
    private static final String OVERRIDE_KEY_ID_KEY = "override_key_id";
    private static final String SIGNING_ALGORITHM_KEY = "signing_algorithm";
    private static final String LDP_PROOF_TYPE_KEY = "ldp_proof_type";
    private String credentialIssuer;
    private String credentialId;
    private String credentialType;
    private String tokenJwsType;
    private String hashAlgorithm;
    private List<String> sdJwtVisibleClaims;
    private Integer numberOfDecoys;
    private String signingKeyId;
    private String overrideKeyId;
    private String signingAlgorithm;
    private String ldpProofType;

    public static CredentialBuildConfig parse(KeycloakSession keycloakSession, SupportedCredentialConfiguration credentialConfiguration, CredentialScopeModel credentialModel) {
        String credentialIssuer = Optional.ofNullable(credentialModel.getIssuerDid()).orElse(OID4VCIssuerWellKnownProvider.getIssuer(keycloakSession.getContext()));
        return new CredentialBuildConfig().setCredentialIssuer(credentialIssuer).setCredentialId(credentialConfiguration.getId()).setCredentialType(credentialConfiguration.getVct()).setTokenJwsType(credentialModel.getTokenJwsType()).setNumberOfDecoys(credentialModel.getSdJwtNumberOfDecoys()).setSigningKeyId(credentialModel.getSigningKeyId()).setSigningAlgorithm(credentialConfiguration.getCredentialSigningAlgValuesSupported().get(0)).setHashAlgorithm(credentialModel.getHashAlgorithm()).setSdJwtVisibleClaims(credentialModel.getSdJwtVisibleClaims());
    }

    public String getCredentialIssuer() {
        return this.credentialIssuer;
    }

    public CredentialBuildConfig setCredentialIssuer(String credentialIssuer) {
        this.credentialIssuer = credentialIssuer;
        return this;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public CredentialBuildConfig setCredentialId(String credentialId) {
        this.credentialId = credentialId;
        return this;
    }

    public String getTokenJwsType() {
        return this.tokenJwsType;
    }

    public CredentialBuildConfig setTokenJwsType(String tokenJwsType) {
        this.tokenJwsType = tokenJwsType;
        return this;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public CredentialBuildConfig setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    public List<String> getSdJwtVisibleClaims() {
        return this.sdJwtVisibleClaims;
    }

    public CredentialBuildConfig setSdJwtVisibleClaims(List<String> sdJwtVisibleClaims) {
        this.sdJwtVisibleClaims = sdJwtVisibleClaims;
        return this;
    }

    public int getNumberOfDecoys() {
        return this.numberOfDecoys;
    }

    public CredentialBuildConfig setNumberOfDecoys(int numberOfDecoys) {
        this.numberOfDecoys = numberOfDecoys;
        return this;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public CredentialBuildConfig setCredentialType(String credentialType) {
        this.credentialType = credentialType;
        return this;
    }

    public String getSigningKeyId() {
        return this.signingKeyId;
    }

    public CredentialBuildConfig setSigningKeyId(String signingKeyId) {
        this.signingKeyId = signingKeyId;
        return this;
    }

    public String getOverrideKeyId() {
        return this.overrideKeyId;
    }

    public CredentialBuildConfig setOverrideKeyId(String overrideKeyId) {
        this.overrideKeyId = overrideKeyId;
        return this;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public CredentialBuildConfig setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    public String getLdpProofType() {
        return this.ldpProofType;
    }

    public CredentialBuildConfig setLdpProofType(String ldpProofType) {
        this.ldpProofType = ldpProofType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialBuildConfig that = (CredentialBuildConfig)o;
        return Objects.equals(this.credentialId, that.credentialId) && Objects.equals(this.credentialType, that.credentialType) && Objects.equals(this.tokenJwsType, that.tokenJwsType) && Objects.equals(this.hashAlgorithm, that.hashAlgorithm) && Objects.equals(this.sdJwtVisibleClaims, that.sdJwtVisibleClaims) && Objects.equals(this.numberOfDecoys, that.numberOfDecoys) && Objects.equals(this.signingKeyId, that.signingKeyId) && Objects.equals(this.overrideKeyId, that.overrideKeyId) && Objects.equals(this.signingAlgorithm, that.signingAlgorithm) && Objects.equals(this.ldpProofType, that.ldpProofType);
    }

    public int hashCode() {
        return Objects.hash(this.credentialId, this.credentialType, this.tokenJwsType, this.hashAlgorithm, this.sdJwtVisibleClaims, this.numberOfDecoys, this.signingKeyId, this.overrideKeyId, this.signingAlgorithm, this.ldpProofType);
    }
}

