/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Objects;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.NamedOperation;

public class Named
implements NamedOperation<Named> {
    private static final int MAX_NAME_LENGTH = 249;
    protected String name;

    protected Named(Named named) {
        this(Objects.requireNonNull(named, (String)"named cannot be null").name);
    }

    protected Named(String name) {
        this.name = name;
        if (name != null) {
            Named.validate(name);
        }
    }

    public static Named as(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return new Named(name);
    }

    @Override
    public Named withName(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return new Named(name);
    }

    protected static void validate(String name) {
        if (name.isEmpty()) {
            throw new TopologyException("Name is illegal, it can't be empty");
        }
        if (name.equals(".") || name.equals("..")) {
            throw new TopologyException("Name cannot be \".\" or \"..\"");
        }
        if (name.length() > 249) {
            throw new TopologyException("Name is illegal, it can't be longer than 249 characters, name: " + name);
        }
        if (!Named.containsValidPattern(name)) {
            throw new TopologyException("Name \"" + name + "\" is illegal, it contains a character other than ASCII alphanumerics, '.', '_' and '-'");
        }
    }

    private static boolean containsValidPattern(String topic) {
        for (int i = 0; i < topic.length(); ++i) {
            boolean validChar;
            char c = topic.charAt(i);
            boolean validLetterOrDigit = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z';
            boolean bl = validChar = validLetterOrDigit || c == '.' || c == '_' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

