/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import net.sf.juife.InformationDialog;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.MidiDeviceModel;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.SamplerChannelModel;
import org.jsampler.SamplerModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.MidiDeviceEvent;
import org.jsampler.event.MidiDeviceListEvent;
import org.jsampler.event.MidiDeviceListListener;
import org.jsampler.event.MidiDeviceListener;
import org.jsampler.event.SamplerAdapter;
import org.jsampler.event.SamplerChannelAdapter;
import org.jsampler.event.SamplerChannelEvent;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.event.SamplerEvent;
import org.jsampler.event.SamplerListener;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.ToolbarButton;
import org.jsampler.view.std.JSChannelOutputRoutingDlg;
import org.jsampler.view.std.JSFxSendsPane;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiPort;
import org.linuxsampler.lscp.SamplerChannel;
import org.linuxsampler.lscp.SamplerEngine;

class ChannelProperties
extends JPanel {
    private final JLabel lMidiDevice = new JLabel(ClassicI18n.i18n.getLabel("ChannelProperties.lMidiDevice"));
    private final JLabel lMidiPort = new JLabel(ClassicI18n.i18n.getLabel("ChannelProperties.lMidiPort"));
    private final JLabel lMidiChannel = new JLabel(ClassicI18n.i18n.getLabel("ChannelProperties.lMidiChannel"));
    private final JLabel lInstrumentMap = new JLabel(ClassicI18n.i18n.getLabel("ChannelProperties.lInstrumentMap"));
    private final JLabel lAudioDevice = new JLabel(ClassicI18n.i18n.getLabel("ChannelProperties.lAudioDevice"));
    private final JComboBox cbEngines = new JComboBox();
    private final JComboBox cbInstrumentMap = new JComboBox();
    private final JComboBox cbMidiDevice = new JComboBox();
    private final JComboBox cbMidiPort = new JComboBox();
    private final JComboBox cbMidiChannel = new JComboBox();
    private final JComboBox cbAudioDevice = new JComboBox();
    private final JButton btnFxSends = new JButton(Res.iconFxSends22);
    private final JButton btnAudioProps = new JButton(Res.iconAudioProps16);
    private InformationDialog fxSendsDlg = null;
    private SamplerChannelModel channelModel = null;
    private MidiDeviceModel midiDevice = null;
    private boolean update = false;
    private final SamplerListener samplerListener;
    private final MapListListener mapListListener = new MapListListener();
    private NoMap noMap = new NoMap();
    private DefaultMap defaultMap = new DefaultMap();
    private final Handler handler = new Handler();

    ChannelProperties(SamplerChannelModel samplerChannelModel) {
        this.channelModel = samplerChannelModel;
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.add(new JSeparator());
        JPanel jPanel = this.createEnginePane();
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(3, 0)));
        jPanel2.add(this.createMidiPane());
        jPanel2.add(Box.createRigidArea(new Dimension(3, 0)));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createRigidArea(new Dimension(3, 0)));
        JPanel jPanel3 = this.createAudioPane();
        Dimension dimension = jPanel3.getPreferredSize();
        dimension.height = Short.MAX_VALUE;
        jPanel3.setMaximumSize(dimension);
        jPanel2.add(jPanel3);
        this.add(jPanel2);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(new JSeparator());
        this.cbMidiChannel.addItem("All");
        for (int i = 1; i <= 16; ++i) {
            this.cbMidiChannel.addItem(String.valueOf(i));
        }
        this.cbMidiDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelProperties.this.setMidiDevice();
            }
        });
        this.cbMidiPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelProperties.this.setMidiPort();
            }
        });
        this.cbMidiChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelProperties.this.setMidiChannel();
            }
        });
        this.cbEngines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelProperties.this.setEngineType();
            }
        });
        this.cbAudioDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelProperties.this.setAudioDevice();
            }
        });
        this.getModel().addSamplerChannelListener(new SamplerChannelAdapter(){

            @Override
            public void channelChanged(SamplerChannelEvent samplerChannelEvent) {
                ChannelProperties.this.updateChannelProperties();
            }
        });
        this.samplerListener = new SamplerAdapter(){

            @Override
            public void defaultMapChanged(SamplerEvent samplerEvent) {
                ChannelProperties.this.updateCbInstrumentMapToolTipText();
            }
        };
        CC.getSamplerModel().addSamplerListener(this.samplerListener);
        this.cbInstrumentMap.addItem(this.noMap);
        this.cbInstrumentMap.addItem(this.defaultMap);
        for (MidiInstrumentMap midiInstrumentMap : CC.getSamplerModel().getMidiInstrumentMaps()) {
            this.cbInstrumentMap.addItem(midiInstrumentMap);
        }
        int n = this.getModel().getChannelInfo().getMidiInstrumentMapId();
        this.cbInstrumentMap.setSelectedItem(CC.getSamplerModel().getMidiInstrumentMapById(n));
        if (this.cbInstrumentMap.getSelectedItem() == null) {
            if (n == -1) {
                this.cbInstrumentMap.setSelectedItem(this.noMap);
            } else if (n == -2) {
                this.cbInstrumentMap.setSelectedItem(this.defaultMap);
            }
        }
        this.updateCbInstrumentMapToolTipText();
        if (this.getModel().getChannelInfo().getEngine() == null) {
            this.cbInstrumentMap.setEnabled(false);
        }
        this.cbInstrumentMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelProperties.this.updateInstrumentMap();
            }
        });
        CC.getSamplerModel().addMidiDeviceListListener(this.getHandler());
        CC.getSamplerModel().addAudioDeviceListListener(this.getHandler());
        CC.getSamplerModel().addSamplerChannelListListener(this.getHandler());
        CC.getSamplerModel().addMidiInstrumentMapListListener(this.mapListListener);
        this.btnAudioProps.setToolTipText(ClassicI18n.i18n.getLabel("ChannelProperties.routing"));
        this.btnAudioProps.setEnabled(false);
        this.btnAudioProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SamplerChannel samplerChannel = ChannelProperties.this.getModel().getChannelInfo();
                new JSChannelOutputRoutingDlg((Frame)CC.getMainFrame(), samplerChannel).setVisible(true);
            }
        });
        this.btnFxSends.setToolTipText(ClassicI18n.i18n.getButtonLabel("ChannelProperties.btnFxSends"));
        this.btnFxSends.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChannelProperties.this.fxSendsDlg != null && ChannelProperties.this.fxSendsDlg.isVisible()) {
                    ChannelProperties.this.fxSendsDlg.toFront();
                    return;
                }
                FxSendsPane fxSendsPane = new FxSendsPane(ChannelProperties.this.getModel());
                int n = ChannelProperties.this.getModel().getChannelId();
                ChannelProperties.this.fxSendsDlg = new InformationDialog((Frame)CC.getMainFrame(), (Container)fxSendsPane);
                ChannelProperties.this.fxSendsDlg.setTitle(ClassicI18n.i18n.getLabel("FxSendsDlg.title", n));
                ChannelProperties.this.fxSendsDlg.setModal(false);
                ChannelProperties.this.fxSendsDlg.showCloseButton(false);
                ChannelProperties.this.fxSendsDlg.setVisible(true);
            }
        });
        this.updateMidiDevices();
        this.updateAudioDevices();
        this.updateChannelProperties();
    }

    private JPanel createEnginePane() {
        for (SamplerEngine object2 : CC.getSamplerModel().getEngines()) {
            this.cbEngines.addItem(object2);
        }
        this.cbEngines.setMaximumSize(this.cbEngines.getPreferredSize());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.cbEngines);
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "South");
        String string = ClassicI18n.i18n.getLabel("ChannelProperties.enginesPane");
        jPanel2.setBorder(BorderFactory.createTitledBorder(string));
        Dimension dimension = new Dimension(jPanel2.getPreferredSize().width, Short.MAX_VALUE);
        jPanel2.setMaximumSize(dimension);
        return jPanel2;
    }

    private JPanel createMidiPane() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagLayout.setConstraints(this.lMidiDevice, gridBagConstraints);
        jPanel.add(this.lMidiDevice);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.lMidiPort, gridBagConstraints);
        jPanel.add(this.lMidiPort);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.lMidiChannel, gridBagConstraints);
        jPanel.add(this.lMidiChannel);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 3, 3);
        gridBagLayout.setConstraints(this.lInstrumentMap, gridBagConstraints);
        jPanel.add(this.lInstrumentMap);
        this.btnFxSends.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 8);
        gridBagLayout.setConstraints(this.btnFxSends, gridBagConstraints);
        jPanel.add(this.btnFxSends);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 4, 4, 3);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.cbMidiDevice, gridBagConstraints);
        jPanel.add(this.cbMidiDevice);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.cbMidiChannel, gridBagConstraints);
        jPanel.add(this.cbMidiChannel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.cbMidiPort, gridBagConstraints);
        jPanel.add(this.cbMidiPort);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 3, 3);
        gridBagLayout.setConstraints(this.cbInstrumentMap, gridBagConstraints);
        jPanel.add(this.cbInstrumentMap);
        String string = ClassicI18n.i18n.getLabel("ChannelProperties.midiPane");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private JPanel createAudioPane() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagLayout.setConstraints(this.lAudioDevice, gridBagConstraints);
        jPanel.add(this.lAudioDevice);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.cbAudioDevice, gridBagConstraints);
        jPanel.add(this.cbAudioDevice);
        this.btnAudioProps.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.btnAudioProps, gridBagConstraints);
        jPanel.add(this.btnAudioProps);
        String string = ClassicI18n.i18n.getLabel("ChannelProperties.audioPane");
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        return jPanel;
    }

    public SamplerChannelModel getModel() {
        return this.channelModel;
    }

    private void updateInstrumentMap() {
        this.updateCbInstrumentMapToolTipText();
        int n = this.getModel().getChannelInfo().getMidiInstrumentMapId();
        Object object = this.cbInstrumentMap.getSelectedItem();
        if (object == null && n == -1) {
            return;
        }
        int n2 = object == null || object == this.noMap ? -1 : (object == this.defaultMap ? -2 : ((MidiInstrumentMap)object).getMapId());
        if (n2 == n) {
            return;
        }
        this.channelModel.setBackendMidiInstrumentMap(n2);
    }

    private void updateCbInstrumentMapToolTipText() {
        if (this.cbInstrumentMap.getSelectedItem() != this.defaultMap) {
            this.cbInstrumentMap.setToolTipText(null);
            return;
        }
        MidiInstrumentMap midiInstrumentMap = CC.getSamplerModel().getDefaultMidiInstrumentMap();
        if (midiInstrumentMap != null) {
            String string = ClassicI18n.i18n.getLabel("Channel.ttDefault", midiInstrumentMap.getName());
            this.cbInstrumentMap.setToolTipText(string);
        } else {
            this.cbInstrumentMap.setToolTipText(null);
        }
    }

    private void updateChannelProperties() {
        SamplerModel samplerModel = CC.getSamplerModel();
        SamplerChannel samplerChannel = this.getModel().getChannelInfo();
        MidiDeviceModel midiDeviceModel = samplerModel.getMidiDeviceById(samplerChannel.getMidiInputDevice());
        AudioDeviceModel audioDeviceModel = samplerModel.getAudioDeviceById(samplerChannel.getAudioOutputDevice());
        if (this.isUpdate()) {
            CC.getLogger().warning("Unexpected update state!");
        }
        this.setUpdate(true);
        try {
            this.cbMidiDevice.setSelectedItem(midiDeviceModel == null ? null : midiDeviceModel.getDeviceInfo());
            this.cbEngines.setSelectedItem(samplerChannel.getEngine());
            this.cbAudioDevice.setSelectedItem(audioDeviceModel == null ? null : audioDeviceModel.getDeviceInfo());
            this.btnAudioProps.setEnabled(audioDeviceModel != null);
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.WARNING, "Unkown error", exception);
        }
        if (samplerChannel.getEngine() != null) {
            this.cbInstrumentMap.setEnabled(true);
            int n = samplerChannel.getMidiInstrumentMapId();
            Object object = n == -2 ? this.defaultMap : (n == -1 ? this.noMap : CC.getSamplerModel().getMidiInstrumentMapById(n));
            if (this.cbInstrumentMap.getSelectedItem() != object) {
                this.cbInstrumentMap.setSelectedItem(object);
            }
        } else {
            this.cbInstrumentMap.setSelectedItem(this.noMap);
            this.cbInstrumentMap.setEnabled(false);
        }
        this.setUpdate(false);
    }

    private void updateMidiDevices() {
        SamplerModel samplerModel = CC.getSamplerModel();
        SamplerChannel samplerChannel = this.getModel().getChannelInfo();
        this.setUpdate(true);
        try {
            this.cbMidiDevice.removeAllItems();
            for (MidiDeviceModel midiDeviceModel : samplerModel.getMidiDevices()) {
                this.cbMidiDevice.addItem(midiDeviceModel.getDeviceInfo());
            }
            MidiDeviceModel midiDeviceModel = samplerModel.getMidiDeviceById(samplerChannel.getMidiInputDevice());
            this.cbMidiDevice.setSelectedItem(midiDeviceModel == null ? null : midiDeviceModel.getDeviceInfo());
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.WARNING, "Unkown error", exception);
        }
        this.setUpdate(false);
    }

    private void updateAudioDevices() {
        SamplerModel samplerModel = CC.getSamplerModel();
        SamplerChannel samplerChannel = this.getModel().getChannelInfo();
        this.setUpdate(true);
        try {
            this.cbAudioDevice.removeAllItems();
            for (AudioDeviceModel audioDeviceModel : samplerModel.getAudioDevices()) {
                this.cbAudioDevice.addItem(audioDeviceModel.getDeviceInfo());
            }
            AudioDeviceModel audioDeviceModel = samplerModel.getAudioDeviceById(samplerChannel.getAudioOutputDevice());
            this.cbAudioDevice.setSelectedItem(audioDeviceModel == null ? null : audioDeviceModel.getDeviceInfo());
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.WARNING, "Unkown error", exception);
        }
        this.setUpdate(false);
    }

    private void setMidiDevice() {
        MidiInputDevice midiInputDevice = (MidiInputDevice)this.cbMidiDevice.getSelectedItem();
        if (!this.isUpdate()) {
            if (midiInputDevice != null) {
                this.getModel().setBackendMidiInputDevice(midiInputDevice.getDeviceId());
            }
            return;
        }
        if (this.midiDevice != null) {
            this.midiDevice.removeMidiDeviceListener(this.getHandler());
        }
        this.cbMidiPort.removeAllItems();
        if (midiInputDevice == null) {
            this.midiDevice = null;
            this.cbMidiPort.setEnabled(false);
            this.cbMidiChannel.setSelectedItem(null);
            this.cbMidiChannel.setEnabled(false);
        } else {
            MidiPort[] midiPortArray;
            this.midiDevice = CC.getSamplerModel().getMidiDeviceById(midiInputDevice.getDeviceId());
            if (this.midiDevice != null) {
                this.midiDevice.addMidiDeviceListener(this.getHandler());
            }
            this.cbMidiPort.setEnabled(true);
            for (MidiPort midiPort : midiPortArray = midiInputDevice.getMidiPorts()) {
                this.cbMidiPort.addItem(midiPort);
            }
            int n = this.getModel().getChannelInfo().getMidiInputPort();
            this.cbMidiPort.setSelectedItem(n >= 0 && n < midiPortArray.length ? midiPortArray[n] : null);
            this.cbMidiChannel.setEnabled(true);
            int n2 = this.getModel().getChannelInfo().getMidiInputChannel();
            this.cbMidiChannel.setSelectedItem(n2 == -1 ? "All" : String.valueOf(n2 + 1));
        }
    }

    private void setMidiPort() {
        if (this.isUpdate()) {
            return;
        }
        this.getModel().setBackendMidiInputPort(this.cbMidiPort.getSelectedIndex());
    }

    private void setMidiChannel() {
        if (this.isUpdate()) {
            return;
        }
        Object object = this.cbMidiChannel.getSelectedItem();
        if (object == null) {
            return;
        }
        int n = object.toString().equals("All") ? -1 : Integer.parseInt(object.toString()) - 1;
        this.getModel().setBackendMidiInputChannel(n);
    }

    private void setEngineType() {
        SamplerEngine samplerEngine = this.getModel().getChannelInfo().getEngine();
        SamplerEngine samplerEngine2 = (SamplerEngine)this.cbEngines.getSelectedItem();
        if (samplerEngine2 == null) {
            this.cbEngines.setToolTipText(null);
        } else {
            this.cbEngines.setToolTipText(samplerEngine2.getDescription());
        }
        if (samplerEngine != null ? ((Object)samplerEngine).equals(samplerEngine2) : samplerEngine2 == null) {
            return;
        }
        this.getModel().setBackendEngineType(samplerEngine2.getName());
    }

    private void setAudioDevice() {
        if (this.isUpdate()) {
            return;
        }
        AudioOutputDevice audioOutputDevice = (AudioOutputDevice)this.cbAudioDevice.getSelectedItem();
        if (audioOutputDevice != null) {
            this.getModel().setBackendAudioOutputDevice(audioOutputDevice.getDeviceId());
        }
    }

    private boolean isUpdate() {
        return this.update;
    }

    private void setUpdate(boolean bl) {
        this.update = bl;
    }

    protected void onDestroy() {
        SamplerModel samplerModel = CC.getSamplerModel();
        samplerModel.removeMidiDeviceListListener(this.getHandler());
        samplerModel.removeAudioDeviceListListener(this.getHandler());
        samplerModel.removeMidiInstrumentMapListListener(this.mapListListener);
        samplerModel.removeSamplerListener(this.samplerListener);
        samplerModel.removeSamplerChannelListListener(this.getHandler());
        if (this.midiDevice != null) {
            this.midiDevice.removeMidiDeviceListener(this.getHandler());
        }
        if (this.fxSendsDlg != null) {
            this.fxSendsDlg.dispose();
        }
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class MapListListener
    implements ListListener<MidiInstrumentMap> {
        private MapListListener() {
        }

        @Override
        public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
            boolean bl;
            ChannelProperties.this.cbInstrumentMap.insertItemAt(listEvent.getEntry(), ChannelProperties.this.cbInstrumentMap.getItemCount());
            boolean bl2 = bl = ChannelProperties.this.getModel().getChannelInfo().getEngine() != null;
            if (bl && !ChannelProperties.this.cbInstrumentMap.isEnabled()) {
                ChannelProperties.this.cbInstrumentMap.setEnabled(true);
            }
        }

        @Override
        public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
            ChannelProperties.this.cbInstrumentMap.removeItem(listEvent.getEntry());
            if (ChannelProperties.this.cbInstrumentMap.getItemCount() == 0) {
                ChannelProperties.this.cbInstrumentMap.setSelectedItem(ChannelProperties.this.noMap);
                ChannelProperties.this.cbInstrumentMap.setEnabled(false);
            }
        }
    }

    private class Handler
    implements MidiDeviceListListener,
    ListListener<AudioDeviceModel>,
    SamplerChannelListListener,
    MidiDeviceListener {
        private Handler() {
        }

        @Override
        public void deviceAdded(MidiDeviceListEvent midiDeviceListEvent) {
            ChannelProperties.this.cbMidiDevice.addItem(midiDeviceListEvent.getMidiDeviceModel().getDeviceInfo());
        }

        @Override
        public void deviceRemoved(MidiDeviceListEvent midiDeviceListEvent) {
            ChannelProperties.this.cbMidiDevice.removeItem(midiDeviceListEvent.getMidiDeviceModel().getDeviceInfo());
        }

        @Override
        public void entryAdded(ListEvent<AudioDeviceModel> listEvent) {
            ChannelProperties.this.cbAudioDevice.addItem(listEvent.getEntry().getDeviceInfo());
        }

        @Override
        public void entryRemoved(ListEvent<AudioDeviceModel> listEvent) {
            ChannelProperties.this.cbAudioDevice.removeItem(listEvent.getEntry().getDeviceInfo());
        }

        @Override
        public void channelAdded(SamplerChannelListEvent samplerChannelListEvent) {
        }

        @Override
        public void channelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
            if (samplerChannelListEvent.getChannelModel().getChannelId() == ChannelProperties.this.channelModel.getChannelId()) {
                ChannelProperties.this.onDestroy();
            }
        }

        @Override
        public void settingsChanged(MidiDeviceEvent midiDeviceEvent) {
            if (ChannelProperties.this.isUpdate()) {
                CC.getLogger().warning("Invalid update state");
                return;
            }
            ChannelProperties.this.setUpdate(true);
            int n = ChannelProperties.this.cbMidiPort.getSelectedIndex();
            MidiInputDevice midiInputDevice = midiDeviceEvent.getMidiDeviceModel().getDeviceInfo();
            ChannelProperties.this.cbMidiPort.removeAllItems();
            for (MidiPort midiPort : midiInputDevice.getMidiPorts()) {
                ChannelProperties.this.cbMidiPort.addItem(midiPort);
            }
            if (n >= ChannelProperties.this.cbMidiPort.getModel().getSize()) {
                n = 0;
            }
            ChannelProperties.this.setUpdate(false);
            if (ChannelProperties.this.cbMidiPort.getModel().getSize() > 0) {
                ChannelProperties.this.cbMidiPort.setSelectedIndex(n);
            }
        }
    }

    class FxSendsPane
    extends JSFxSendsPane {
        FxSendsPane(SamplerChannelModel samplerChannelModel) {
            super(samplerChannelModel);
            this.actionAddFxSend.putValue("SmallIcon", Res.iconNew16);
            this.actionRemoveFxSend.putValue("SmallIcon", Res.iconDelete16);
        }

        @Override
        protected JToolBar createToolBar() {
            JToolBar jToolBar = new JToolBar();
            Dimension dimension = new Dimension(Short.MAX_VALUE, jToolBar.getPreferredSize().height);
            jToolBar.setMaximumSize(dimension);
            jToolBar.setFloatable(false);
            jToolBar.setAlignmentX(1.0f);
            jToolBar.add(new ToolbarButton(this.actionAddFxSend));
            jToolBar.add(new ToolbarButton(this.actionRemoveFxSend));
            return jToolBar;
        }
    }

    private class DefaultMap {
        private DefaultMap() {
        }

        public String toString() {
            return "[Default]";
        }
    }

    private class NoMap {
        private NoMap() {
        }

        public String toString() {
            return "[None]";
        }
    }
}

