/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import java.lang.reflect.Type;
import java.util.List;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.generator.ClassGenerator;
import org.gradle.internal.instantiation.generator.ConstructorSelector;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;

class ParamsMatchingConstructorSelector
implements ConstructorSelector {
    private final ClassGenerator classGenerator;

    public ParamsMatchingConstructorSelector(ClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    @Override
    public void vetoParameters(ClassGenerator.GeneratedConstructor<?> constructor, Object[] parameters) {
    }

    @Override
    public <T> ClassGenerator.GeneratedConstructor<? extends T> forType(Class<T> type) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This constructor selector requires the construction parameters");
    }

    @Override
    public <T> ClassGenerator.GeneratedConstructor<? extends T> forParams(Class<T> type, Object[] params) {
        ClassGenerator.GeneratedClass<T> generatedClass = this.classGenerator.generate(type);
        if (!(generatedClass.getOuterType() == null || params.length != 0 && generatedClass.getOuterType().isInstance(params[0]))) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(type);
            formatter.append((CharSequence)" is a non-static inner class.");
            throw new IllegalArgumentException(formatter.toString());
        }
        List<ClassGenerator.GeneratedConstructor<T>> constructors = generatedClass.getConstructors();
        if (constructors.size() == 1) {
            return (ClassGenerator.GeneratedConstructor)Cast.uncheckedCast(constructors.get(0));
        }
        ClassGenerator.GeneratedConstructor<T> match = null;
        for (ClassGenerator.GeneratedConstructor<T> constructor : constructors) {
            int fromParam;
            Type[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length < params.length) continue;
            int toParam = 0;
            for (fromParam = 0; fromParam < params.length; ++fromParam) {
                Object param = params[fromParam];
                while (param != null && toParam < parameterTypes.length) {
                    Class toType = parameterTypes[toParam];
                    if (toType.isPrimitive()) {
                        toType = AsmClassGeneratorUtils.getWrapperTypeForPrimitiveType(toType);
                    }
                    if (toType.isInstance(param)) break;
                    ++toParam;
                }
                if (toParam == parameterTypes.length) break;
                ++toParam;
            }
            if (fromParam != params.length) continue;
            if (match == null) {
                match = constructor;
                continue;
            }
            if (parameterTypes.length < match.getParameterTypes().length) {
                match = constructor;
                continue;
            }
            if (parameterTypes.length != match.getParameterTypes().length) continue;
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Multiple constructors for parameters ");
            formatter.appendValues(params);
            formatter.startNumberedChildren();
            formatter.node("candidate: ");
            formatter.appendType(type);
            formatter.appendTypes(parameterTypes);
            formatter.node("best match: ");
            formatter.appendType(type);
            formatter.appendTypes((Type[])match.getParameterTypes());
            formatter.endChildren();
            throw new IllegalArgumentException(formatter.toString());
        }
        if (match != null) {
            return (ClassGenerator.GeneratedConstructor)Cast.uncheckedCast(match);
        }
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("No constructors of type ");
        formatter.appendType(type);
        formatter.append((CharSequence)" match parameters: ");
        formatter.appendValues(params);
        throw new IllegalArgumentException(formatter.toString());
    }
}

