/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.DOMException;

public abstract class ColorValue
extends TypedValue
implements CSSColorValue {
    private static final long serialVersionUID = 1L;
    static final NumberValue opaqueAlpha;
    private boolean systemDefault = false;
    boolean commaSyntax = true;

    ColorValue() {
        super(CSSValue.Type.COLOR);
    }

    ColorValue(CSSValue.Type unitType) {
        super(unitType);
    }

    ColorValue(ColorValue copied) {
        super(copied);
        this.systemDefault = copied.systemDefault;
        this.commaSyntax = copied.commaSyntax;
    }

    public void setSystemDefault() {
        this.systemDefault = true;
    }

    @Override
    public boolean isSystemDefault() {
        return this.systemDefault;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory factory = new ValueFactory();
        StyleValue value = factory.parseProperty(cssText);
        if (value.getCssValueType() == CSSValue.CssType.TYPED) {
            CSSValue.Type ptype = value.getPrimitiveType();
            if (ptype == CSSValue.Type.IDENT) {
                String ident = ((CSSTypedValue)((Object)value)).getStringValue().toLowerCase(Locale.ROOT);
                String colorspec = ColorIdentifiers.getInstance().getColor(ident);
                if (colorspec != null) {
                    value = factory.parseProperty(colorspec);
                } else if ("transparent".equals(ident)) {
                    value = factory.parseProperty("#0000");
                } else {
                    this.failSetCssText();
                }
                ptype = value.getPrimitiveType();
            }
            if (ptype != CSSValue.Type.COLOR || ((ColorValue)value).getColorModel() != this.getColorModel() || !((ColorValue)value).getColor().getColorSpace().equals(this.getColor().getColorSpace()) || this.getClass() != value.getClass()) {
                this.failSetCssText();
            }
            this.set(value);
        } else {
            this.failSetCssText();
        }
    }

    private void failSetCssText() {
        throw new DOMException(13, "This value can only be set to a color in the original color space and the " + (Object)((Object)this.getColorModel()) + " color model, using the same syntax.");
    }

    void set(StyleValue value) {
        ColorValue setfrom = (ColorValue)value;
        this.systemDefault = setfrom.systemDefault;
        this.commaSyntax = setfrom.commaSyntax;
    }

    @Override
    public String getCssText() {
        return this.getColor().toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return this.getColor().toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.getColor().toString());
    }

    @Override
    public float deltaE2000(CSSColorValue color) {
        LABColor lab1;
        LABColor lab2;
        if (!this.hasConvertibleComponents() || !((ColorValue)color).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (color.getColorModel()) {
            case LCH: 
            case LAB: 
            case XYZ: {
                return color.deltaE2000(this);
            }
            case RGB: {
                RGBColor rgbcolor = (RGBColor)color.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rgbcolor.toLABColor(labColor);
                lab2 = labColor;
                RGBAColor color1 = this.toRGBColor(false);
                RGBColorValue rgb1 = new RGBColorValue();
                rgb1.setComponent(0, (StyleValue)((Object)color1.getAlpha()));
                rgb1.setComponent(1, (StyleValue)((Object)color1.getRed()));
                rgb1.setComponent(2, (StyleValue)((Object)color1.getGreen()));
                rgb1.setComponent(3, (StyleValue)((Object)color1.getBlue()));
                lab1 = rgb1.toLABColorValue().getColor();
                break;
            }
            default: {
                RGBAColor color1 = this.toRGBColor(false);
                RGBAColor color2 = color.toRGBColor(false);
                RGBColorValue rgb1 = new RGBColorValue();
                RGBColorValue rgb2 = new RGBColorValue();
                rgb1.setComponent(0, (StyleValue)((Object)color1.getAlpha()));
                rgb1.setComponent(1, (StyleValue)((Object)color1.getRed()));
                rgb1.setComponent(2, (StyleValue)((Object)color1.getGreen()));
                rgb1.setComponent(3, (StyleValue)((Object)color1.getBlue()));
                rgb2.setComponent(0, (StyleValue)((Object)color2.getAlpha()));
                rgb2.setComponent(1, (StyleValue)((Object)color2.getRed()));
                rgb2.setComponent(2, (StyleValue)((Object)color2.getGreen()));
                rgb2.setComponent(3, (StyleValue)((Object)color2.getBlue()));
                lab1 = rgb1.toLABColorValue().getColor();
                lab2 = rgb2.toLABColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)lab1.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab1.getA()).getFloatValue((short)0), ((CSSTypedValue)lab1.getB()).getFloatValue((short)0), ((CSSTypedValue)lab2.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab2.getA()).getFloatValue((short)0), ((CSSTypedValue)lab2.getB()).getFloatValue((short)0));
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        return syntax.getCategory() == CSSValueSyntax.Category.color ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    @Override
    public void setComponent(int index, StyleValue component) {
    }

    @Override
    public abstract PrimitiveValue getComponent(int var1);

    @Override
    public int getComponentCount() {
        return this.getColor().getLength();
    }

    abstract boolean hasConvertibleComponents();

    @Override
    public abstract ColorValue clone();

    public HSLColorValue toHSLColorValue() throws DOMException {
        RGBColor rgb = (RGBColor)this.toRGBColor(false);
        HSLColorValue hsl = new HSLColorValue();
        rgb.toHSLColor(hsl.getHSLColorImpl());
        return hsl;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        RGBColor rgb = (RGBColor)this.toRGBColor(false);
        LABColorValue lab = new LABColorValue();
        rgb.toLABColor(lab.getLABColorImpl());
        return lab;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        return this.toLABColorValue().toLCHColorValue();
    }

    TypedValue absoluteComponent(CSSColor from, CSSPrimitiveValue primi, boolean range) {
        switch (primi.getPrimitiveType()) {
            case IDENT: {
                String s = ((CSSTypedValue)primi).getStringValue();
                s = s.toLowerCase(Locale.ROOT);
                if ("none".equals(s)) break;
                CSSNumberValue comp = from.component(s);
                if (comp != null) {
                    if (range) {
                        comp = this.parameterRange(comp);
                    }
                    return (TypedValue)((Object)comp);
                }
                throw new DOMException(17, "Invalid color component: " + primi.getCssText());
            }
            case EXPRESSION: {
                Evaluator eval = this.createEvaluator(from, range);
                CSSNumberValue number = eval.evaluateExpression((CSSExpressionValue)primi);
                number.setMaximumFractionDigits(5);
                primi = number;
                break;
            }
            case MATH_FUNCTION: {
                Evaluator eval = this.createEvaluator(from, range);
                CSSNumberValue number = eval.evaluateFunction((CSSMathFunctionValue)primi);
                number.setMaximumFractionDigits(5);
                primi = number;
                break;
            }
            default: {
                if (primi.getCssValueType() == CSSValue.CssType.TYPED) break;
                if (primi.getCssValueType() == CSSValue.CssType.PROXY && primi.getPrimitiveType() != CSSValue.Type.ENV) {
                    throw new CSSLexicalProcessingException();
                }
                throw ColorValue.invalidValueException(primi);
            }
        }
        return (TypedValue)primi;
    }

    CSSNumberValue parameterRange(CSSNumberValue comp) {
        return comp;
    }

    private Evaluator createEvaluator(final CSSColor from, final boolean pcnt) {
        return new PercentageEvaluator(){

            @Override
            protected CSSTypedValue replaceParameter(String identifier) throws DOMException {
                CSSNumberValue number = from.component(identifier = identifier.toLowerCase(Locale.ROOT));
                if (number == null) {
                    return super.replaceParameter(identifier);
                }
                if (pcnt) {
                    number = ColorValue.this.parameterRange(number);
                }
                return number;
            }
        };
    }

    static PrimitiveValue absoluteHue(CSSColor from, CSSPrimitiveValue primi) {
        switch (primi.getPrimitiveType()) {
            case IDENT: {
                String s = ((CSSTypedValue)primi).getStringValue();
                s = s.toLowerCase(Locale.ROOT);
                if ("none".equals(s)) break;
                CSSNumberValue comp = from.component(s);
                if (comp != null) {
                    return (PrimitiveValue)((Object)comp);
                }
                throw new DOMException(17, "Invalid color component: " + primi.getCssText());
            }
            case EXPRESSION: {
                Evaluator eval = ColorValue.createHueEvaluator(from);
                primi = eval.evaluateExpression((CSSExpressionValue)primi);
                break;
            }
            case MATH_FUNCTION: {
                Evaluator eval = ColorValue.createHueEvaluator(from);
                primi = eval.evaluateFunction((CSSMathFunctionValue)primi);
                break;
            }
        }
        return (PrimitiveValue)primi;
    }

    private static Evaluator createHueEvaluator(final CSSColor from) {
        return new Evaluator(80){

            @Override
            protected CSSTypedValue replaceParameter(String identifier) throws DOMException {
                CSSNumberValue number = from.component(identifier = identifier.toLowerCase(Locale.ROOT));
                if (number == null) {
                    return super.replaceParameter(identifier);
                }
                return number;
            }
        };
    }

    static CSSColor computeColor(PrimitiveValue rawcolor, ValueFactory factory) throws DOMException {
        if (rawcolor instanceof CSSColorValue) {
            return ((CSSColorValue)((Object)rawcolor)).getColor();
        }
        if (rawcolor.getCssValueType() == CSSValue.CssType.TYPED) {
            TypedValue typed = (TypedValue)rawcolor;
            if (rawcolor.getPrimitiveType() == CSSValue.Type.IDENT) {
                String s = typed.getStringValue();
                s = ColorIdentifiers.getInstance().getColor(s);
                if (s != null) {
                    try {
                        typed = (TypedValue)factory.parseProperty(s);
                        return ((CSSColorValue)((Object)typed)).getColor();
                    }
                    catch (DOMException dOMException) {
                        // empty catch block
                    }
                }
            }
        }
        throw ColorValue.invalidValueException(rawcolor);
    }

    static LexicalUnit nextLexicalUnit(LexicalUnit lu, LexicalUnit firstUnit) throws DOMException {
        if ((lu = lu.getNextLexicalUnit()) == null) {
            throw ColorValue.invalidValueException(firstUnit);
        }
        return lu;
    }

    private static DOMException invalidValueException(CSSValue value) {
        return ColorValue.invalidValueException(value.getCssText());
    }

    static DOMException invalidValueException(LexicalUnit lunit) {
        return ColorValue.invalidValueException(lunit.toString());
    }

    private static DOMException invalidValueException(String value) {
        return new DOMSyntaxException("Invalid value: " + value);
    }

    static {
        NumberValue alpha = new NumberValue();
        alpha.setFloatValue((short)0, 1.0f);
        opaqueAlpha = alpha.immutable();
    }

    class MyHSLColorImpl
    extends HSLColorImpl {
        private static final long serialVersionUID = 1L;

        MyHSLColorImpl() {
        }

        @Override
        public String toString() {
            return this.toString(ColorValue.this.commaSyntax);
        }
    }

    class CSSRGBColor
    extends RGBColor {
        private static final long serialVersionUID = 2L;

        CSSRGBColor() {
        }

        CSSRGBColor(CSSRGBColor copyMe) {
            super(copyMe);
        }

        @Override
        boolean isCommaSyntax() {
            return ColorValue.this.commaSyntax;
        }

        @Override
        HSLColorImpl createHSLColor() {
            return new MyHSLColorImpl();
        }

        @Override
        public CSSRGBColor clone() {
            return new CSSRGBColor(this);
        }
    }
}

