/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import io.github.gitbucket.markedj.Marked;
import io.github.gitbucket.markedj.Options;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;

class ChatMessageRenderer {
    private final Options markdownOptions = this.createMarkdownOptions();

    ChatMessageRenderer() {
    }

    String renderMessage(String text, boolean renderMarkdown) {
        if (renderMarkdown) {
            return this.renderMarkdownMessage(text);
        }
        return this.formatPlainText(text);
    }

    private Options createMarkdownOptions() {
        Options options = new Options();
        options.setSafelist(null);
        return options;
    }

    private String renderMarkdownMessage(String text) {
        try {
            String renderedMarkup = Marked.marked((String)text, (Options)this.markdownOptions);
            if (renderedMarkup == null) {
                return this.formatPlainText(text);
            }
            return renderedMarkup;
        }
        catch (RuntimeException exception) {
            LogUtils.severe((Throwable)exception);
            return this.formatPlainText(text);
        }
    }

    private String formatPlainText(String text) {
        String escaped = HtmlUtils.toXMLEscapedText((String)text);
        String normalized = escaped.replace("\r\n", "\n").replace("\r", "\n");
        return normalized.replace("\n", "<br>");
    }
}

