/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Predicate;
import org.freeplane.api.Node;
import org.freeplane.api.NodeChangeListener;
import org.freeplane.api.NodeChanged;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.NodeProxy;

class NodeChangeListenerForScript {
    private final NodeChangeListener scriptListener;
    private final ScriptContext context;
    private final ClassLoader contextClassLoader;

    static Predicate<? super NodeChangeListenerForScript> contains(NodeChangeListener listener) {
        return e -> e.scriptListener.equals((Object)listener);
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void setContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    NodeChangeListenerForScript(NodeChangeListener scriptListener, ScriptContext context) {
        this.scriptListener = scriptListener;
        this.context = context;
        this.contextClassLoader = NodeChangeListenerForScript.getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fire(NodeModel node, NodeChanged.ChangedElement element) {
        ClassLoader oldContextClassLoader = NodeChangeListenerForScript.getContextClassLoader();
        try {
            NodeChangeListenerForScript.setContextClassLoader(this.contextClassLoader);
            this.scriptListener.nodeChanged(new NodeChanged((Node)new NodeProxy(node, this.context), element));
        }
        finally {
            NodeChangeListenerForScript.setContextClassLoader(oldContextClassLoader);
        }
    }

    NodeChangeListener getListener() {
        return this.scriptListener;
    }
}

