/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.model.RootWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItemDecoder;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapUtil;
import net.infonode.util.Direction;

public abstract class WindowItem {
    public static final DockingWindowProperties emptyProperties = new DockingWindowProperties();
    private WindowItem parent;
    private WeakReference connectedWindow = new WeakReference<Object>(null);
    private final ArrayList windows = new ArrayList();
    private DockingWindowProperties dockingWindowProperties;
    private DockingWindowProperties parentProperties = emptyProperties;
    private Direction lastMinimizedDirection;

    protected abstract DockingWindow createWindow(ViewReader var1, ArrayList var2);

    public abstract WindowItem copy();

    protected WindowItem() {
        this.dockingWindowProperties = new DockingWindowProperties(emptyProperties);
    }

    protected WindowItem(WindowItem windowItem) {
        this.dockingWindowProperties = new DockingWindowProperties(windowItem.getDockingWindowProperties().getMap().copy(true, true));
        this.dockingWindowProperties.getMap().replaceSuperMap(windowItem.getParentDockingWindowProperties().getMap(), emptyProperties.getMap());
        this.lastMinimizedDirection = windowItem.getLastMinimizedDirection();
    }

    public boolean isRestoreWindow() {
        return this.parent != null && this.parent.isRestoreWindow();
    }

    public void addWindow(WindowItem item) {
        if (item.parent != this) {
            this.addWindow(item, this.windows.size());
        }
    }

    public void addWindow(WindowItem item, int index) {
        int n = index = index == -1 ? this.windows.size() : index;
        if (item.parent == this) {
            int currentIndex = this.windows.indexOf(item);
            if (currentIndex != index) {
                this.windows.remove(currentIndex);
                this.windows.add(currentIndex < index ? index - 1 : index, item);
            }
        } else {
            item.setParent(this);
            this.windows.add(index, item);
        }
    }

    public void removeWindow(WindowItem item) {
        if (this.windows.remove(item)) {
            item.parent = null;
        }
    }

    public void removeWindowRefs(DockingWindow window) {
        if (this.connectedWindow.get() == window) {
            this.connectedWindow = new WeakReference<Object>(null);
        }
        int i = 0;
        while (i < this.getWindowCount()) {
            this.getWindow(i).removeWindowRefs(window);
            ++i;
        }
    }

    public void replaceWith(WindowItem item) {
        if (item == this || this.parent == null) {
            return;
        }
        item.setParent(this.parent);
        int index = this.parent.windows.indexOf(this);
        this.parent.windows.set(index, item);
        this.parent = null;
    }

    public int getWindowIndex(WindowItem item) {
        return this.windows.indexOf(item);
    }

    private void setParent(WindowItem parent) {
        if (this.parent == parent) {
            return;
        }
        if (this.parent != null) {
            this.parent.removeWindow(this);
        }
        this.parent = parent;
    }

    public final int getWindowCount() {
        return this.windows.size();
    }

    public final WindowItem getWindow(int index) {
        return (WindowItem)this.windows.get(index);
    }

    public WindowItem getParent() {
        return this.parent;
    }

    public void setConnectedWindow(DockingWindow window) {
        this.connectedWindow = new WeakReference<DockingWindow>(window);
    }

    public DockingWindow getConnectedWindow() {
        return (DockingWindow)this.connectedWindow.get();
    }

    public RootWindowItem getRootItem() {
        return this.parent == null ? null : this.parent.getRootItem();
    }

    public DockingWindow getVisibleDockingWindow() {
        DockingWindow window = this.getConnectedWindow();
        if (window != null && window.getRootWindow() != null && !window.isMinimized() && !window.isUndocked()) {
            return window;
        }
        int i = 0;
        while (i < this.getWindowCount()) {
            WindowItem item = this.getWindow(i);
            window = item.getVisibleDockingWindow();
            if (window != null) {
                return window;
            }
            ++i;
        }
        return null;
    }

    public DockingWindow getInsideDockingWindow() {
        if (this.getParent() == null) {
            return null;
        }
        DockingWindow dockingWindow = this.getParent().getConnectedWindow();
        if (dockingWindow != null) {
            return dockingWindow;
        }
        return this.getParent().getInsideDockingWindow();
    }

    public void removeAll() {
        while (this.getWindowCount() > 0) {
            this.removeWindow(this.getWindow(0));
        }
    }

    public boolean cleanUp() {
        int i = this.getWindowCount() - 1;
        while (i >= 0) {
            if (this.getWindow(i).cleanUp()) {
                this.windows.remove(i);
            }
            --i;
        }
        return this.getWindowCount() == 0 && this.getConnectedWindow() == null;
    }

    public DockingWindow getFirstChildWindow() {
        int i = 0;
        while (i < this.getWindowCount()) {
            DockingWindow window = this.getWindow(i).getFirstWindow();
            if (window != null) {
                return window;
            }
            ++i;
        }
        return null;
    }

    public DockingWindow getFirstWindow() {
        DockingWindow window = this.getConnectedWindow();
        return window != null ? window : this.getFirstChildWindow();
    }

    public WindowItem getChildWindowContaining(WindowItem windowItem) {
        while (windowItem.getParent() != this) {
            if ((windowItem = windowItem.getParent()) != null) continue;
            return null;
        }
        return windowItem;
    }

    public boolean hasAncestor(WindowItem ancestor) {
        return this == ancestor || this.parent != null && this.parent.hasAncestor(ancestor);
    }

    public WindowItem getTopItem() {
        return this.parent == null ? this : this.parent.getTopItem();
    }

    public DockingWindowProperties getDockingWindowProperties() {
        if (this.dockingWindowProperties == null) {
            this.dockingWindowProperties = new DockingWindowProperties(emptyProperties);
            this.parentProperties = emptyProperties;
        }
        return this.dockingWindowProperties;
    }

    public DockingWindowProperties getParentDockingWindowProperties() {
        return this.parentProperties == null ? emptyProperties : this.parentProperties;
    }

    public void setParentDockingWindowProperties(DockingWindowProperties parentProperties) {
        this.dockingWindowProperties.getMap().replaceSuperMap(this.parentProperties.getMap(), parentProperties.getMap());
        this.parentProperties = parentProperties;
    }

    public Direction getLastMinimizedDirection() {
        return this.lastMinimizedDirection;
    }

    public void setLastMinimizedDirection(Direction lastMinimizedDirection) {
        this.lastMinimizedDirection = lastMinimizedDirection;
    }

    public void writeSettings(ObjectOutputStream out, WriteContext context) throws IOException {
        out.writeInt(this.getLastMinimizedDirection() == null ? -1 : this.getLastMinimizedDirection().getValue());
        if (context.getWritePropertiesEnabled()) {
            this.dockingWindowProperties.getMap().write(out, true);
            this.getPropertyObject().write(out, true);
        }
    }

    public void readSettings(ObjectInputStream in, ReadContext context) throws IOException {
        if (context.getVersion() > 1) {
            int dir = in.readInt();
            this.setLastMinimizedDirection(dir == -1 ? null : Direction.getDirections()[dir]);
        }
        if (context.isPropertyValuesAvailable()) {
            if (context.getReadPropertiesEnabled()) {
                this.dockingWindowProperties.getMap().read(in);
                this.getPropertyObject().read(in);
            } else {
                PropertyMapUtil.skipMap(in);
                PropertyMapUtil.skipMap(in);
            }
        }
    }

    public void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(this.getWindowCount());
        int i = 0;
        while (i < this.getWindowCount()) {
            this.getWindow(i).write(out, context, viewWriter);
            ++i;
        }
        DockingWindow window = this.getConnectedWindow();
        this.writeSettings(out, context);
        out.writeBoolean(window != null && !window.isMinimized() && !window.isUndocked() && window.getRootWindow() != null);
    }

    public DockingWindow read(ObjectInputStream in, ReadContext context, ViewReader viewReader) throws IOException {
        ArrayList childWindows = this.readChildWindows(in, context, viewReader);
        this.readSettings(in, context);
        return in.readBoolean() ? this.createWindow(viewReader, childWindows) : (childWindows.size() > 0 ? (DockingWindow)childWindows.get(0) : null);
    }

    public ArrayList readChildWindows(ObjectInputStream in, ReadContext context, ViewReader viewReader) throws IOException {
        int count = in.readInt();
        this.removeAll();
        ArrayList<DockingWindow> childWindows = new ArrayList<DockingWindow>();
        int i = 0;
        while (i < count) {
            WindowItem childItem = WindowItemDecoder.decodeWindowItem(in, context, viewReader);
            this.addWindow(childItem);
            DockingWindow cw = childItem.read(in, context, viewReader);
            if (cw != null) {
                childWindows.add(cw);
            }
            ++i;
        }
        return childWindows;
    }

    protected PropertyMap getPropertyObject() {
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        DockingWindow dw = this.getConnectedWindow();
        s.append(dw + ":\n");
        int i = 0;
        while (i < this.windows.size()) {
            s.append("  " + this.windows.get(i).toString());
            ++i;
        }
        return s.toString();
    }

    public void clearWindows() {
        this.removeAll();
    }
}

