/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.nio.ByteBuffer;
import org.cugos.wkg.Envelope;
import org.cugos.wkg.GeoPackage;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.Reader;
import org.cugos.wkg.WKB;
import org.cugos.wkg.WKBReader;

public class GeoPackageReader
implements Reader<byte[]> {
    private final WKBReader wkbReader = new WKBReader();

    @Override
    public Geometry read(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return this.read(buffer, true).getGeometry();
    }

    @Override
    public String getName() {
        return "GeoPackage";
    }

    @Override
    public Geometry read(String hex) {
        return this.read(GeoPackageReader.toBytes(hex));
    }

    private GeoPackageGeometry read(ByteBuffer buffer, boolean shouldReadGeometry) {
        GeoPackageGeometry geoPackageGeometry = new GeoPackageGeometry();
        byte[] magic = new byte[2];
        buffer.get(magic);
        byte version = buffer.get();
        geoPackageGeometry.setVersion(version);
        byte flags = buffer.get();
        int geoPackageBinaryType = flags & GeoPackage.Flag.BinaryType.getValue();
        GeoPackage.BinaryType binaryType = GeoPackage.BinaryType.get(geoPackageBinaryType);
        geoPackageGeometry.setBinaryType(binaryType);
        int emptyGeometryFlag = flags & GeoPackage.Flag.GeometryEmpty.getValue();
        GeoPackage.GeometryEmptyType geometryEmptyType = GeoPackage.GeometryEmptyType.get(emptyGeometryFlag);
        geoPackageGeometry.setGeometryEmptyType(geometryEmptyType);
        int envelopeTypeFlag = (flags & GeoPackage.Flag.EnvelopeIndicator.getValue()) >> 1;
        GeoPackage.EnvelopeType envelopeType = GeoPackage.EnvelopeType.get(envelopeTypeFlag);
        geoPackageGeometry.setEnvelopeType(envelopeType);
        int byteOrder = flags & GeoPackage.Flag.Endianess.getValue();
        WKB.Endian endian = WKB.Endian.get(byteOrder);
        geoPackageGeometry.setEndian(endian);
        int srsId = buffer.getInt();
        geoPackageGeometry.setSrsId(srsId);
        Envelope envelope = null;
        if (envelopeType != GeoPackage.EnvelopeType.NoEnvelope) {
            double minX = buffer.getDouble();
            double maxX = buffer.getDouble();
            double minY = buffer.getDouble();
            double maxY = buffer.getDouble();
            double minZ = Double.NaN;
            double maxZ = Double.NaN;
            double minM = Double.NaN;
            double maxM = Double.NaN;
            if (envelopeType == GeoPackage.EnvelopeType.EnvelopeZ || envelopeType == GeoPackage.EnvelopeType.EnvelopeZM) {
                minZ = buffer.getDouble();
                maxZ = buffer.getDouble();
            }
            if (envelopeType == GeoPackage.EnvelopeType.EnvelopeM || envelopeType == GeoPackage.EnvelopeType.EnvelopeZM) {
                minM = buffer.getDouble();
                maxM = buffer.getDouble();
            }
            envelope = Envelope.create3DM(minX, minY, minZ, minM, maxX, maxY, maxZ, maxM);
        }
        geoPackageGeometry.setEnvelope(envelope);
        if (shouldReadGeometry) {
            Geometry geometry = this.wkbReader.read(buffer);
            geometry.setSrid(String.valueOf(srsId));
            geoPackageGeometry.setGeometry(geometry);
        }
        return geoPackageGeometry;
    }

    private static byte[] toBytes(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    private static class GeoPackageGeometry {
        private int version;
        private GeoPackage.BinaryType binaryType;
        private GeoPackage.GeometryEmptyType geometryEmptyType;
        private GeoPackage.EnvelopeType envelopeType;
        private WKB.Endian endian;
        private int srsId;
        private Envelope envelope;
        private Geometry geometry;

        private GeoPackageGeometry() {
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public GeoPackage.BinaryType getBinaryType() {
            return this.binaryType;
        }

        public void setBinaryType(GeoPackage.BinaryType binaryType) {
            this.binaryType = binaryType;
        }

        public GeoPackage.GeometryEmptyType getGeometryEmptyType() {
            return this.geometryEmptyType;
        }

        public void setGeometryEmptyType(GeoPackage.GeometryEmptyType geometryEmptyType) {
            this.geometryEmptyType = geometryEmptyType;
        }

        public GeoPackage.EnvelopeType getEnvelopeType() {
            return this.envelopeType;
        }

        public void setEnvelopeType(GeoPackage.EnvelopeType envelopeType) {
            this.envelopeType = envelopeType;
        }

        public WKB.Endian getEndian() {
            return this.endian;
        }

        public void setEndian(WKB.Endian endian) {
            this.endian = endian;
        }

        public int getSrsId() {
            return this.srsId;
        }

        public void setSrsId(int srsId) {
            this.srsId = srsId;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public void setEnvelope(Envelope envelope) {
            this.envelope = envelope;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public void setGeometry(Geometry geometry) {
            this.geometry = geometry;
        }
    }
}

