# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create a record set within a Private DNS zone.
    """

    _aaz_info = {
        "version": "2018-09-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/privatednszones/{}/{}/{}", "2018-09-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.if_none_match = AAZStrArg(
            options=["--if-none-match"],
            help="Set to '*' to allow a new record set to be created, but to prevent updating an existing record set. Other values will be ignored.",
            default="*",
        )
        _args_schema.zone_name = AAZStrArg(
            options=["-z", "--zone-name"],
            help="Name of the Private DNS zone (without a terminating dot).",
            required=True,
        )
        _args_schema.record_type = AAZStrArg(
            options=["--record-type"],
            help="The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the Private DNS zone is created).",
            required=True,
            enum={"A": "A", "AAAA": "AAAA", "CNAME": "CNAME", "MX": "MX", "PTR": "PTR", "SOA": "SOA", "SRV": "SRV", "TXT": "TXT"},
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the record set, relative to the name of the zone.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.metadata = AAZDictArg(
            options=["--metadata"],
            help="Metadata attached to the record set.",
        )
        _args_schema.ttl = AAZIntArg(
            options=["--ttl"],
            help="Record set TTL (time-to-live).",
            default=3600,
        )

        metadata = cls._args_schema.metadata
        metadata.Element = AAZStrArg()

        # define Arg Group "Parameters"

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.a_records = AAZListArg(
            options=["--a-records"],
            arg_group="Properties",
            help="The list of A records in the record set.",
        )
        _args_schema.aaaa_records = AAZListArg(
            options=["--aaaa-records"],
            arg_group="Properties",
            help="The list of AAAA records in the record set.",
        )
        _args_schema.cname_record = AAZObjectArg(
            options=["--cname-record"],
            arg_group="Properties",
            help="The CNAME record in the record set.",
        )
        _args_schema.mx_records = AAZListArg(
            options=["--mx-records"],
            arg_group="Properties",
            help="The list of MX records in the record set.",
        )
        _args_schema.ptr_records = AAZListArg(
            options=["--ptr-records"],
            arg_group="Properties",
            help="The list of PTR records in the record set.",
        )
        _args_schema.soa_record = AAZObjectArg(
            options=["--soa-record"],
            arg_group="Properties",
            help="The SOA record in the record set.",
        )
        _args_schema.srv_records = AAZListArg(
            options=["--srv-records"],
            arg_group="Properties",
            help="The list of SRV records in the record set.",
        )
        _args_schema.txt_records = AAZListArg(
            options=["--txt-records"],
            arg_group="Properties",
            help="The list of TXT records in the record set.",
        )

        a_records = cls._args_schema.a_records
        a_records.Element = AAZObjectArg()

        _element = cls._args_schema.a_records.Element
        _element.ipv4_address = AAZStrArg(
            options=["ipv4-address"],
            help="The IPv4 address of this A record.",
        )

        aaaa_records = cls._args_schema.aaaa_records
        aaaa_records.Element = AAZObjectArg()

        _element = cls._args_schema.aaaa_records.Element
        _element.ipv6_address = AAZStrArg(
            options=["ipv6-address"],
            help="The IPv6 address of this AAAA record.",
        )

        cname_record = cls._args_schema.cname_record
        cname_record.cname = AAZStrArg(
            options=["cname"],
            help="The canonical name for this CNAME record.",
        )

        mx_records = cls._args_schema.mx_records
        mx_records.Element = AAZObjectArg()

        _element = cls._args_schema.mx_records.Element
        _element.exchange = AAZStrArg(
            options=["exchange"],
            help="The domain name of the mail host for this MX record.",
        )
        _element.preference = AAZIntArg(
            options=["preference"],
            help="The preference value for this MX record.",
        )

        ptr_records = cls._args_schema.ptr_records
        ptr_records.Element = AAZObjectArg()

        _element = cls._args_schema.ptr_records.Element
        _element.ptrdname = AAZStrArg(
            options=["ptrdname"],
            help="The PTR target domain name for this PTR record.",
        )

        soa_record = cls._args_schema.soa_record
        soa_record.email = AAZStrArg(
            options=["email"],
            help="The email contact for this SOA record.",
        )
        soa_record.expire_time = AAZIntArg(
            options=["expire-time"],
            help="The expire time for this SOA record.",
        )
        soa_record.host = AAZStrArg(
            options=["host"],
            help="The domain name of the authoritative name server for this SOA record.",
        )
        soa_record.minimum_ttl = AAZIntArg(
            options=["minimum-ttl"],
            help="The minimum value for this SOA record. By convention this is used to determine the negative caching duration.",
        )
        soa_record.refresh_time = AAZIntArg(
            options=["refresh-time"],
            help="The refresh value for this SOA record.",
        )
        soa_record.retry_time = AAZIntArg(
            options=["retry-time"],
            help="The retry time for this SOA record.",
        )
        soa_record.serial_number = AAZIntArg(
            options=["serial-number"],
            help="The serial number for this SOA record.",
        )

        srv_records = cls._args_schema.srv_records
        srv_records.Element = AAZObjectArg()

        _element = cls._args_schema.srv_records.Element
        _element.port = AAZIntArg(
            options=["port"],
            help="The port value for this SRV record.",
        )
        _element.priority = AAZIntArg(
            options=["priority"],
            help="The priority value for this SRV record.",
        )
        _element.target = AAZStrArg(
            options=["target"],
            help="The target domain name for this SRV record.",
        )
        _element.weight = AAZIntArg(
            options=["weight"],
            help="The weight value for this SRV record.",
        )

        txt_records = cls._args_schema.txt_records
        txt_records.Element = AAZObjectArg()

        _element = cls._args_schema.txt_records.Element
        _element.value = AAZListArg(
            options=["value"],
            help="The text value of this TXT record.",
        )

        value = cls._args_schema.txt_records.Element.value
        value.Element = AAZStrArg()
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.RecordSetsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class RecordSetsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200, 201]:
                return self.on_200_201(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "privateZoneName", self.ctx.args.zone_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "recordType", self.ctx.args.record_type,
                    required=True,
                ),
                **self.serialize_url_param(
                    "relativeRecordSetName", self.ctx.args.name,
                    skip_quote=True,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-09-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "If-None-Match", self.ctx.args.if_none_match,
                ),
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("aRecords", AAZListType, ".a_records")
                properties.set_prop("aaaaRecords", AAZListType, ".aaaa_records")
                properties.set_prop("cnameRecord", AAZObjectType, ".cname_record")
                properties.set_prop("metadata", AAZDictType, ".metadata")
                properties.set_prop("mxRecords", AAZListType, ".mx_records")
                properties.set_prop("ptrRecords", AAZListType, ".ptr_records")
                properties.set_prop("soaRecord", AAZObjectType, ".soa_record")
                properties.set_prop("srvRecords", AAZListType, ".srv_records")
                properties.set_prop("ttl", AAZIntType, ".ttl")
                properties.set_prop("txtRecords", AAZListType, ".txt_records")

            a_records = _builder.get(".properties.aRecords")
            if a_records is not None:
                a_records.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.aRecords[]")
            if _elements is not None:
                _elements.set_prop("ipv4Address", AAZStrType, ".ipv4_address")

            aaaa_records = _builder.get(".properties.aaaaRecords")
            if aaaa_records is not None:
                aaaa_records.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.aaaaRecords[]")
            if _elements is not None:
                _elements.set_prop("ipv6Address", AAZStrType, ".ipv6_address")

            cname_record = _builder.get(".properties.cnameRecord")
            if cname_record is not None:
                cname_record.set_prop("cname", AAZStrType, ".cname")

            metadata = _builder.get(".properties.metadata")
            if metadata is not None:
                metadata.set_elements(AAZStrType, ".")

            mx_records = _builder.get(".properties.mxRecords")
            if mx_records is not None:
                mx_records.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.mxRecords[]")
            if _elements is not None:
                _elements.set_prop("exchange", AAZStrType, ".exchange")
                _elements.set_prop("preference", AAZIntType, ".preference")

            ptr_records = _builder.get(".properties.ptrRecords")
            if ptr_records is not None:
                ptr_records.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.ptrRecords[]")
            if _elements is not None:
                _elements.set_prop("ptrdname", AAZStrType, ".ptrdname")

            soa_record = _builder.get(".properties.soaRecord")
            if soa_record is not None:
                soa_record.set_prop("email", AAZStrType, ".email")
                soa_record.set_prop("expireTime", AAZIntType, ".expire_time")
                soa_record.set_prop("host", AAZStrType, ".host")
                soa_record.set_prop("minimumTtl", AAZIntType, ".minimum_ttl")
                soa_record.set_prop("refreshTime", AAZIntType, ".refresh_time")
                soa_record.set_prop("retryTime", AAZIntType, ".retry_time")
                soa_record.set_prop("serialNumber", AAZIntType, ".serial_number")

            srv_records = _builder.get(".properties.srvRecords")
            if srv_records is not None:
                srv_records.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.srvRecords[]")
            if _elements is not None:
                _elements.set_prop("port", AAZIntType, ".port")
                _elements.set_prop("priority", AAZIntType, ".priority")
                _elements.set_prop("target", AAZStrType, ".target")
                _elements.set_prop("weight", AAZIntType, ".weight")

            txt_records = _builder.get(".properties.txtRecords")
            if txt_records is not None:
                txt_records.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.txtRecords[]")
            if _elements is not None:
                _elements.set_prop("value", AAZListType, ".value")

            value = _builder.get(".properties.txtRecords[].value")
            if value is not None:
                value.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType()
            _schema_on_200_201.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.a_records = AAZListType(
                serialized_name="aRecords",
            )
            properties.aaaa_records = AAZListType(
                serialized_name="aaaaRecords",
            )
            properties.cname_record = AAZObjectType(
                serialized_name="cnameRecord",
            )
            properties.fqdn = AAZStrType(
                flags={"read_only": True},
            )
            properties.is_auto_registered = AAZBoolType(
                serialized_name="isAutoRegistered",
                flags={"read_only": True},
            )
            properties.metadata = AAZDictType()
            properties.mx_records = AAZListType(
                serialized_name="mxRecords",
            )
            properties.ptr_records = AAZListType(
                serialized_name="ptrRecords",
            )
            properties.soa_record = AAZObjectType(
                serialized_name="soaRecord",
            )
            properties.srv_records = AAZListType(
                serialized_name="srvRecords",
            )
            properties.ttl = AAZIntType()
            properties.txt_records = AAZListType(
                serialized_name="txtRecords",
            )

            a_records = cls._schema_on_200_201.properties.a_records
            a_records.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.a_records.Element
            _element.ipv4_address = AAZStrType(
                serialized_name="ipv4Address",
            )

            aaaa_records = cls._schema_on_200_201.properties.aaaa_records
            aaaa_records.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.aaaa_records.Element
            _element.ipv6_address = AAZStrType(
                serialized_name="ipv6Address",
            )

            cname_record = cls._schema_on_200_201.properties.cname_record
            cname_record.cname = AAZStrType()

            metadata = cls._schema_on_200_201.properties.metadata
            metadata.Element = AAZStrType()

            mx_records = cls._schema_on_200_201.properties.mx_records
            mx_records.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.mx_records.Element
            _element.exchange = AAZStrType()
            _element.preference = AAZIntType()

            ptr_records = cls._schema_on_200_201.properties.ptr_records
            ptr_records.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.ptr_records.Element
            _element.ptrdname = AAZStrType()

            soa_record = cls._schema_on_200_201.properties.soa_record
            soa_record.email = AAZStrType()
            soa_record.expire_time = AAZIntType(
                serialized_name="expireTime",
            )
            soa_record.host = AAZStrType()
            soa_record.minimum_ttl = AAZIntType(
                serialized_name="minimumTtl",
            )
            soa_record.refresh_time = AAZIntType(
                serialized_name="refreshTime",
            )
            soa_record.retry_time = AAZIntType(
                serialized_name="retryTime",
            )
            soa_record.serial_number = AAZIntType(
                serialized_name="serialNumber",
            )

            srv_records = cls._schema_on_200_201.properties.srv_records
            srv_records.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.srv_records.Element
            _element.port = AAZIntType()
            _element.priority = AAZIntType()
            _element.target = AAZStrType()
            _element.weight = AAZIntType()

            txt_records = cls._schema_on_200_201.properties.txt_records
            txt_records.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.txt_records.Element
            _element.value = AAZListType()

            value = cls._schema_on_200_201.properties.txt_records.Element.value
            value.Element = AAZStrType()

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""


__all__ = ["Create"]
