﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class CopyFpgaImageResponse {
 public:
  AWS_EC2_API CopyFpgaImageResponse() = default;
  AWS_EC2_API CopyFpgaImageResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API CopyFpgaImageResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The ID of the new AFI.</p>
   */
  inline const Aws::String& GetFpgaImageId() const { return m_fpgaImageId; }
  template <typename FpgaImageIdT = Aws::String>
  void SetFpgaImageId(FpgaImageIdT&& value) {
    m_fpgaImageIdHasBeenSet = true;
    m_fpgaImageId = std::forward<FpgaImageIdT>(value);
  }
  template <typename FpgaImageIdT = Aws::String>
  CopyFpgaImageResponse& WithFpgaImageId(FpgaImageIdT&& value) {
    SetFpgaImageId(std::forward<FpgaImageIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  CopyFpgaImageResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_fpgaImageId;

  ResponseMetadata m_responseMetadata;
  bool m_fpgaImageIdHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
