/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.ImageBuilder;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

final class WindowBuilders {
    WindowBuilders() {
    }

    static ComponentBuilders.ComponentBuilder<? extends Component> getBuilder(Instance instance) {
        if (DetailsUtils.isSubclassOf(instance, JRootPane.class.getName())) {
            return new JRootPaneBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JDesktopPane.class.getName())) {
            return new JDesktopPaneBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JLayeredPane.class.getName())) {
            return new JLayeredPaneBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, Frame.class.getName())) {
            return new FrameBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, Dialog.class.getName())) {
            return new DialogBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JInternalFrame.class.getName())) {
            return new JInternalFrameBuilder(instance);
        }
        return null;
    }

    private static class JInternalFrameBuilder
    extends ComponentBuilders.JComponentBuilder<JInternalFrame> {
        private final JRootPaneBuilder _rootPane;
        private final boolean closable;
        private final boolean _isClosed;
        private final boolean maximizable;
        private final boolean _isMaximum;
        private final boolean iconable;
        private final boolean _isIcon;
        private final boolean resizable;
        private final boolean _isSelected;
        private final BaseBuilders.IconBuilder frameIcon;
        private final String title;

        JInternalFrameBuilder(Instance instance) {
            super(instance, false);
            this._rootPane = JRootPaneBuilder.fromField(instance, "rootPane");
            this.closable = DetailsUtils.getBooleanFieldValue(instance, "closable", false);
            this._isClosed = DetailsUtils.getBooleanFieldValue(instance, "isClosed", false);
            this.maximizable = DetailsUtils.getBooleanFieldValue(instance, "maximizable", false);
            this._isMaximum = DetailsUtils.getBooleanFieldValue(instance, "isMaximum", false);
            this.iconable = DetailsUtils.getBooleanFieldValue(instance, "iconable", false);
            this._isIcon = DetailsUtils.getBooleanFieldValue(instance, "isIcon", false);
            this.resizable = DetailsUtils.getBooleanFieldValue(instance, "resizable", false);
            this._isSelected = DetailsUtils.getBooleanFieldValue(instance, "isSelected", false);
            this.frameIcon = BaseBuilders.IconBuilder.fromField(instance, "frameIcon");
            this.title = Utils.getFieldString(instance, "title");
        }

        @Override
        protected void setupInstance(JInternalFrame instance) {
            super.setupInstance(instance);
            if (this.frameIcon != null) {
                instance.setFrameIcon((Icon)this.frameIcon.createInstance());
            }
        }

        @Override
        protected JInternalFrame createInstanceImpl() {
            JInternalFrame frame = new JInternalFrame(this.title, this.resizable, this.closable, this.maximizable, this.iconable){

                @Override
                protected JRootPane createRootPane() {
                    return _rootPane == null ? null : (JRootPane)_rootPane.createInstance();
                }

                @Override
                public void addNotify() {
                    try {
                        this.setClosed(_isClosed);
                        this.setMaximum(_isMaximum);
                        this.setIcon(_isIcon);
                        this.setSelected(_isSelected);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            };
            return frame;
        }
    }

    private static class DialogBuilder
    extends ComponentBuilders.ContainerBuilder<Dialog> {
        private final String title;
        private final boolean undecorated;
        private final Image image;

        DialogBuilder(Instance instance) {
            super(instance);
            Object elementData;
            Instance i;
            this.title = Utils.getFieldString(instance, "title");
            this.undecorated = DetailsUtils.getBooleanFieldValue(instance, "undecorated", false);
            Image _image = null;
            Object icons = instance.getValueOfField("icons");
            if (icons == null) {
                Object parent = instance.getValueOfField("parent");
                while (parent instanceof Instance && !((icons = ((Instance)parent).getValueOfField("icons")) instanceof Instance)) {
                    parent = ((Instance)parent).getValueOfField("parent");
                }
            }
            if (icons instanceof Instance && DetailsUtils.getIntFieldValue(i = (Instance)icons, "size", 0) > 0 && (elementData = i.getValueOfField("elementData")) instanceof ObjectArrayInstance) {
                Instance o = (Instance)((ObjectArrayInstance)elementData).getValues().get(0);
                _image = o != null ? ImageBuilder.buildImage(o) : null;
            }
            this.image = _image;
        }

        @Override
        protected void setupInstance(Dialog instance) {
            super.setupInstance(instance);
            instance.setUndecorated(this.undecorated);
            if (this.image != null) {
                instance.setIconImage(this.image);
            }
        }

        @Override
        protected Dialog createInstanceImpl() {
            return new JDialog((Frame)null, this.title){

                @Override
                protected void dialogInit() {
                }

                @Override
                public void addNotify() {
                }

                @Override
                public void remove(Component comp) {
                }

                @Override
                public void setVisible(boolean b) {
                }
            };
        }

        @Override
        protected Component createPresenterImpl(Dialog instance) {
            Image img;
            if (instance.isUndecorated()) {
                JPanel presenter = new JPanel(null);
                presenter.setOpaque(true);
                Dimension dim = null;
                for (Component c : instance.getComponents()) {
                    presenter.add(c);
                    Dimension s = c.getSize();
                    if (dim == null) {
                        dim = s;
                        continue;
                    }
                    dim.width = Math.max(dim.width, s.width);
                    dim.height = Math.max(dim.height, s.height);
                }
                if (dim != null) {
                    presenter.setSize(dim);
                }
                return presenter;
            }
            JInternalFrame presenter = new JInternalFrame(instance.getTitle());
            List<Image> images = instance.getIconImages();
            Image image = img = images.isEmpty() ? null : images.get(0);
            if (img != null) {
                presenter.setFrameIcon(new ImageIcon(img));
            }
            for (Component c : instance.getComponents()) {
                presenter.add(c);
            }
            presenter.pack();
            return presenter;
        }
    }

    private static class FrameBuilder
    extends ComponentBuilders.ContainerBuilder<Frame> {
        private final String title;
        private final boolean undecorated;
        private final Image image;

        FrameBuilder(Instance instance) {
            super(instance);
            Object elementData;
            Instance i;
            this.title = Utils.getFieldString(instance, "title");
            this.undecorated = DetailsUtils.getBooleanFieldValue(instance, "undecorated", false);
            Image _image = null;
            Object icons = instance.getValueOfField("icons");
            if (icons instanceof Instance && DetailsUtils.getIntFieldValue(i = (Instance)icons, "size", 0) > 0 && (elementData = i.getValueOfField("elementData")) instanceof ObjectArrayInstance) {
                Instance o = (Instance)((ObjectArrayInstance)elementData).getValues().get(0);
                _image = o != null ? ImageBuilder.buildImage(o) : null;
            }
            this.image = _image;
        }

        @Override
        protected void setupInstance(Frame instance) {
            super.setupInstance(instance);
            instance.setUndecorated(this.undecorated);
            if (this.image != null) {
                instance.setIconImage(this.image);
            }
        }

        @Override
        protected Frame createInstanceImpl() {
            return new JFrame(this.title){

                @Override
                protected void frameInit() {
                }

                @Override
                public void addNotify() {
                }

                @Override
                public void remove(Component comp) {
                }

                @Override
                public void setVisible(boolean b) {
                }
            };
        }

        @Override
        protected Component createPresenterImpl(Frame instance) {
            if (instance.isUndecorated()) {
                JPanel presenter = new JPanel(null);
                presenter.setOpaque(true);
                Dimension dim = null;
                for (Component c : instance.getComponents()) {
                    presenter.add(c);
                    Dimension s = c.getSize();
                    if (dim == null) {
                        dim = s;
                        continue;
                    }
                    dim.width = Math.max(dim.width, s.width);
                    dim.height = Math.max(dim.height, s.height);
                }
                if (dim != null) {
                    presenter.setSize(dim);
                }
                return presenter;
            }
            JInternalFrame presenter = new JInternalFrame(instance.getTitle());
            Image img = instance.getIconImage();
            if (img != null) {
                presenter.setFrameIcon(new ImageIcon(img));
            }
            for (Component c : instance.getComponents()) {
                presenter.add(c);
            }
            presenter.pack();
            return presenter;
        }
    }

    private static class JDesktopPaneBuilder
    extends JLayeredPaneBuilder {
        JDesktopPaneBuilder(Instance instance) {
            super(instance);
        }

        @Override
        protected JLayeredPane createInstanceImpl() {
            return new JDesktopPane();
        }
    }

    private static class JLayeredPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JLayeredPane> {
        JLayeredPaneBuilder(Instance instance) {
            super(instance);
        }

        @Override
        protected JLayeredPane createInstanceImpl() {
            return new JLayeredPane();
        }
    }

    private static class JRootPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JRootPane> {
        private final int windowDecorationStyle;

        JRootPaneBuilder(Instance instance) {
            super(instance);
            this.windowDecorationStyle = DetailsUtils.getIntFieldValue(instance, "windowDecorationStyle", 0);
        }

        static JRootPaneBuilder fromField(Instance instance, String field) {
            Object insets = instance.getValueOfField(field);
            if (!(insets instanceof Instance)) {
                return null;
            }
            return new JRootPaneBuilder((Instance)insets);
        }

        @Override
        protected void setupInstance(JRootPane instance) {
            super.setupInstance(instance);
            instance.setWindowDecorationStyle(this.windowDecorationStyle);
        }

        @Override
        protected JRootPane createInstanceImpl() {
            return new JRootPane();
        }
    }
}

