/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wcadmin;

import java.io.File;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.wcadmin.Bundle;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.NotifyHtmlPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class UpgradeAction
extends ContextAction {
    @Override
    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    @Override
    protected int getFileEnabledStatus() {
        return 0;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_Upgrade_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        File[] roots = ctx.getRootFiles();
        if (roots == null || roots.length == 0) {
            Subversion.LOG.log(Level.FINE, "No versioned folder in the selected context for {0}", nodes);
            return;
        }
        this.upgrade(true, roots);
    }

    public void upgrade(File root) {
        this.upgrade(false, root);
    }

    private void upgrade(boolean explicitelyInvoked, File ... roots) {
        final HashSet<File> toUpgrade = new HashSet<File>();
        for (File root : roots) {
            boolean needsUpgrade;
            block4: {
                needsUpgrade = false;
                try {
                    SvnUtils.getRepositoryRootUrl(root);
                }
                catch (SVNClientException ex) {
                    String msg = ex.getMessage().toLowerCase();
                    if (!SvnClientExceptionHandler.isTooOldWorkingCopy(msg) || !msg.contains("upgrade") && (!msg.contains("working copy format") || !msg.contains("is too old"))) break block4;
                    needsUpgrade = true;
                }
            }
            boolean accept = !explicitelyInvoked ? this.confirmPossibleUpgrade(root.getAbsolutePath()) : (needsUpgrade ? this.confirmUpgrade(root.getAbsolutePath()) : this.forceUpgrade(root.getAbsolutePath()));
            if (!accept) continue;
            toUpgrade.add(root);
        }
        if (toUpgrade.isEmpty()) {
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor();
        SvnProgressSupport support = new SvnProgressSupport(this){
            final /* synthetic */ UpgradeAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void perform() {
                for (File root : toUpgrade) {
                    try {
                        SvnClient client = Subversion.getInstance().getClient(true);
                        this.setCancellableDelegate(client);
                        boolean cont = true;
                        File wcRoot = root;
                        while (cont) {
                            cont = false;
                            try {
                                client.upgrade(wcRoot);
                                Subversion.getInstance().getStatusCache().refreshAsync(Subversion.getInstance().getStatusCache().listFiles(new File[]{Subversion.getInstance().getTopmostManagedAncestor(wcRoot)}, 88532));
                                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_UpgradeAction_statusBar_upgraded(root.getAbsolutePath()));
                            }
                            catch (SVNClientException ex) {
                                String msg = ex.getMessage().toLowerCase();
                                if (msg.contains("as it is not a pre-1.7 working copy root")) {
                                    File rootCandidate;
                                    for (String s : new String[]{".*root is '([^']+)'.*"}) {
                                        Pattern p = Pattern.compile(s, 32);
                                        Matcher m = p.matcher(ex.getMessage());
                                        if (!m.matches()) continue;
                                        File rootCandidate2 = new File(m.group(1));
                                        if (wcRoot.equals(rootCandidate2)) break;
                                        wcRoot = rootCandidate2;
                                        cont = true;
                                        break;
                                    }
                                    if (!cont && (rootCandidate = wcRoot.getParentFile()) != null && SvnUtils.isManaged(rootCandidate)) {
                                        wcRoot = rootCandidate;
                                        cont = true;
                                    }
                                }
                                if (cont) continue;
                                throw ex;
                            }
                        }
                    }
                    catch (SVNClientException ex) {
                        this.annotate(ex);
                    }
                }
            }
        };
        support.start(rp, null, NbBundle.getMessage(UpgradeAction.class, (String)"LBL_Upgrade_Progress"));
    }

    private boolean confirmPossibleUpgrade(String path) {
        return this.confirm(NbBundle.getMessage(UpgradeAction.class, (String)"LBL_Upgrade_title", (Object)path), NbBundle.getMessage(UpgradeAction.class, (String)"MSG_Upgrade_possibleUpgrade", (Object)path));
    }

    private boolean confirmUpgrade(String path) {
        return this.confirm(NbBundle.getMessage(UpgradeAction.class, (String)"LBL_Upgrade_title", (Object)path), NbBundle.getMessage(UpgradeAction.class, (String)"MSG_Upgrade_upgrade", (Object)path));
    }

    private boolean forceUpgrade(String path) {
        return JOptionPane.showConfirmDialog(Utilities.findDialogParent(), NbBundle.getMessage(UpgradeAction.class, (String)"MSG_Upgrade_forceUpgrade", (Object)path), NbBundle.getMessage(UpgradeAction.class, (String)"LBL_Upgrade_title", (Object)path), 0, 3) == 0;
    }

    private boolean confirm(String title, String message) {
        NotifyHtmlPanel p = new NotifyHtmlPanel();
        p.setText(message);
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)p, title, 2, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION);
        return NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify(descriptor);
    }
}

