/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.codegen.ASTNodeUtilities;
import org.netbeans.modules.php.editor.codegen.InvocationContextResolver;
import org.netbeans.modules.php.editor.codegen.ui.TableGeneratorPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TableGenerator
implements CodeGenerator {
    private static final String HEADER_BEGIN = "echo '<table>';\necho '<tr>';\n";
    private static final String HEADER_LINE = "echo '<th>${COLUMN}</th>';\n";
    private static final String HEADER_END = "echo '</tr>';\n";
    private static final String CONN_BEGIN = "$$${RESULT newVarName default=\"result\"} = mysqli_query($$${CONN}, '${SQL}');\nwhile (($$${ROW newVarName default=\"row\"} = mysqli_fetch_array($$${RESULT}, MYSQLI_ASSOC)) != NULL) {\n   echo '<tr>';\n";
    private static final String CONN_LINE = "   echo '<td>' . $$${ROW}['${COLUMN}'] . '</td>';\n";
    private static final String CONN_END = "   echo '</tr>';\n}\nmysqli_free_result($$${RESULT});\necho '</table>';";
    private final JTextComponent component;

    public TableGenerator(JTextComponent component) {
        this.component = component;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TableGenerator.class, (String)"LBL_DatabaseTable");
    }

    public void invoke() {
        TableGeneratorPanel.TableAndColumns tableAndColumns;
        String connVariable = this.findConnVariableInScope();
        if (connVariable == null) {
            connVariable = "conn";
        }
        if ((tableAndColumns = TableGeneratorPanel.selectTableAndColumns(connVariable)) == null) {
            return;
        }
        String text = this.generateTemplateText(tableAndColumns);
        CodeTemplateManager manager = CodeTemplateManager.get((Document)this.component.getDocument());
        CodeTemplate template = manager.createTemporary(text);
        template.insert(this.component);
    }

    private String findConnVariableInScope() {
        final ArrayList connVariables = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)this.component.getDocument())), (UserTask)new UserTask(this){
                final /* synthetic */ TableGenerator this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    ParserResult info = (ParserResult)resultIterator.getParserResult();
                    if (info != null) {
                        ASTNodeUtilities.getVariablesInScope(info, this.this$0.component.getCaretPosition(), new ASTNodeUtilities.VariableAcceptor(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public boolean acceptVariable(String variableName) {
                                if (variableName.contains("conn")) {
                                    connVariables.add(variableName);
                                }
                                return false;
                            }
                        });
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        if (connVariables.contains("conn")) {
            return "conn";
        }
        if (connVariables.contains("connection")) {
            return "connection";
        }
        Iterator iterator = connVariables.iterator();
        if (iterator.hasNext()) {
            String connVariable = (String)iterator.next();
            return connVariable;
        }
        return null;
    }

    private String generateTemplateText(TableGeneratorPanel.TableAndColumns tableAndColumns) {
        StringBuilder builder = new StringBuilder();
        builder.append(HEADER_BEGIN);
        List<String> columns = tableAndColumns.getSelectedColumns().isEmpty() ? tableAndColumns.getAllColumns() : tableAndColumns.getSelectedColumns();
        for (String column : columns) {
            builder.append(HEADER_LINE.replace("${COLUMN}", column));
        }
        builder.append(HEADER_END);
        builder.append(CONN_BEGIN.replace("${SQL}", this.generateSelect(tableAndColumns)).replace("${CONN}", tableAndColumns.getConnVariable()));
        for (String column : columns) {
            builder.append(CONN_LINE.replace("${COLUMN}", column));
        }
        builder.append(CONN_END);
        return builder.toString();
    }

    private String generateSelect(TableGeneratorPanel.TableAndColumns tableAndColumns) {
        SQLIdentifiers.Quoter quoter = tableAndColumns.getIdentifierQuoter();
        StringBuilder builder = new StringBuilder("SELECT ");
        List<String> columns = tableAndColumns.getSelectedColumns();
        if (columns.isEmpty()) {
            builder.append(" * ");
        } else {
            int index = 0;
            for (String column : columns) {
                builder.append(this.quoteIdentifier(quoter, column));
                if (index < columns.size() - 1) {
                    builder.append(',');
                }
                ++index;
                builder.append(' ');
            }
        }
        builder.append("FROM ");
        builder.append(this.quoteIdentifier(quoter, tableAndColumns.getTable()));
        return builder.toString();
    }

    private String quoteIdentifier(SQLIdentifiers.Quoter quoter, String identifier) {
        return quoter.quoteIfNeeded(identifier).replace("'", "\\'");
    }

    public static final class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            List<Object> retval = Collections.emptyList();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            InvocationContextResolver invocationContextResolver = InvocationContextResolver.create(component);
            if (!invocationContextResolver.isExactlyIn(InvocationContextResolver.InvocationContext.CLASS) && !invocationContextResolver.isExactlyIn(InvocationContextResolver.InvocationContext.EMPTY_STATEMENT)) {
                retval = Collections.singletonList(new TableGenerator(component));
            }
            return retval;
        }
    }
}

