/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbrefactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbrefactoring.EjbRefactoringFactory;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class EjbRefactoringPlugin
implements RefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(EjbRefactoringPlugin.class.getName());
    private AbstractRefactoring refactoring;

    public EjbRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        FileObject fo;
        final Problem[] result = new Problem[1];
        final TreePathHandle tph = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph != null && (fo = tph.getFileObject()) != null) {
            try {
                JavaSource js = JavaSource.forFileObject((FileObject)fo);
                if (js != null) {
                    js.runUserActionTask((Task)new CancellableTask<CompilationController>(){
                        final /* synthetic */ EjbRefactoringPlugin this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run(CompilationController info) throws Exception {
                            info.toPhase(JavaSource.Phase.RESOLVED);
                            Element el = tph.resolveElement((CompilationInfo)info);
                            if (el == null) {
                                return;
                            }
                            if (el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                                result[0] = null;
                            } else {
                                String refactoringWarning = this.this$0.getRefactoringWarning();
                                if (refactoringWarning != null) {
                                    result[0] = new Problem(false, refactoringWarning);
                                }
                            }
                        }

                        public void cancel() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    }, true);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        return result[0];
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        return null;
    }

    private String getRefactoringWarning() {
        String msg = this.refactoring instanceof RenameRefactoring ? "TXT_EjbJarRenameWarning" : (this.refactoring instanceof SafeDeleteRefactoring ? "TXT_EjbJarSafeDeleteWarning" : (this.refactoring instanceof MoveRefactoring ? "TXT_EjbJarMoveClassWarning" : (this.refactoring instanceof WhereUsedQuery ? "TXT_EjbJarWhereUsedWarning" : "TXT_EjbJarGeneralWarning")));
        FileObject source = this.getRefactoringSource(this.refactoring);
        if (source == null) {
            return null;
        }
        List<EjbJar> ejbJars = this.getEjbJars(source);
        if (ejbJars.isEmpty()) {
            return null;
        }
        String ejbJarPaths = this.getEjbJarPaths(ejbJars);
        return NbBundle.getMessage(EjbRefactoringFactory.class, (String)msg, (Object)ejbJarPaths);
    }

    private String getEjbJarPaths(List<EjbJar> ejbJars) {
        StringBuilder ejbJarPaths = new StringBuilder();
        Iterator<EjbJar> it = ejbJars.iterator();
        while (it.hasNext()) {
            EjbJar ejbJar = it.next();
            String path = FileUtil.getFileDisplayName((FileObject)ejbJar.getDeploymentDescriptor());
            ejbJarPaths.append(path);
            if (!it.hasNext()) continue;
            ejbJarPaths.append(", ");
        }
        return ejbJarPaths.toString();
    }

    private FileObject getRefactoringSource(AbstractRefactoring refactoring) {
        FileObject source = (FileObject)refactoring.getRefactoringSource().lookup(FileObject.class);
        if (source != null) {
            return source;
        }
        TreePathHandle tph = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph != null) {
            return tph.getFileObject();
        }
        NonRecursiveFolder folder = (NonRecursiveFolder)refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        if (folder != null) {
            return folder.getFolder();
        }
        return null;
    }

    private List<EjbJar> getEjbJars(FileObject source) {
        ArrayList<EjbJar> result = new ArrayList<EjbJar>();
        for (EjbJar each : EjbRefactoringPlugin.getRelevantEjbModules(source)) {
            FileObject ejbJarFO = each.getDeploymentDescriptor();
            if (ejbJarFO == null) continue;
            result.add(each);
        }
        return result;
    }

    private static Collection<EjbJar> getRelevantEjbModules(FileObject fo) {
        Project affectedProject = FileOwnerQuery.getOwner((FileObject)fo);
        ArrayList<EjbJar> ejbmodules = new ArrayList<EjbJar>();
        ArrayList<Project> projects = new ArrayList<Project>();
        if (affectedProject != null) {
            EjbJar emod = EjbJar.getEjbJar((FileObject)affectedProject.getProjectDirectory());
            if (emod == null) {
                return Collections.emptySet();
            }
            projects.add(affectedProject);
            for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                EjbJar em;
                Set subprojects;
                Object obj;
                J2eeModuleProvider affectedPrjProvider;
                J2eeApplicationProvider j2eeApp;
                J2eeModuleProvider[] j2eeModules;
                Object isJ2eeApp = project.getLookup().lookup(J2eeApplicationProvider.class);
                if (isJ2eeApp != null && (j2eeModules = (j2eeApp = (J2eeApplicationProvider)isJ2eeApp).getChildModuleProviders()) != null && (affectedPrjProvider = (J2eeModuleProvider)affectedProject.getLookup().lookup(J2eeModuleProvider.class)) != null && Arrays.asList(j2eeModules).contains(affectedPrjProvider)) {
                    for (int k = 0; k < j2eeModules.length; ++k) {
                        FileObject srcRoot;
                        Project p;
                        FileObject[] sourceRoots = j2eeModules[k].getSourceRoots();
                        if (sourceRoots == null || sourceRoots.length <= 0 || (p = FileOwnerQuery.getOwner((FileObject)(srcRoot = sourceRoots[0]))) == null || projects.contains(p)) continue;
                        projects.add(p);
                    }
                }
                if (!((obj = project.getLookup().lookup(SubprojectProvider.class)) instanceof SubprojectProvider) || !(subprojects = ((SubprojectProvider)obj).getSubprojects()).contains(affectedProject) || (em = EjbJar.getEjbJar((FileObject)project.getProjectDirectory())) == null || projects.contains(project)) continue;
                projects.add(project);
            }
        }
        for (int j = 0; j < projects.size(); ++j) {
            Project prj = (Project)projects.get(j);
            EjbJar ejb = EjbJar.getEjbJar((FileObject)prj.getProjectDirectory());
            if (ejb == null) continue;
            ejbmodules.add(ejb);
        }
        return ejbmodules;
    }
}

