/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.output;

import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.docker.api.ActionChunkedResult;
import org.netbeans.modules.docker.api.ActionStreamResult;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.ui.output.Bundle;
import org.netbeans.modules.docker.ui.output.ChunkedResultOutputTask;
import org.netbeans.modules.docker.ui.output.ExceptionHandler;
import org.netbeans.modules.docker.ui.output.TerminalInputStream;
import org.netbeans.modules.docker.ui.output.TerminalOptionsAction;
import org.netbeans.modules.docker.ui.output.TerminalResizeListener;
import org.netbeans.modules.terminal.api.IOConnect;
import org.netbeans.modules.terminal.api.IOEmulation;
import org.netbeans.modules.terminal.api.IONotifier;
import org.netbeans.modules.terminal.api.IOResizable;
import org.netbeans.modules.terminal.api.IOTerm;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class OutputUtils {
    private static final Logger LOGGER = Logger.getLogger(OutputUtils.class.getName());
    private static final Map<DockerContainer, LogConnect> LOGS = new WeakHashMap<DockerContainer, LogConnect>();
    private static final Map<DockerContainer, InputOutput> TERMS = new WeakHashMap<DockerContainer, InputOutput>();
    private static final RequestProcessor RP = new RequestProcessor(OutputUtils.class.getName(), Integer.MAX_VALUE);

    private OutputUtils() {
    }

    public static void openLog(final DockerContainer container, final ExceptionHandler handler) {
        final LogConnect logIO = OutputUtils.getLogInputOutput(container);
        if (logIO.isConnected()) {
            logIO.getInputOutput().select();
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DockerAction facade = new DockerAction(container.getInstance());
                    ActionChunkedResult result = facade.logs(container);
                    try {
                        logIO.getInputOutput().getOut().reset();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    logIO.connect(result);
                    logIO.getInputOutput().select();
                }
                catch (DockerException ex) {
                    if (handler != null) {
                        handler.handleException((Exception)((Object)ex));
                    }
                    LOGGER.log(Level.WARNING, null, ex);
                }
            }
        });
    }

    public static void openTerminal(final DockerContainer container, final ActionStreamResult r, final boolean stdin, final boolean logs, final ExceptionHandler handler) {
        Pair<InputOutput, Boolean> termIO = OutputUtils.getTerminalInputOutput(container);
        final InputOutput io = (InputOutput)termIO.first();
        if (IOTerm.isSupported((InputOutput)io)) {
            if (((Boolean)termIO.second()).booleanValue()) {
                OutputUtils.focusTerminal(io);
            } else {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DockerAction facade = new DockerAction(container.getInstance());
                            ActionStreamResult result = r != null ? r : facade.attach(container, stdin, logs);
                            try {
                                io.getOut().reset();
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.FINE, null, ex);
                            }
                            if (!result.hasTty() && IOEmulation.isSupported((InputOutput)io)) {
                                IOEmulation.setDisciplined((InputOutput)io);
                            }
                            TerminalResizeListener l = null;
                            if (result.hasTty() && IOResizable.isSupported((InputOutput)io)) {
                                l = new TerminalResizeListener(io, container);
                                IONotifier.addPropertyChangeListener((InputOutput)io, (PropertyChangeListener)l);
                            }
                            IOTerm.connect((InputOutput)io, (OutputStream)(stdin ? result.getStdIn() : null), (InputStream)new TerminalInputStream(io, result.getStdOut(), new Closeable[]{result, l}), (InputStream)result.getStdErr(), (String)result.getCharset().name());
                            OutputUtils.focusTerminal(io);
                        }
                        catch (DockerException ex) {
                            if (handler != null) {
                                handler.handleException((Exception)((Object)ex));
                            }
                            LOGGER.log(Level.WARNING, null, ex);
                        }
                    }
                };
                if (r != null) {
                    task.run();
                } else {
                    RP.post(task);
                }
            }
        } else {
            io.select();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogConnect getLogInputOutput(DockerContainer container) {
        Map<DockerContainer, LogConnect> map = LOGS;
        synchronized (map) {
            LogConnect connect = LOGS.get(container);
            if (connect == null) {
                InputOutput io = IOProvider.getDefault().getIO(Bundle.LBL_LogInputOutput(container.getShortId()), true);
                connect = new LogConnect(io);
                LOGS.put(container, connect);
            }
            return connect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<InputOutput, Boolean> getTerminalInputOutput(DockerContainer container) {
        Map<DockerContainer, InputOutput> map = TERMS;
        synchronized (map) {
            InputOutput io = TERMS.get(container);
            if (io == null) {
                io = IOProvider.get((String)"Terminal").getIO(container.getShortId(), new Action[]{new TerminalOptionsAction()});
                TERMS.put(container, io);
                return Pair.of((Object)io, (Object)false);
            }
            return Pair.of((Object)io, (Object)(IOConnect.isSupported((InputOutput)io) && IOConnect.isConnected((InputOutput)io) ? 1 : 0));
        }
    }

    private static void focusTerminal(InputOutput io) {
        io.select();
        if (IOTerm.isSupported((InputOutput)io)) {
            IOTerm.requestFocus((InputOutput)io);
        }
    }

    private static class LogConnect {
        private final InputOutput io;
        private Future task;

        public LogConnect(InputOutput io) {
            this.io = io;
        }

        public InputOutput getInputOutput() {
            return this.io;
        }

        public synchronized void connect(ActionChunkedResult result) {
            this.task = new ChunkedResultOutputTask(this.io, result).start();
        }

        public synchronized boolean isConnected() {
            return this.task != null && !this.task.isDone();
        }
    }
}

