/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerEvent;
import org.netbeans.modules.docker.api.DockerImage;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerTag;
import org.netbeans.modules.docker.ui.node.DockerTagNode;
import org.netbeans.modules.docker.ui.node.NodeClosingFactory;
import org.netbeans.modules.docker.ui.node.Refreshable;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class DockerImagesChildFactory
extends NodeClosingFactory<DockerTag>
implements Refreshable,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(DockerImagesChildFactory.class.getName());
    private static final Comparator<DockerTag> COMPARATOR = new Comparator<DockerTag>(){

        @Override
        public int compare(DockerTag o1, DockerTag o2) {
            return o1.getTag().compareTo(o2.getTag());
        }
    };
    private final RequestProcessor requestProcessor = new RequestProcessor(DockerImagesChildFactory.class);
    private final DockerInstance instance;
    private final RequestProcessor.Task refreshTask;
    private final DockerEvent.Listener listener;

    public DockerImagesChildFactory(DockerInstance instance) {
        this.instance = instance;
        this.refreshTask = this.requestProcessor.create(new Runnable(){

            @Override
            public void run() {
                LOGGER.log(Level.FINE, "Refreshing images");
                DockerImagesChildFactory.this.refresh();
            }
        });
        this.listener = new DockerEvent.Listener(){

            public void onEvent(DockerEvent event) {
                if (DockerEvent.Status.PUSH != event.getStatus()) {
                    DockerImagesChildFactory.this.refreshTask.schedule(200);
                }
            }
        };
        instance.addImageListener(this.listener);
    }

    protected Node createNodeForKey(DockerTag key) {
        return new DockerTagNode(key);
    }

    protected boolean createKeys(List<DockerTag> toPopulate) {
        DockerAction facade = new DockerAction(this.instance);
        ArrayList<DockerTag> tags = new ArrayList<DockerTag>();
        for (DockerImage image : facade.getImages()) {
            tags.addAll(image.getTags());
        }
        tags.sort(COMPARATOR);
        toPopulate.addAll(tags);
        return true;
    }

    @Override
    public final void refresh() {
        this.refresh(false);
    }

    @Override
    public void close() {
        this.instance.removeImageListener(this.listener);
    }
}

