/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.hints;

import com.sun.source.tree.Tree;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.CdiEditorAnalysisFactory;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.hints.CDIAnnotation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public final class EditorAnnotationsHelper
implements PropertyChangeListener {
    private static ConcurrentHashMap<DataObject, EditorAnnotationsHelper> HELPERS = new ConcurrentHashMap();
    private static final RequestProcessor PROCESSOR = new RequestProcessor(EditorAnnotationsHelper.class.getName(), 1, false, false);
    private DataObject myDataObject;
    private EditorCookie.Observable myObservable;
    private AtomicReference<List<CDIAnnotation>> myModelAnnotations;
    private AtomicReference<List<CDIAnnotation>> myAnnotations;

    private EditorAnnotationsHelper(DataObject dataObject, EditorCookie.Observable observable) {
        this.myDataObject = dataObject;
        this.myObservable = observable;
        this.myModelAnnotations = new AtomicReference(Collections.emptyList());
        this.myAnnotations = new AtomicReference(Collections.emptyList());
        observable.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (("openedPanes".endsWith(evt.getPropertyName()) || evt.getPropertyName() == null) && this.myObservable.getOpenedPanes() == null) {
            this.myObservable.removePropertyChangeListener((PropertyChangeListener)this);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    HELPERS.remove(EditorAnnotationsHelper.this.myDataObject);
                    List annotations = (List)EditorAnnotationsHelper.this.myModelAnnotations.get();
                    for (CDIAnnotation annotation : annotations) {
                        annotation.detach();
                    }
                    annotations = (List)EditorAnnotationsHelper.this.myAnnotations.get();
                    for (CDIAnnotation annotation : annotations) {
                        annotation.detach();
                    }
                    EditorAnnotationsHelper.this.myModelAnnotations.set(Collections.emptyList());
                    EditorAnnotationsHelper.this.myAnnotations.set(Collections.emptyList());
                }
            };
            PROCESSOR.submit(runnable);
        }
    }

    public static EditorAnnotationsHelper getInstance(CdiAnalysisResult result) {
        return EditorAnnotationsHelper.getInstance(result.getInfo().getFileObject());
    }

    public static EditorAnnotationsHelper getInstance(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorAnnotationsHelper helper = HELPERS.get(dataObject);
            if (helper != null) {
                return helper;
            }
            EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getLookup().lookup(EditorCookie.Observable.class);
            if (observable == null) {
                return null;
            }
            helper = new EditorAnnotationsHelper(dataObject, observable);
            HELPERS.put(dataObject, helper);
            return helper;
        }
        catch (IOException ex) {
            Logger.getLogger(EditorAnnotationsHelper.class.getName()).log(Level.INFO, null, ex);
            return null;
        }
    }

    public void addInjectionPoint(CdiAnalysisResult result, VariableElement element) {
        this.addAnnotation(result, element, CDIAnnotation.CDIAnnotaitonType.INJECTION_POINT);
    }

    public void addDelegate(CdiAnalysisResult result, VariableElement element) {
        this.addAnnotation(result, element, CDIAnnotation.CDIAnnotaitonType.DELEGATE_POINT);
    }

    public void addEventInjectionPoint(ModelAnalyzer.Result result, VariableElement element) {
        this.addAnnotation(result, element, CDIAnnotation.CDIAnnotaitonType.EVENT);
    }

    public void addObserver(CdiAnalysisResult result, ExecutableElement element) {
        this.addAnnotation(result, element, CDIAnnotation.CDIAnnotaitonType.OBSERVER);
    }

    public void addInterceptedBean(CdiAnalysisResult result, TypeElement element) {
        this.addAnnotation(result, element, CDIAnnotation.CDIAnnotaitonType.INTERCEPTED_ELEMENT);
    }

    public void addInterceptedMethod(ModelAnalyzer.Result result, ExecutableElement element) {
        this.addAnnotation(result, element, CDIAnnotation.CDIAnnotaitonType.INTERCEPTED_ELEMENT);
    }

    public void addDecoratedBean(ModelAnalyzer.Result result, TypeElement element) {
        this.addAnnotation(result, element, CDIAnnotation.CDIAnnotaitonType.DECORATED_BEAN);
    }

    public void publish(final CdiAnalysisResult result) {
        Runnable runnable = new Runnable(){
            final /* synthetic */ EditorAnnotationsHelper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                AtomicReference ref;
                if (result instanceof ModelAnalyzer.Result) {
                    ref = this.this$0.myAnnotations;
                } else if (result.getClass() == CdiAnalysisResult.class) {
                    ref = this.this$0.myModelAnnotations;
                } else {
                    ref = null;
                    assert (false);
                }
                List annotations = (List)ref.get();
                for (CDIAnnotation annotation : annotations) {
                    annotation.detach();
                }
                List<CDIAnnotation> collected = result.getAnnotations();
                for (CDIAnnotation annotation : collected) {
                    annotation.attach((Annotatable)annotation.getPart());
                }
                ref.set(collected);
            }
        };
        PROCESSOR.submit(runnable);
    }

    public List<CDIAnnotation> getAnnotations() {
        List<CDIAnnotation> modelAnnotations = this.myModelAnnotations.get();
        List<CDIAnnotation> annotations = this.myAnnotations.get();
        ArrayList<CDIAnnotation> result = new ArrayList<CDIAnnotation>(modelAnnotations.size() + annotations.size());
        result.addAll(modelAnnotations);
        result.addAll(annotations);
        return result;
    }

    private void addAnnotation(CdiAnalysisResult result, Element element, CDIAnnotation.CDIAnnotaitonType type) {
        Document document;
        if (element == null) {
            return;
        }
        Tree var = result.getInfo().getTrees().getTree(element);
        if (var == null) {
            return;
        }
        List<Integer> position = CdiEditorAnalysisFactory.getElementPosition(result.getInfo(), var);
        try {
            document = result.getInfo().getDocument();
            if (!(document instanceof StyledDocument)) {
                return;
            }
        }
        catch (IOException e) {
            return;
        }
        int start = position.get(0);
        Line line = NbEditorUtilities.getLine((Document)document, (int)start, (boolean)false);
        Line.Part part = line.createPart(NbDocument.findLineColumn((StyledDocument)((StyledDocument)document), (int)start), position.get(1) - start);
        result.addAnnotation(new CDIAnnotation(type, part));
    }
}

