/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.hints.introduce.Bundle;
import org.netbeans.modules.java.hints.introduce.CommonMembersPanel;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldPanel;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.MemberValidator;
import org.netbeans.modules.java.hints.introduce.NameChangeSupport;
import org.netbeans.modules.java.hints.introduce.TargetDescription;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IntroduceMethodPanel
extends CommonMembersPanel
implements ChangeListener {
    public static final int INIT_METHOD = 1;
    public static final int INIT_FIELD = 2;
    public static final int INIT_CONSTRUCTORS = 4;
    private static final int ACCESS_PUBLIC = 1;
    private static final int ACCESS_PROTECTED = 2;
    private static final int ACCESS_DEFAULT = 3;
    private static final int ACCESS_PRIVATE = 4;
    private JButton btnOk;
    private boolean targetInterface;
    private NameChangeSupport changeSupport;
    private NotificationLineSupport notifier;
    private boolean refactorExisting = true;
    private JRadioButton accessDefault;
    private ButtonGroup accessGroup;
    private JRadioButton accessPrivate;
    private JRadioButton accessProtected;
    private JRadioButton accessPublic;
    private JCheckBox checkRefactorExisting;
    private JCheckBox duplicates;
    private ButtonGroup initilizeIn;
    private JLabel jLabel1;
    private JLabel lblAccess;
    private JLabel lblName;
    private JTextField name;
    private JComboBox target;
    private String methodNameTest;
    private Set<Modifier> accessTest;
    private Boolean replaceOtherTest;

    public IntroduceMethodPanel(String name, int duplicatesCount, Collection<TargetDescription> targets, boolean targetInterface) {
        super(targets);
        this.initComponents();
        this.targetInterface = targetInterface;
        this.changeSupport = new MethodNameSupport(this.name, true);
        this.changeSupport.setChangeListener(this);
        this.name.setText(name);
        if (name != null && name.trim().length() > 0) {
            this.name.setCaretPosition(name.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(name.length());
        }
        Preferences pref = this.getPreferences();
        if (!targetInterface) {
            int accessModifier = pref.getInt("accessModifier", 4);
            switch (accessModifier) {
                case 1: {
                    this.accessPublic.setSelected(true);
                    break;
                }
                case 2: {
                    this.accessProtected.setSelected(true);
                    break;
                }
                case 3: {
                    this.accessDefault.setSelected(true);
                    break;
                }
                case 4: {
                    this.accessPrivate.setSelected(true);
                }
            }
        } else {
            this.updateAccessVisible(false);
        }
        if (duplicatesCount == 0) {
            this.duplicates.setEnabled(false);
            this.duplicates.setSelected(false);
        } else {
            this.duplicates.setEnabled(true);
            this.duplicates.setSelected(true);
            this.duplicates.setText(this.duplicates.getText() + " (" + duplicatesCount + ")");
        }
        this.initialize(this.target, this.duplicates);
        this.updateTargetChange();
        this.target.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IntroduceMethodPanel.this.updateTargetChange();
            }
        });
    }

    public void setNotifier(NotificationLineSupport notifier) {
        this.notifier = notifier;
    }

    public void setValidator(MemberValidator validator) {
        this.changeSupport.setValidator(validator);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Modifier mustMod = this.changeSupport.getMinAccess();
        if (this.changeSupport.isValid()) {
            if (mustMod == null) {
                if (this.accessPublic.isVisible()) {
                    this.accessPublic.setEnabled(true);
                }
                if (this.accessProtected.isVisible()) {
                    this.accessProtected.setEnabled(true);
                }
                if (this.accessPrivate.isVisible()) {
                    this.accessPrivate.setEnabled(true);
                }
                if (this.accessDefault.isVisible()) {
                    this.accessDefault.setEnabled(true);
                }
                this.checkRefactorExisting.setEnabled(false);
                this.checkRefactorExisting.setSelected(false);
            } else {
                switch (mustMod) {
                    case PUBLIC: {
                        this.accessProtected.setEnabled(false);
                        this.accessPrivate.setEnabled(false);
                        this.accessDefault.setEnabled(false);
                        break;
                    }
                    case DEFAULT: {
                        this.accessProtected.setEnabled(false);
                        this.accessDefault.setEnabled(false);
                        this.accessPrivate.setEnabled(false);
                        break;
                    }
                    case PROTECTED: {
                        this.accessDefault.setEnabled(false);
                        this.accessPrivate.setEnabled(false);
                    }
                }
                this.checkRefactorExisting.setEnabled(true);
                this.checkRefactorExisting.setSelected(this.refactorExisting);
            }
            this.updateAccessSelection();
        }
        this.btnOk.setEnabled(this.changeSupport.isValid());
    }

    private void updateTargetChange() {
        int index = this.target.getSelectedIndex();
        if (index == -1) {
            this.updateAccessVisible(this.targetInterface);
            return;
        }
        TargetDescription desc = (TargetDescription)this.target.getModel().getSelectedItem();
        this.updateAccessVisible(!desc.iface);
        this.changeSupport.setTarget(desc.pathHandle);
    }

    private void updateAccessVisible(boolean v) {
        this.lblAccess.setVisible(v);
        this.accessPublic.setVisible(v);
        this.accessDefault.setVisible(v);
        this.accessPrivate.setVisible(v);
        this.accessProtected.setVisible(v);
        this.updateAccessSelection();
    }

    private boolean isAvailable(JComponent c) {
        return c.isVisible() && c.isEnabled();
    }

    private void updateAccessSelection() {
        boolean check = this.accessPrivate.isSelected();
        if (this.isAvailable(this.accessPrivate)) {
            return;
        }
        check |= this.accessProtected.isSelected();
        if (this.isAvailable(this.accessProtected)) {
            this.accessProtected.setSelected(check);
            return;
        }
        check |= this.accessDefault.isSelected();
        if (this.isAvailable(this.accessDefault)) {
            this.accessDefault.setSelected(check);
            return;
        }
        if (check) {
            this.accessPublic.setSelected(true);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(IntroduceFieldPanel.class).node("introduceField");
    }

    public void setOkButton(JButton btn) {
        this.btnOk = btn;
        this.btnOk.setEnabled(this.changeSupport.isValid());
    }

    public boolean isRefactorExisting() {
        return this.checkRefactorExisting.isEnabled() && this.checkRefactorExisting.isVisible() && this.checkRefactorExisting.isSelected();
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.lblAccess = new JLabel();
        this.accessPublic = new JRadioButton();
        this.accessProtected = new JRadioButton();
        this.accessDefault = new JRadioButton();
        this.accessPrivate = new JRadioButton();
        this.duplicates = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.target = new JComboBox();
        this.checkRefactorExisting = new JCheckBox();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceMethodPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        this.lblAccess.setLabelFor(this.accessPublic);
        Mnemonics.setLocalizedText((JLabel)this.lblAccess, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_Access"));
        this.accessGroup.add(this.accessPublic);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPublic, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_public"));
        this.accessPublic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPublic.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessProtected);
        Mnemonics.setLocalizedText((AbstractButton)this.accessProtected, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_protected"));
        this.accessProtected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessProtected.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessDefault);
        Mnemonics.setLocalizedText((AbstractButton)this.accessDefault, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_Default"));
        this.accessDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessDefault.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessPrivate);
        this.accessPrivate.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPrivate, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_private"));
        this.accessPrivate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPrivate.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.duplicates, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"IntroduceMethodPanel.duplicates.text"));
        this.jLabel1.setLabelFor(this.target);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"IntroduceMethodPanel.jLabel1.text"));
        this.target.setModel(new DefaultComboBoxModel());
        this.target.setRenderer(new CommonMembersPanel.TargetsRendererImpl());
        this.checkRefactorExisting.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.checkRefactorExisting, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"IntroduceMethodPanel.checkRefactorExisting.text"));
        this.checkRefactorExisting.setEnabled(false);
        this.checkRefactorExisting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceMethodPanel.this.checkRefactorExistingActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccess).addComponent(this.lblName)).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name, -1, 425, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.accessPublic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessProtected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessPrivate)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.target, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkRefactorExisting).addComponent(this.duplicates)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.name, -2, -1, -2).addComponent(this.lblName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAccess).addComponent(this.accessPublic).addComponent(this.accessProtected).addComponent(this.accessDefault).addComponent(this.accessPrivate)).addGap(18, 18, 18).addComponent(this.duplicates).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.target, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkRefactorExisting).addContainerGap(-1, Short.MAX_VALUE)));
        this.name.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AN_IntrMethod_Name"));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Name"));
        this.accessPublic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Public"));
        this.accessProtected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Protected"));
        this.accessDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Default"));
        this.accessPrivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Private"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Dialog"));
    }

    private void checkRefactorExistingActionPerformed(ActionEvent evt) {
        if (this.checkRefactorExisting.isEnabled()) {
            this.refactorExisting = this.checkRefactorExisting.isSelected();
        }
    }

    public String getMethodName() {
        if (this.methodNameTest != null) {
            return this.methodNameTest;
        }
        return this.name.getText();
    }

    public Set<Modifier> getAccess() {
        Set<Modifier> set;
        int val;
        if (this.accessTest != null) {
            return this.accessTest;
        }
        TargetDescription selTarget = (TargetDescription)this.target.getModel().getSelectedItem();
        if (selTarget.iface) {
            val = -1;
            set = EnumSet.of(Modifier.DEFAULT);
        } else if (this.accessPublic.isSelected()) {
            val = 1;
            set = EnumSet.of(Modifier.PUBLIC);
        } else if (this.accessProtected.isSelected()) {
            val = 2;
            set = EnumSet.of(Modifier.PROTECTED);
        } else if (this.accessDefault.isSelected()) {
            val = 3;
            set = Collections.emptySet();
        } else {
            val = 4;
            set = EnumSet.of(Modifier.PRIVATE);
        }
        if (val >= 0) {
            this.getPreferences().putInt("accessModifier", val);
        }
        return set;
    }

    public boolean getReplaceOther() {
        return this.replaceOtherTest != null ? this.replaceOtherTest.booleanValue() : this.duplicates.isSelected();
    }

    void setAccess(Set<Modifier> access) {
        this.accessTest = access;
    }

    void setMethodName(String methodName) {
        this.methodNameTest = methodName;
    }

    void setReplaceOther(boolean v) {
        this.replaceOtherTest = v;
    }

    private class MethodNameSupport
    extends NameChangeSupport {
        public MethodNameSupport(JTextField control, boolean initAsValid) {
            super(control, initAsValid);
        }

        @Override
        protected void notifyNameError(String msg) {
            IntroduceMethodPanel.this.notifier.setErrorMessage(msg);
        }

        @Override
        protected boolean updateUI(MemberSearchResult result) {
            if (result == null) {
                IntroduceMethodPanel.this.notifier.clearMessages();
                return true;
            }
            if (result.isConflicting()) {
                IntroduceMethodPanel.this.notifier.setErrorMessage(Bundle.ERR_MethodExistsOrConflict());
            } else if (result.getRequiredModifier() != null) {
                IntroduceMethodPanel.this.notifier.setWarningMessage(Bundle.WARN_OverridesRestrictedAccess());
            } else if (result.getShadowed() != null) {
                IntroduceMethodPanel.this.notifier.setInformationMessage(Bundle.INFO_MethodWillShadow());
            } else {
                IntroduceMethodPanel.this.notifier.clearMessages();
            }
            return !result.isConflicting();
        }
    }
}

