/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jdk.jshell.spi.ExecutionControl;

class ExecutionControlForwarder {
    private static final int MAX_UTF_CHARS = 21844;
    private final ExecutionControl ec;
    private final ObjectInput in;
    private final ObjectOutput out;

    ExecutionControlForwarder(ExecutionControl ec, ObjectInput in, ObjectOutput out) {
        this.ec = ec;
        this.in = in;
        this.out = out;
    }

    private boolean writeSuccess() throws IOException {
        this.writeStatus(100);
        this.flush();
        return true;
    }

    private boolean writeSuccessAndResult(String result) throws IOException {
        this.writeStatus(100);
        this.writeUTF(result);
        this.flush();
        return true;
    }

    private boolean writeSuccessAndResult(Object result) throws IOException {
        this.writeStatus(100);
        this.writeObject(result);
        this.flush();
        return true;
    }

    private void writeStatus(int status) throws IOException {
        this.out.writeInt(status);
    }

    private void writeObject(Object o) throws IOException {
        this.out.writeObject(o);
    }

    private void writeInt(int i) throws IOException {
        this.out.writeInt(i);
    }

    private void writeUTF(String s) throws IOException {
        if (s == null) {
            s = "";
        } else if (s.length() > 21844) {
            s = s.substring(0, 21844);
        }
        this.out.writeUTF(s);
    }

    private void flush() throws IOException {
        this.out.flush();
    }

    private boolean processCommand() throws IOException {
        try {
            String cmd;
            int prefix = this.in.readInt();
            if (prefix != -1069694915) {
                throw new ExecutionControl.EngineTerminationException("Invalid command prefix: " + prefix);
            }
            switch (cmd = this.in.readUTF()) {
                case "CMD_LOAD": {
                    ExecutionControl.ClassBytecodes[] cbcs = (ExecutionControl.ClassBytecodes[])this.in.readObject();
                    this.ec.load(cbcs);
                    return this.writeSuccess();
                }
                case "CMD_REDEFINE": {
                    ExecutionControl.ClassBytecodes[] cbcs = (ExecutionControl.ClassBytecodes[])this.in.readObject();
                    this.ec.redefine(cbcs);
                    return this.writeSuccess();
                }
                case "CMD_INVOKE": {
                    String className = this.in.readUTF();
                    String methodName = this.in.readUTF();
                    String res = this.ec.invoke(className, methodName);
                    return this.writeSuccessAndResult(res);
                }
                case "CMD_VAR_VALUE": {
                    String className = this.in.readUTF();
                    String varName = this.in.readUTF();
                    String res = this.ec.varValue(className, varName);
                    return this.writeSuccessAndResult(res);
                }
                case "CMD_ADD_CLASSPATH": {
                    String cp = this.in.readUTF();
                    this.ec.addToClasspath(cp);
                    return this.writeSuccess();
                }
                case "CMD_STOP": {
                    try {
                        this.ec.stop();
                    }
                    catch (Throwable cp) {
                        // empty catch block
                    }
                    return true;
                }
                case "CMD_CLOSE": {
                    try {
                        this.ec.close();
                    }
                    catch (Throwable cp) {
                        // empty catch block
                    }
                    return true;
                }
            }
            Object arg = this.in.readObject();
            Object res = this.ec.extensionCommand(cmd, arg);
            return this.writeSuccessAndResult(res);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (ExecutionControl.EngineTerminationException ex) {
            this.writeStatus(101);
            this.writeUTF(ex.getMessage());
            this.flush();
            return false;
        }
        catch (ExecutionControl.NotImplementedException ex) {
            this.writeStatus(102);
            this.writeUTF(ex.getMessage());
            this.flush();
            return true;
        }
        catch (ExecutionControl.InternalException ex) {
            this.writeStatus(103);
            this.writeUTF(ex.getMessage());
            this.flush();
            return true;
        }
        catch (ExecutionControl.ClassInstallException ex) {
            this.writeStatus(106);
            this.writeUTF(ex.getMessage());
            this.writeObject(ex.installed());
            this.flush();
            return true;
        }
        catch (ExecutionControl.UserException ex) {
            this.writeStatus(104);
            this.writeUTF(ex.getMessage());
            this.writeUTF(ex.causeExceptionClass());
            this.writeObject(ex.getStackTrace());
            this.flush();
            return true;
        }
        catch (ExecutionControl.ResolutionException ex) {
            this.writeStatus(105);
            this.writeInt(ex.id());
            this.writeObject(ex.getStackTrace());
            this.flush();
            return true;
        }
        catch (ExecutionControl.StoppedException ex) {
            this.writeStatus(107);
            this.flush();
            return true;
        }
        catch (Throwable ex) {
            this.writeStatus(101);
            this.writeUTF(ex.getMessage());
            this.flush();
            return false;
        }
    }

    void commandLoop() {
        try {
            while (this.processCommand()) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

