/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;

public class ProgressFrame
extends JFrame {
    ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    public PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private int workunits;
    private boolean finished = false;
    private JLabel msgLabel;
    private JButton okButton;
    private JPanel progressPanel;

    public ProgressFrame() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ProgressFrameTabA11yDesc"));
        this.okButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CancelButtonA11yDesc"));
        this.progressHandle = ProgressHandleFactory.createHandle(null);
        this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
        this.progressPanel.add(this.progressComponent);
        this.progressHandle.start();
        ImageIcon ideIcon = new ImageIcon("/org/netbeans/core/resources/frames/ide.gif");
        this.setIconImage(ideIcon.getImage());
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(380, 150);
        this.setLocation(dim.width / 2 - 190, dim.height / 2 - 80);
    }

    @Override
    public void dispose() {
        if (!this.finished) {
            this.progressHandle.finish();
            this.finished = true;
        }
        super.dispose();
    }

    private void initComponents() {
        this.progressPanel = new JPanel();
        this.msgLabel = new JLabel();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(this.bundle.getString("Title"));
        this.setResizable(false);
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.setMinimumSize(new Dimension(20, 20));
        this.progressPanel.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 11, 11, 11);
        this.getContentPane().add((Component)this.progressPanel, gridBagConstraints);
        this.msgLabel.setHorizontalAlignment(2);
        this.msgLabel.setText(this.bundle.getString("PreparingToCapture"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 6, 11);
        this.getContentPane().add((Component)this.msgLabel, gridBagConstraints);
        this.okButton.setText(this.bundle.getString("Close"));
        this.okButton.setHorizontalTextPosition(0);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressFrame.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 11, 11, 11);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.propertySupport.firePropertyChange("cancel", null, Boolean.TRUE);
        this.dispose();
    }

    public void setMaximum(int max) {
        this.progressHandle.switchToDeterminate(max);
        this.workunits = max;
    }

    public void setValue(final int value) {
        this.progressHandle.progress(value);
        if (value >= this.workunits) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ ProgressFrame this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    String message = MessageFormat.format(this.this$0.bundle.getString("Complete"), Integer.toString(value));
                    this.this$0.msgLabel.setText(message);
                }
            });
        }
    }

    public void setMessage(String msg) {
        this.msgLabel.setText(msg);
    }

    public void finishProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressFrame.this.progressHandle.finish();
                ProgressFrame.this.finished = true;
            }
        });
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }
}

