/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.createprojectapi;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.createprojectapi.Bundle;
import org.netbeans.modules.web.clientproject.ui.wizard.NewClientSideProjectPanel;
import org.netbeans.modules.web.clientproject.ui.wizard.ToolsPanel;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Pair;

public final class CreateProjectUtils {
    public static final String PROJECT_DIRECTORY = "PROJECT_DIRECTORY";
    public static final String PROJECT_NAME = "NAME";

    private CreateProjectUtils() {
    }

    public static Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> createBaseWizardPanel(String projectNameTemplate) {
        return Pair.of((Object)new NewClientSideProjectPanel(projectNameTemplate), (Object)Bundle.CreateProjectUtils_nameLocation_displayName());
    }

    public static Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> createToolsWizardPanel(Tools tools) {
        return Pair.of((Object)new ToolsPanel(new Tools(tools)), (Object)Bundle.CreateProjectUtils_tools_displayName());
    }

    public static Set<FileObject> instantiateTools(Project project, WizardDescriptor.FinishablePanel<WizardDescriptor> toolsPanel) throws IOException {
        if (!(toolsPanel instanceof ToolsPanel)) {
            throw new IllegalArgumentException("toolsPanel must be created by #createToolsWizardPanel() method");
        }
        HashSet<FileObject> files = new HashSet<FileObject>();
        FileObject folder = project.getProjectDirectory();
        assert (folder != null);
        Tools tools = ((ToolsPanel)toolsPanel).getTools();
        if (tools.isBower()) {
            files.add(CreateProjectUtils.createFile(folder, "bower.json", "Templates/ClientSide/bower.json"));
            String webRootPath = CreateProjectUtils.getWebRootPath(project);
            if (webRootPath != null) {
                files.add(CreateProjectUtils.createFile(folder, ".bowerrc", "Templates/ClientSide/.bowerrc", Collections.singletonMap("project", Collections.singletonMap("webRootPath", webRootPath))));
            }
        }
        if (tools.isNpm()) {
            files.add(CreateProjectUtils.createFile(folder, "package.json", "Templates/ClientSide/package.json"));
        }
        if (tools.isGrunt()) {
            files.add(CreateProjectUtils.createFile(folder, "Gruntfile.js", "Templates/ClientSide/Gruntfile.js"));
        }
        if (tools.isGulp()) {
            files.add(CreateProjectUtils.createFile(folder, "gulpfile.js", "Templates/ClientSide/gulpfile.js"));
        }
        return files;
    }

    @CheckForNull
    private static String getWebRootPath(Project project) {
        Iterator iterator = ProjectWebRootQuery.getWebRoots((Project)project).iterator();
        if (iterator.hasNext()) {
            FileObject webRoot = (FileObject)iterator.next();
            return FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)webRoot);
        }
        return null;
    }

    private static FileObject createFile(FileObject root, String file, String template) throws IOException {
        return CreateProjectUtils.createFile(root, file, template, Collections.emptyMap());
    }

    private static FileObject createFile(FileObject root, String file, String template, Map<String, Object> parameters) throws IOException {
        assert (root != null);
        assert (root.isFolder()) : root;
        FileObject target = root.getFileObject(file);
        if (target != null && target.isValid()) {
            return target;
        }
        FileObject templateFile = FileUtil.getConfigFile((String)template);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)root);
        DataObject dataIndex = DataObject.find((FileObject)templateFile);
        return dataIndex.createFromTemplate(dataFolder, null, parameters).getPrimaryFile();
    }

    public static final class Tools {
        private volatile boolean npm;
        private volatile boolean bower;
        private volatile boolean grunt;
        private volatile boolean gulp;

        public Tools() {
        }

        Tools(Tools tools) {
            this.npm = tools.npm;
            this.bower = tools.bower;
            this.grunt = tools.grunt;
            this.gulp = tools.gulp;
        }

        public static Tools all() {
            return new Tools().setNpm(true).setBower(true).setGrunt(true).setGulp(true);
        }

        public boolean isNpm() {
            return this.npm;
        }

        public Tools setNpm(boolean npm) {
            this.npm = npm;
            return this;
        }

        public boolean isBower() {
            return this.bower;
        }

        public Tools setBower(boolean bower) {
            this.bower = bower;
            return this;
        }

        public boolean isGrunt() {
            return this.grunt;
        }

        public Tools setGrunt(boolean grunt) {
            this.grunt = grunt;
            return this;
        }

        public boolean isGulp() {
            return this.gulp;
        }

        public Tools setGulp(boolean gulp) {
            this.gulp = gulp;
            return this;
        }

        public String toString() {
            return "Tools{npm=" + this.npm + ", bower=" + this.bower + ", grunt=" + this.grunt + ", gulp=" + this.gulp + '}';
        }
    }
}

