/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class JFXDownloadModePanel
extends JPanel {
    private static final Icon JAR_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javawebstart/resources/jar.gif", (boolean)false);
    private JScrollPane jScrollPane1;
    private JLabel labelDownloadMode;
    private JTable tableDownloadMode;

    public JFXDownloadModePanel(Collection<? extends File> runtimeClassPath, Collection<? extends File> lazyJars) {
        this.initComponents();
        LoadRenderer renderer = new LoadRenderer();
        this.tableDownloadMode.setModel(JFXDownloadModePanel.createModel(JFXDownloadModePanel.createResources(runtimeClassPath, lazyJars)));
        this.tableDownloadMode.setDefaultRenderer(Boolean.class, renderer);
        this.tableDownloadMode.setDefaultRenderer(File.class, renderer);
        this.tableDownloadMode.setDefaultEditor(Boolean.class, JFXDownloadModePanel.createEditor());
    }

    List<File> getResources() {
        TableModel model = this.tableDownloadMode.getModel();
        LinkedList<File> result = new LinkedList<File>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!((Boolean)model.getValueAt(i, 1)).booleanValue()) continue;
            result.add((File)model.getValueAt(i, 0));
        }
        return result;
    }

    private void initComponents() {
        this.labelDownloadMode = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableDownloadMode = new JTable();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new GridBagLayout());
        this.labelDownloadMode.setLabelFor(this.tableDownloadMode);
        Mnemonics.setLocalizedText((JLabel)this.labelDownloadMode, (String)NbBundle.getMessage(JFXDownloadModePanel.class, (String)"JFXDownloadModePanel.labelDownloadMode.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.add((Component)this.labelDownloadMode, gridBagConstraints);
        this.tableDownloadMode.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Jar", "Load"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.tableDownloadMode);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private static TableCellEditor createEditor() {
        JComboBox<Object> combo = new JComboBox<Object>(new Object[]{Boolean.TRUE, Boolean.FALSE});
        combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, NbBundle.getMessage(JFXDownloadModePanel.class, (String)(value == Boolean.TRUE ? "TXT_LAZY" : "TXT_EAGER")), index, isSelected, cellHasFocus);
            }
        });
        return new DefaultCellEditor(combo);
    }

    private static TableModel createModel(Map<File, Boolean> jars) {
        Object[][] data = new Object[jars.size()][];
        Iterator<Map.Entry<File, Boolean>> it = jars.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<File, Boolean> entry = it.next();
            data[i] = new Object[]{entry.getKey(), entry.getValue()};
            ++i;
        }
        return new DefaultTableModel(data, new String[]{NbBundle.getMessage(JFXDownloadModePanel.class, (String)"TXT_ArchiveFile"), NbBundle.getMessage(JFXDownloadModePanel.class, (String)"TXT_Load")}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return File.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                }
                throw new IllegalStateException();
            }
        };
    }

    private static Map<File, Boolean> createResources(Collection<? extends File> runtimeClassPath, Collection<? extends File> lazyJars) {
        LinkedHashMap<File, Boolean> result = new LinkedHashMap<File, Boolean>();
        HashSet<? extends File> lazy = new HashSet<File>(lazyJars);
        for (File file : runtimeClassPath) {
            result.put(file, lazy.contains(file));
        }
        return result;
    }

    private static class LoadRenderer
    extends DefaultTableCellRenderer {
        private LoadRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String strValue = "";
            String toolTip = null;
            Icon icon = null;
            if (value instanceof Boolean) {
                strValue = NbBundle.getMessage(JFXDownloadModePanel.class, (String)(value == Boolean.TRUE ? "TXT_LAZY" : "TXT_EAGER"));
            } else if (value instanceof File) {
                File f = (File)value;
                strValue = f.getName();
                toolTip = f.getAbsolutePath();
                icon = JAR_ICON;
            }
            Component c = super.getTableCellRendererComponent(table, strValue, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                label.setToolTipText(toolTip);
                label.setIcon(icon);
            }
            return c;
        }
    }
}

