/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.remote;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.netbeans.modules.web.common.remote.RemoteFS;
import org.netbeans.modules.web.common.spi.RemoteFileCacheImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class RemoteFilesCache {
    private static final RemoteFilesCache DEFAULT = new RemoteFilesCache();
    private static final String REMOTE_URL = "remote.url";
    private RequestProcessor RP2 = new RequestProcessor(RemoteFilesCache.class.getName(), 5);

    public static RemoteFilesCache getDefault() {
        return DEFAULT;
    }

    private RemoteFilesCache() {
    }

    public URL isRemoteFile(FileObject fo) {
        String remoteUrl = (String)fo.getAttribute(REMOTE_URL);
        if (remoteUrl == null) {
            return null;
        }
        try {
            return new URL(remoteUrl);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public FileObject getRemoteFile(URL url) throws IOException {
        return this.getRemoteFile(url, true);
    }

    FileObject getRemoteFile(final URL url, boolean asynchronous) throws IOException {
        final File f = RemoteFilesCache.getCachedFileName(url);
        if (!f.exists()) {
            f.createNewFile();
            if (asynchronous) {
                this.RP2.post(new Runnable(){
                    final /* synthetic */ RemoteFilesCache this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            this.this$0.fetchRemoteFile(f, url);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            } else {
                this.fetchRemoteFile(f, url);
            }
        }
        FileObject fo = FileUtil.toFileObject((File)f);
        fo.setAttribute(REMOTE_URL, (Object)url.toExternalForm());
        return fo;
    }

    static File getCachedFileName(URL url) {
        String s = url.toExternalForm();
        s = s.lastIndexOf(46) != -1 ? s.substring(s.lastIndexOf(46)) : "";
        String fileName = RemoteFilesCache.getMD5(url.toExternalForm()) + s;
        File f = new File(RemoteFilesCache.getCacheRoot(), fileName);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRemoteFile(File destination, URL url) throws IOException {
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (FileNotFoundException ex) {
            is = new ByteArrayInputStream(("file not found at " + url.toExternalForm() + " \n" + ex.toString()).getBytes());
        }
        catch (Throwable ex) {
            is = new ByteArrayInputStream(("could not open stream for " + url.toExternalForm() + " \n" + ex.toString()).getBytes());
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(destination);
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (os != null) {
                ((OutputStream)os).close();
            }
            if (is != null) {
                is.close();
            }
        }
        FileObject fo = FileUtil.toFileObject((File)destination);
        fo.refresh();
    }

    private static File getCacheRoot() {
        return Places.getCacheSubdirectory((String)"remotefiles");
    }

    private static String getMD5(String name) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
        digest.update(name.getBytes());
        byte[] hash = digest.digest();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret.append(hex);
        }
        return ret.toString();
    }

    public static class RemoteFileCacheImpl
    implements RemoteFileCacheImplementation {
        @Override
        public FileObject getRemoteFile(URL url) throws IOException {
            return RemoteFS.getDefault().getFileForURL(url);
        }

        @Override
        public URL isRemoteFile(FileObject fo) {
            return RemoteFilesCache.getDefault().isRemoteFile(fo);
        }
    }
}

