/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.beanvalidation;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.core.api.support.wizard.DelegatingWizardDescriptorPanel;
import org.netbeans.modules.javaee.beanvalidation.ValidationConfigurationIterator;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class AbstractIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel<WizardDescriptor>[] panels;

    public abstract Set<DataObject> instantiate(TemplateWizard var1) throws IOException;

    public void initialize(TemplateWizard wizard) {
        Project project = Templates.getProject((WizardDescriptor)wizard);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("web_inf");
        if (sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("doc_root");
        }
        if (sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
        }
        Object folderPanel = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups).create();
        folderPanel = new ValidationPanel(wizard, (WizardDescriptor.Panel)folderPanel);
        this.panels = new WizardDescriptor.Panel[]{folderPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = AbstractIterator.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        Templates.setTargetName((WizardDescriptor)wizard, (String)this.getDefaultName());
        Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)this.getTargetFolder(project));
    }

    public abstract String getDefaultName();

    FileObject getTargetFolder(Project project) {
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            FileObject webInf = wm.getWebInf();
            if (webInf == null) {
                try {
                    webInf = FileUtil.createFolder((FileObject)wm.getDocumentBase(), (String)"WEB-INF");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return webInf;
        }
        return project.getProjectDirectory();
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(ValidationConfigurationIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public static String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private static class ValidationPanel
    extends DelegatingWizardDescriptorPanel {
        private final TemplateWizard wizard;

        public ValidationPanel(TemplateWizard wizard, WizardDescriptor.Panel delegate) {
            super(delegate);
            this.wizard = wizard;
        }

        public boolean isValid() {
            Profile profile;
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
            if (webModule != null && (profile = webModule.getJ2eeProfile()) != null && !profile.isAtLeast(Profile.JAVA_EE_6_WEB)) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AbstractIterator.class, (String)"ERR_Wrong_JavaEE"));
                return false;
            }
            return super.isValid();
        }
    }
}

